"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _reactRelay = require("react-relay");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _keytarStrategy = require("../shared/keytar-strategy");

var _prPatchContainer = _interopRequireDefault(require("./pr-patch-container"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _errorView = _interopRequireDefault(require("../views/error-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _relayEnvironment = _interopRequireDefault(require("../views/relay-environment"));

var _reviewsController = _interopRequireDefault(require("../controllers/reviews-controller"));

var _aggregatedReviewsContainer = _interopRequireDefault(require("./aggregated-reviews-container"));

var _commentPositioningContainer = _interopRequireDefault(require("./comment-positioning-container"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReviewsContainer extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderWithToken", token => {
      if (!token) {
        return _react.default.createElement(_loadingView.default, null);
      }

      if (token instanceof Error) {
        return _react.default.createElement(_queryErrorView.default, {
          error: token,
          retry: this.handleTokenRetry,
          login: this.handleLogin,
          logout: this.handleLogout
        });
      }

      if (token === _keytarStrategy.UNAUTHENTICATED) {
        return _react.default.createElement(_githubLoginView.default, {
          onLogin: this.handleLogin
        });
      }

      if (token === _keytarStrategy.INSUFFICIENT) {
        return _react.default.createElement(_githubLoginView.default, {
          onLogin: this.handleLogin
        }, _react.default.createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
      }

      return _react.default.createElement(_prPatchContainer.default, {
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        endpoint: this.props.endpoint,
        token: token,
        largeDiffThreshold: Infinity
      }, (error, patch) => this.renderWithPatch(error, {
        token,
        patch
      }));
    });

    _defineProperty(this, "fetchToken", loginModel => loginModel.getToken(this.props.endpoint.getLoginAccount()));

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri.default)({
        branches: repository.getBranches(),
        remotes: repository.getRemotes(),
        isAbsent: repository.isAbsent(),
        isLoading: repository.isLoading(),
        isPresent: repository.isPresent(),
        isMerging: repository.isMerging(),
        isRebasing: repository.isRebasing()
      });
    });

    _defineProperty(this, "handleLogin", token => this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token));

    _defineProperty(this, "handleLogout", () => this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount()));

    _defineProperty(this, "handleTokenRetry", () => this.props.loginModel.didUpdate());
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderWithPatch(error, {
    token,
    patch
  }) {
    if (error) {
      return _react.default.createElement(_errorView.default, {
        descriptions: [error]
      });
    }

    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchRepositoryData
    }, repoData => this.renderWithRepositoryData(repoData, {
      token,
      patch
    }));
  }

  renderWithRepositoryData(repoData, {
    token,
    patch
  }) {
    const environment = _relayNetworkLayerManager.default.getEnvironmentForHost(this.props.endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/reviewsContainerQuery.graphql");

      if (node.hash && node.hash !== "b05cc30cb078003afba9bd8c2de989fa") {
        console.error("The definition of 'reviewsContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/reviewsContainerQuery.graphql");
    });

    const variables = {
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      prNumber: this.props.number,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    };
    return _react.default.createElement(_relayEnvironment.default.Provider, {
      value: environment
    }, _react.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      query: query,
      variables: variables,
      render: queryResult => this.renderWithQuery(queryResult, {
        repoData,
        patch
      })
    }));
  }

  renderWithQuery({
    error,
    props,
    retry
  }, {
    repoData,
    patch
  }) {
    if (error) {
      return _react.default.createElement(_queryErrorView.default, {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (!props || !repoData || !patch) {
      return _react.default.createElement(_loadingView.default, null);
    }

    return _react.default.createElement(_aggregatedReviewsContainer.default, {
      pullRequest: props.repository.pullRequest,
      reportRelayError: this.props.reportRelayError
    }, ({
      errors,
      summaries,
      commentThreads,
      refetch
    }) => {
      if (errors && errors.length > 0) {
        return errors.map((err, i) => _react.default.createElement(_errorView.default, {
          key: `error-${i}`,
          title: "Pagination error",
          descriptions: [err.stack]
        }));
      }

      const aggregationResult = {
        summaries,
        commentThreads,
        refetch
      };
      return this.renderWithResult({
        aggregationResult,
        queryProps: props,
        repoData,
        patch,
        refetch
      });
    });
  }

  renderWithResult({
    aggregationResult,
    queryProps,
    repoData,
    patch
  }) {
    return _react.default.createElement(_commentPositioningContainer.default, _extends({
      multiFilePatch: patch
    }, aggregationResult, {
      prCommitSha: queryProps.repository.pullRequest.headRefOid,
      localRepository: this.props.repository
    }), commentTranslations => {
      return _react.default.createElement(_reviewsController.default, _extends({}, this.props, aggregationResult, {
        commentTranslations: commentTranslations,
        localRepository: this.props.repository,
        multiFilePatch: patch,
        repository: queryProps.repository,
        pullRequest: queryProps.repository.pullRequest,
        viewer: queryProps.viewer
      }, repoData));
    });
  }

}

exports.default = ReviewsContainer;

_defineProperty(ReviewsContainer, "propTypes", {
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Pull request selection criteria
  owner: _propTypes.default.string.isRequired,
  repo: _propTypes.default.string.isRequired,
  number: _propTypes.default.number.isRequired,
  workdir: _propTypes.default.string.isRequired,
  // Package models
  repository: _propTypes.default.object.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  initThreadID: _propTypes.default.string,
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  confirm: _propTypes.default.func.isRequired,
  // Action methods
  reportRelayError: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJldmlld3MtY29udGFpbmVyLmpzIl0sIm5hbWVzIjpbIlJldmlld3NDb250YWluZXIiLCJSZWFjdCIsIkNvbXBvbmVudCIsInRva2VuIiwiRXJyb3IiLCJoYW5kbGVUb2tlblJldHJ5IiwiaGFuZGxlTG9naW4iLCJoYW5kbGVMb2dvdXQiLCJVTkFVVEhFTlRJQ0FURUQiLCJJTlNVRkZJQ0lFTlQiLCJwcm9wcyIsIm93bmVyIiwicmVwbyIsIm51bWJlciIsImVuZHBvaW50IiwiSW5maW5pdHkiLCJlcnJvciIsInBhdGNoIiwicmVuZGVyV2l0aFBhdGNoIiwibG9naW5Nb2RlbCIsImdldFRva2VuIiwiZ2V0TG9naW5BY2NvdW50IiwicmVwb3NpdG9yeSIsImJyYW5jaGVzIiwiZ2V0QnJhbmNoZXMiLCJyZW1vdGVzIiwiZ2V0UmVtb3RlcyIsImlzQWJzZW50IiwiaXNMb2FkaW5nIiwiaXNQcmVzZW50IiwiaXNNZXJnaW5nIiwiaXNSZWJhc2luZyIsInNldFRva2VuIiwicmVtb3ZlVG9rZW4iLCJkaWRVcGRhdGUiLCJyZW5kZXIiLCJmZXRjaFRva2VuIiwicmVuZGVyV2l0aFRva2VuIiwiZmV0Y2hSZXBvc2l0b3J5RGF0YSIsInJlcG9EYXRhIiwicmVuZGVyV2l0aFJlcG9zaXRvcnlEYXRhIiwiZW52aXJvbm1lbnQiLCJSZWxheU5ldHdvcmtMYXllck1hbmFnZXIiLCJnZXRFbnZpcm9ubWVudEZvckhvc3QiLCJxdWVyeSIsInZhcmlhYmxlcyIsInJlcG9Pd25lciIsInJlcG9OYW1lIiwicHJOdW1iZXIiLCJyZXZpZXdDb3VudCIsIlBBR0VfU0laRSIsInJldmlld0N1cnNvciIsInRocmVhZENvdW50IiwidGhyZWFkQ3Vyc29yIiwiY29tbWVudENvdW50IiwiY29tbWVudEN1cnNvciIsInF1ZXJ5UmVzdWx0IiwicmVuZGVyV2l0aFF1ZXJ5IiwicmV0cnkiLCJwdWxsUmVxdWVzdCIsInJlcG9ydFJlbGF5RXJyb3IiLCJlcnJvcnMiLCJzdW1tYXJpZXMiLCJjb21tZW50VGhyZWFkcyIsInJlZmV0Y2giLCJsZW5ndGgiLCJtYXAiLCJlcnIiLCJpIiwic3RhY2siLCJhZ2dyZWdhdGlvblJlc3VsdCIsInJlbmRlcldpdGhSZXN1bHQiLCJxdWVyeVByb3BzIiwiaGVhZFJlZk9pZCIsImNvbW1lbnRUcmFuc2xhdGlvbnMiLCJ2aWV3ZXIiLCJFbmRwb2ludFByb3BUeXBlIiwiaXNSZXF1aXJlZCIsIlByb3BUeXBlcyIsInN0cmluZyIsIndvcmtkaXIiLCJvYmplY3QiLCJHaXRodWJMb2dpbk1vZGVsUHJvcFR5cGUiLCJ3b3JrZGlyQ29udGV4dFBvb2wiLCJXb3JrZGlyQ29udGV4dFBvb2xQcm9wVHlwZSIsImluaXRUaHJlYWRJRCIsIndvcmtzcGFjZSIsImNvbmZpZyIsImNvbW1hbmRzIiwidG9vbHRpcHMiLCJjb25maXJtIiwiZnVuYyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUNBOztBQUVBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOztBQUNBOzs7Ozs7Ozs7O0FBRWUsTUFBTUEsZ0JBQU4sU0FBK0JDLGVBQU1DLFNBQXJDLENBQStDO0FBQUE7QUFBQTs7QUFBQSw2Q0FvQzFDQyxLQUFLLElBQUk7QUFDekIsVUFBSSxDQUFDQSxLQUFMLEVBQVk7QUFDVixlQUFPLDZCQUFDLG9CQUFELE9BQVA7QUFDRDs7QUFFRCxVQUFJQSxLQUFLLFlBQVlDLEtBQXJCLEVBQTRCO0FBQzFCLGVBQ0UsNkJBQUMsdUJBQUQ7QUFDRSxVQUFBLEtBQUssRUFBRUQsS0FEVDtBQUVFLFVBQUEsS0FBSyxFQUFFLEtBQUtFLGdCQUZkO0FBR0UsVUFBQSxLQUFLLEVBQUUsS0FBS0MsV0FIZDtBQUlFLFVBQUEsTUFBTSxFQUFFLEtBQUtDO0FBSmYsVUFERjtBQVFEOztBQUVELFVBQUlKLEtBQUssS0FBS0ssK0JBQWQsRUFBK0I7QUFDN0IsZUFBTyw2QkFBQyx3QkFBRDtBQUFpQixVQUFBLE9BQU8sRUFBRSxLQUFLRjtBQUEvQixVQUFQO0FBQ0Q7O0FBRUQsVUFBSUgsS0FBSyxLQUFLTSw0QkFBZCxFQUE0QjtBQUMxQixlQUNFLDZCQUFDLHdCQUFEO0FBQWlCLFVBQUEsT0FBTyxFQUFFLEtBQUtIO0FBQS9CLFdBQ0UsNklBREYsQ0FERjtBQU9EOztBQUVELGFBQ0UsNkJBQUMseUJBQUQ7QUFDRSxRQUFBLEtBQUssRUFBRSxLQUFLSSxLQUFMLENBQVdDLEtBRHBCO0FBRUUsUUFBQSxJQUFJLEVBQUUsS0FBS0QsS0FBTCxDQUFXRSxJQUZuQjtBQUdFLFFBQUEsTUFBTSxFQUFFLEtBQUtGLEtBQUwsQ0FBV0csTUFIckI7QUFJRSxRQUFBLFFBQVEsRUFBRSxLQUFLSCxLQUFMLENBQVdJLFFBSnZCO0FBS0UsUUFBQSxLQUFLLEVBQUVYLEtBTFQ7QUFNRSxRQUFBLGtCQUFrQixFQUFFWTtBQU50QixTQU9HLENBQUNDLEtBQUQsRUFBUUMsS0FBUixLQUFrQixLQUFLQyxlQUFMLENBQXFCRixLQUFyQixFQUE0QjtBQUFDYixRQUFBQSxLQUFEO0FBQVFjLFFBQUFBO0FBQVIsT0FBNUIsQ0FQckIsQ0FERjtBQVdELEtBN0UyRDs7QUFBQSx3Q0E2Ti9DRSxVQUFVLElBQUlBLFVBQVUsQ0FBQ0MsUUFBWCxDQUFvQixLQUFLVixLQUFMLENBQVdJLFFBQVgsQ0FBb0JPLGVBQXBCLEVBQXBCLENBN05pQzs7QUFBQSxpREErTnRDQyxVQUFVLElBQUk7QUFDbEMsYUFBTyx1QkFBUztBQUNkQyxRQUFBQSxRQUFRLEVBQUVELFVBQVUsQ0FBQ0UsV0FBWCxFQURJO0FBRWRDLFFBQUFBLE9BQU8sRUFBRUgsVUFBVSxDQUFDSSxVQUFYLEVBRks7QUFHZEMsUUFBQUEsUUFBUSxFQUFFTCxVQUFVLENBQUNLLFFBQVgsRUFISTtBQUlkQyxRQUFBQSxTQUFTLEVBQUVOLFVBQVUsQ0FBQ00sU0FBWCxFQUpHO0FBS2RDLFFBQUFBLFNBQVMsRUFBRVAsVUFBVSxDQUFDTyxTQUFYLEVBTEc7QUFNZEMsUUFBQUEsU0FBUyxFQUFFUixVQUFVLENBQUNRLFNBQVgsRUFORztBQU9kQyxRQUFBQSxVQUFVLEVBQUVULFVBQVUsQ0FBQ1MsVUFBWDtBQVBFLE9BQVQsQ0FBUDtBQVNELEtBek8yRDs7QUFBQSx5Q0EyTzlDNUIsS0FBSyxJQUFJLEtBQUtPLEtBQUwsQ0FBV1MsVUFBWCxDQUFzQmEsUUFBdEIsQ0FBK0IsS0FBS3RCLEtBQUwsQ0FBV0ksUUFBWCxDQUFvQk8sZUFBcEIsRUFBL0IsRUFBc0VsQixLQUF0RSxDQTNPcUM7O0FBQUEsMENBNk83QyxNQUFNLEtBQUtPLEtBQUwsQ0FBV1MsVUFBWCxDQUFzQmMsV0FBdEIsQ0FBa0MsS0FBS3ZCLEtBQUwsQ0FBV0ksUUFBWCxDQUFvQk8sZUFBcEIsRUFBbEMsQ0E3T3VDOztBQUFBLDhDQStPekMsTUFBTSxLQUFLWCxLQUFMLENBQVdTLFVBQVgsQ0FBc0JlLFNBQXRCLEVBL09tQztBQUFBOztBQTRCNURDLEVBQUFBLE1BQU0sR0FBRztBQUNQLFdBQ0UsNkJBQUMscUJBQUQ7QUFBYyxNQUFBLEtBQUssRUFBRSxLQUFLekIsS0FBTCxDQUFXUyxVQUFoQztBQUE0QyxNQUFBLFNBQVMsRUFBRSxLQUFLaUI7QUFBNUQsT0FDRyxLQUFLQyxlQURSLENBREY7QUFLRDs7QUE2Q0RuQixFQUFBQSxlQUFlLENBQUNGLEtBQUQsRUFBUTtBQUFDYixJQUFBQSxLQUFEO0FBQVFjLElBQUFBO0FBQVIsR0FBUixFQUF3QjtBQUNyQyxRQUFJRCxLQUFKLEVBQVc7QUFDVCxhQUFPLDZCQUFDLGtCQUFEO0FBQVcsUUFBQSxZQUFZLEVBQUUsQ0FBQ0EsS0FBRDtBQUF6QixRQUFQO0FBQ0Q7O0FBRUQsV0FDRSw2QkFBQyxxQkFBRDtBQUFjLE1BQUEsS0FBSyxFQUFFLEtBQUtOLEtBQUwsQ0FBV1ksVUFBaEM7QUFBNEMsTUFBQSxTQUFTLEVBQUUsS0FBS2dCO0FBQTVELE9BQ0dDLFFBQVEsSUFBSSxLQUFLQyx3QkFBTCxDQUE4QkQsUUFBOUIsRUFBd0M7QUFBQ3BDLE1BQUFBLEtBQUQ7QUFBUWMsTUFBQUE7QUFBUixLQUF4QyxDQURmLENBREY7QUFLRDs7QUFFRHVCLEVBQUFBLHdCQUF3QixDQUFDRCxRQUFELEVBQVc7QUFBQ3BDLElBQUFBLEtBQUQ7QUFBUWMsSUFBQUE7QUFBUixHQUFYLEVBQTJCO0FBQ2pELFVBQU13QixXQUFXLEdBQUdDLGtDQUF5QkMscUJBQXpCLENBQStDLEtBQUtqQyxLQUFMLENBQVdJLFFBQTFELEVBQW9FWCxLQUFwRSxDQUFwQjs7QUFDQSxVQUFNeUMsS0FBSztBQUFBOztBQUFBO0FBQUE7QUFBQTs7QUFBQTtBQUFBLE1BQVg7O0FBa0NBLFVBQU1DLFNBQVMsR0FBRztBQUNoQkMsTUFBQUEsU0FBUyxFQUFFLEtBQUtwQyxLQUFMLENBQVdDLEtBRE47QUFFaEJvQyxNQUFBQSxRQUFRLEVBQUUsS0FBS3JDLEtBQUwsQ0FBV0UsSUFGTDtBQUdoQm9DLE1BQUFBLFFBQVEsRUFBRSxLQUFLdEMsS0FBTCxDQUFXRyxNQUhMO0FBSWhCb0MsTUFBQUEsV0FBVyxFQUFFQyxrQkFKRztBQUtoQkMsTUFBQUEsWUFBWSxFQUFFLElBTEU7QUFNaEJDLE1BQUFBLFdBQVcsRUFBRUYsa0JBTkc7QUFPaEJHLE1BQUFBLFlBQVksRUFBRSxJQVBFO0FBUWhCQyxNQUFBQSxZQUFZLEVBQUVKLGtCQVJFO0FBU2hCSyxNQUFBQSxhQUFhLEVBQUU7QUFUQyxLQUFsQjtBQVlBLFdBQ0UsNkJBQUMseUJBQUQsQ0FBa0IsUUFBbEI7QUFBMkIsTUFBQSxLQUFLLEVBQUVkO0FBQWxDLE9BQ0UsNkJBQUMseUJBQUQ7QUFDRSxNQUFBLFdBQVcsRUFBRUEsV0FEZjtBQUVFLE1BQUEsS0FBSyxFQUFFRyxLQUZUO0FBR0UsTUFBQSxTQUFTLEVBQUVDLFNBSGI7QUFJRSxNQUFBLE1BQU0sRUFBRVcsV0FBVyxJQUFJLEtBQUtDLGVBQUwsQ0FBcUJELFdBQXJCLEVBQWtDO0FBQUNqQixRQUFBQSxRQUFEO0FBQVd0QixRQUFBQTtBQUFYLE9BQWxDO0FBSnpCLE1BREYsQ0FERjtBQVVEOztBQUVEd0MsRUFBQUEsZUFBZSxDQUFDO0FBQUN6QyxJQUFBQSxLQUFEO0FBQVFOLElBQUFBLEtBQVI7QUFBZWdELElBQUFBO0FBQWYsR0FBRCxFQUF3QjtBQUFDbkIsSUFBQUEsUUFBRDtBQUFXdEIsSUFBQUE7QUFBWCxHQUF4QixFQUEyQztBQUN4RCxRQUFJRCxLQUFKLEVBQVc7QUFDVCxhQUNFLDZCQUFDLHVCQUFEO0FBQ0UsUUFBQSxLQUFLLEVBQUVBLEtBRFQ7QUFFRSxRQUFBLEtBQUssRUFBRSxLQUFLVixXQUZkO0FBR0UsUUFBQSxLQUFLLEVBQUVvRCxLQUhUO0FBSUUsUUFBQSxNQUFNLEVBQUUsS0FBS25EO0FBSmYsUUFERjtBQVFEOztBQUVELFFBQUksQ0FBQ0csS0FBRCxJQUFVLENBQUM2QixRQUFYLElBQXVCLENBQUN0QixLQUE1QixFQUFtQztBQUNqQyxhQUFPLDZCQUFDLG9CQUFELE9BQVA7QUFDRDs7QUFFRCxXQUNFLDZCQUFDLG1DQUFEO0FBQ0UsTUFBQSxXQUFXLEVBQUVQLEtBQUssQ0FBQ1ksVUFBTixDQUFpQnFDLFdBRGhDO0FBRUUsTUFBQSxnQkFBZ0IsRUFBRSxLQUFLakQsS0FBTCxDQUFXa0Q7QUFGL0IsT0FHRyxDQUFDO0FBQUNDLE1BQUFBLE1BQUQ7QUFBU0MsTUFBQUEsU0FBVDtBQUFvQkMsTUFBQUEsY0FBcEI7QUFBb0NDLE1BQUFBO0FBQXBDLEtBQUQsS0FBa0Q7QUFDakQsVUFBSUgsTUFBTSxJQUFJQSxNQUFNLENBQUNJLE1BQVAsR0FBZ0IsQ0FBOUIsRUFBaUM7QUFDL0IsZUFBT0osTUFBTSxDQUFDSyxHQUFQLENBQVcsQ0FBQ0MsR0FBRCxFQUFNQyxDQUFOLEtBQ2hCLDZCQUFDLGtCQUFEO0FBQ0UsVUFBQSxHQUFHLEVBQUcsU0FBUUEsQ0FBRSxFQURsQjtBQUVFLFVBQUEsS0FBSyxFQUFDLGtCQUZSO0FBR0UsVUFBQSxZQUFZLEVBQUUsQ0FBQ0QsR0FBRyxDQUFDRSxLQUFMO0FBSGhCLFVBREssQ0FBUDtBQU9EOztBQUNELFlBQU1DLGlCQUFpQixHQUFHO0FBQUNSLFFBQUFBLFNBQUQ7QUFBWUMsUUFBQUEsY0FBWjtBQUE0QkMsUUFBQUE7QUFBNUIsT0FBMUI7QUFFQSxhQUFPLEtBQUtPLGdCQUFMLENBQXNCO0FBQzNCRCxRQUFBQSxpQkFEMkI7QUFFM0JFLFFBQUFBLFVBQVUsRUFBRTlELEtBRmU7QUFHM0I2QixRQUFBQSxRQUgyQjtBQUkzQnRCLFFBQUFBLEtBSjJCO0FBSzNCK0MsUUFBQUE7QUFMMkIsT0FBdEIsQ0FBUDtBQU9ELEtBdEJILENBREY7QUEwQkQ7O0FBRURPLEVBQUFBLGdCQUFnQixDQUFDO0FBQUNELElBQUFBLGlCQUFEO0FBQW9CRSxJQUFBQSxVQUFwQjtBQUFnQ2pDLElBQUFBLFFBQWhDO0FBQTBDdEIsSUFBQUE7QUFBMUMsR0FBRCxFQUFtRDtBQUNqRSxXQUNFLDZCQUFDLG9DQUFEO0FBQ0UsTUFBQSxjQUFjLEVBQUVBO0FBRGxCLE9BRU1xRCxpQkFGTjtBQUdFLE1BQUEsV0FBVyxFQUFFRSxVQUFVLENBQUNsRCxVQUFYLENBQXNCcUMsV0FBdEIsQ0FBa0NjLFVBSGpEO0FBSUUsTUFBQSxlQUFlLEVBQUUsS0FBSy9ELEtBQUwsQ0FBV1k7QUFKOUIsUUFLR29ELG1CQUFtQixJQUFJO0FBQ3RCLGFBQ0UsNkJBQUMsMEJBQUQsZUFDTSxLQUFLaEUsS0FEWCxFQUVNNEQsaUJBRk47QUFHRSxRQUFBLG1CQUFtQixFQUFFSSxtQkFIdkI7QUFJRSxRQUFBLGVBQWUsRUFBRSxLQUFLaEUsS0FBTCxDQUFXWSxVQUo5QjtBQUtFLFFBQUEsY0FBYyxFQUFFTCxLQUxsQjtBQU1FLFFBQUEsVUFBVSxFQUFFdUQsVUFBVSxDQUFDbEQsVUFOekI7QUFPRSxRQUFBLFdBQVcsRUFBRWtELFVBQVUsQ0FBQ2xELFVBQVgsQ0FBc0JxQyxXQVByQztBQVFFLFFBQUEsTUFBTSxFQUFFYSxVQUFVLENBQUNHO0FBUnJCLFNBU01wQyxRQVROLEVBREY7QUFhRCxLQW5CSCxDQURGO0FBdUJEOztBQTNOMkQ7Ozs7Z0JBQXpDdkMsZ0IsZUFDQTtBQUNqQjtBQUNBYyxFQUFBQSxRQUFRLEVBQUU4RCw2QkFBaUJDLFVBRlY7QUFJakI7QUFDQWxFLEVBQUFBLEtBQUssRUFBRW1FLG1CQUFVQyxNQUFWLENBQWlCRixVQUxQO0FBTWpCakUsRUFBQUEsSUFBSSxFQUFFa0UsbUJBQVVDLE1BQVYsQ0FBaUJGLFVBTk47QUFPakJoRSxFQUFBQSxNQUFNLEVBQUVpRSxtQkFBVWpFLE1BQVYsQ0FBaUJnRSxVQVBSO0FBUWpCRyxFQUFBQSxPQUFPLEVBQUVGLG1CQUFVQyxNQUFWLENBQWlCRixVQVJUO0FBVWpCO0FBQ0F2RCxFQUFBQSxVQUFVLEVBQUV3RCxtQkFBVUcsTUFBVixDQUFpQkosVUFYWjtBQVlqQjFELEVBQUFBLFVBQVUsRUFBRStELHFDQUF5QkwsVUFacEI7QUFhakJNLEVBQUFBLGtCQUFrQixFQUFFQyx1Q0FBMkJQLFVBYjlCO0FBY2pCUSxFQUFBQSxZQUFZLEVBQUVQLG1CQUFVQyxNQWRQO0FBZ0JqQjtBQUNBTyxFQUFBQSxTQUFTLEVBQUVSLG1CQUFVRyxNQUFWLENBQWlCSixVQWpCWDtBQWtCakJVLEVBQUFBLE1BQU0sRUFBRVQsbUJBQVVHLE1BQVYsQ0FBaUJKLFVBbEJSO0FBbUJqQlcsRUFBQUEsUUFBUSxFQUFFVixtQkFBVUcsTUFBVixDQUFpQkosVUFuQlY7QUFvQmpCWSxFQUFBQSxRQUFRLEVBQUVYLG1CQUFVRyxNQUFWLENBQWlCSixVQXBCVjtBQXFCakJhLEVBQUFBLE9BQU8sRUFBRVosbUJBQVVhLElBQVYsQ0FBZWQsVUFyQlA7QUF1QmpCO0FBQ0FqQixFQUFBQSxnQkFBZ0IsRUFBRWtCLG1CQUFVYSxJQUFWLENBQWVkO0FBeEJoQixDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IHl1YmlraXJpIGZyb20gJ3l1YmlraXJpJztcbmltcG9ydCB7UXVlcnlSZW5kZXJlciwgZ3JhcGhxbH0gZnJvbSAncmVhY3QtcmVsYXknO1xuXG5pbXBvcnQge1BBR0VfU0laRX0gZnJvbSAnLi4vaGVscGVycyc7XG5pbXBvcnQge0dpdGh1YkxvZ2luTW9kZWxQcm9wVHlwZSwgRW5kcG9pbnRQcm9wVHlwZSwgV29ya2RpckNvbnRleHRQb29sUHJvcFR5cGV9IGZyb20gJy4uL3Byb3AtdHlwZXMnO1xuaW1wb3J0IHtVTkFVVEhFTlRJQ0FURUQsIElOU1VGRklDSUVOVH0gZnJvbSAnLi4vc2hhcmVkL2tleXRhci1zdHJhdGVneSc7XG5pbXBvcnQgUHVsbFJlcXVlc3RQYXRjaENvbnRhaW5lciBmcm9tICcuL3ByLXBhdGNoLWNvbnRhaW5lcic7XG5pbXBvcnQgT2JzZXJ2ZU1vZGVsIGZyb20gJy4uL3ZpZXdzL29ic2VydmUtbW9kZWwnO1xuaW1wb3J0IExvYWRpbmdWaWV3IGZyb20gJy4uL3ZpZXdzL2xvYWRpbmctdmlldyc7XG5pbXBvcnQgR2l0aHViTG9naW5WaWV3IGZyb20gJy4uL3ZpZXdzL2dpdGh1Yi1sb2dpbi12aWV3JztcbmltcG9ydCBFcnJvclZpZXcgZnJvbSAnLi4vdmlld3MvZXJyb3Itdmlldyc7XG5pbXBvcnQgUXVlcnlFcnJvclZpZXcgZnJvbSAnLi4vdmlld3MvcXVlcnktZXJyb3Itdmlldyc7XG5pbXBvcnQgUmVsYXlOZXR3b3JrTGF5ZXJNYW5hZ2VyIGZyb20gJy4uL3JlbGF5LW5ldHdvcmstbGF5ZXItbWFuYWdlcic7XG5pbXBvcnQgUmVsYXlFbnZpcm9ubWVudCBmcm9tICcuLi92aWV3cy9yZWxheS1lbnZpcm9ubWVudCc7XG5pbXBvcnQgUmV2aWV3c0NvbnRyb2xsZXIgZnJvbSAnLi4vY29udHJvbGxlcnMvcmV2aWV3cy1jb250cm9sbGVyJztcbmltcG9ydCBBZ2dyZWdhdGVkUmV2aWV3c0NvbnRhaW5lciBmcm9tICcuL2FnZ3JlZ2F0ZWQtcmV2aWV3cy1jb250YWluZXInO1xuaW1wb3J0IENvbW1lbnRQb3NpdGlvbmluZ0NvbnRhaW5lciBmcm9tICcuL2NvbW1lbnQtcG9zaXRpb25pbmctY29udGFpbmVyJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgUmV2aWV3c0NvbnRhaW5lciBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgLy8gQ29ubmVjdGlvblxuICAgIGVuZHBvaW50OiBFbmRwb2ludFByb3BUeXBlLmlzUmVxdWlyZWQsXG5cbiAgICAvLyBQdWxsIHJlcXVlc3Qgc2VsZWN0aW9uIGNyaXRlcmlhXG4gICAgb3duZXI6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICByZXBvOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgbnVtYmVyOiBQcm9wVHlwZXMubnVtYmVyLmlzUmVxdWlyZWQsXG4gICAgd29ya2RpcjogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuXG4gICAgLy8gUGFja2FnZSBtb2RlbHNcbiAgICByZXBvc2l0b3J5OiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgbG9naW5Nb2RlbDogR2l0aHViTG9naW5Nb2RlbFByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgd29ya2RpckNvbnRleHRQb29sOiBXb3JrZGlyQ29udGV4dFBvb2xQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIGluaXRUaHJlYWRJRDogUHJvcFR5cGVzLnN0cmluZyxcblxuICAgIC8vIEF0b20gZW52aXJvbm1lbnRcbiAgICB3b3Jrc3BhY2U6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBjb25maWc6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBjb21tYW5kczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIHRvb2x0aXBzOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgY29uZmlybTogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcblxuICAgIC8vIEFjdGlvbiBtZXRob2RzXG4gICAgcmVwb3J0UmVsYXlFcnJvcjogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPE9ic2VydmVNb2RlbCBtb2RlbD17dGhpcy5wcm9wcy5sb2dpbk1vZGVsfSBmZXRjaERhdGE9e3RoaXMuZmV0Y2hUb2tlbn0+XG4gICAgICAgIHt0aGlzLnJlbmRlcldpdGhUb2tlbn1cbiAgICAgIDwvT2JzZXJ2ZU1vZGVsPlxuICAgICk7XG4gIH1cblxuICByZW5kZXJXaXRoVG9rZW4gPSB0b2tlbiA9PiB7XG4gICAgaWYgKCF0b2tlbikge1xuICAgICAgcmV0dXJuIDxMb2FkaW5nVmlldyAvPjtcbiAgICB9XG5cbiAgICBpZiAodG9rZW4gaW5zdGFuY2VvZiBFcnJvcikge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPFF1ZXJ5RXJyb3JWaWV3XG4gICAgICAgICAgZXJyb3I9e3Rva2VufVxuICAgICAgICAgIHJldHJ5PXt0aGlzLmhhbmRsZVRva2VuUmV0cnl9XG4gICAgICAgICAgbG9naW49e3RoaXMuaGFuZGxlTG9naW59XG4gICAgICAgICAgbG9nb3V0PXt0aGlzLmhhbmRsZUxvZ291dH1cbiAgICAgICAgLz5cbiAgICAgICk7XG4gICAgfVxuXG4gICAgaWYgKHRva2VuID09PSBVTkFVVEhFTlRJQ0FURUQpIHtcbiAgICAgIHJldHVybiA8R2l0aHViTG9naW5WaWV3IG9uTG9naW49e3RoaXMuaGFuZGxlTG9naW59IC8+O1xuICAgIH1cblxuICAgIGlmICh0b2tlbiA9PT0gSU5TVUZGSUNJRU5UKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8R2l0aHViTG9naW5WaWV3IG9uTG9naW49e3RoaXMuaGFuZGxlTG9naW59PlxuICAgICAgICAgIDxwPlxuICAgICAgICAgICAgWW91ciB0b2tlbiBubyBsb25nZXIgaGFzIHN1ZmZpY2llbnQgYXV0aG9yaXphdGlvbnMuIFBsZWFzZSByZS1hdXRoZW50aWNhdGUgYW5kIGdlbmVyYXRlIGEgbmV3IG9uZS5cbiAgICAgICAgICA8L3A+XG4gICAgICAgIDwvR2l0aHViTG9naW5WaWV3PlxuICAgICAgKTtcbiAgICB9XG5cbiAgICByZXR1cm4gKFxuICAgICAgPFB1bGxSZXF1ZXN0UGF0Y2hDb250YWluZXJcbiAgICAgICAgb3duZXI9e3RoaXMucHJvcHMub3duZXJ9XG4gICAgICAgIHJlcG89e3RoaXMucHJvcHMucmVwb31cbiAgICAgICAgbnVtYmVyPXt0aGlzLnByb3BzLm51bWJlcn1cbiAgICAgICAgZW5kcG9pbnQ9e3RoaXMucHJvcHMuZW5kcG9pbnR9XG4gICAgICAgIHRva2VuPXt0b2tlbn1cbiAgICAgICAgbGFyZ2VEaWZmVGhyZXNob2xkPXtJbmZpbml0eX0+XG4gICAgICAgIHsoZXJyb3IsIHBhdGNoKSA9PiB0aGlzLnJlbmRlcldpdGhQYXRjaChlcnJvciwge3Rva2VuLCBwYXRjaH0pfVxuICAgICAgPC9QdWxsUmVxdWVzdFBhdGNoQ29udGFpbmVyPlxuICAgICk7XG4gIH1cblxuICByZW5kZXJXaXRoUGF0Y2goZXJyb3IsIHt0b2tlbiwgcGF0Y2h9KSB7XG4gICAgaWYgKGVycm9yKSB7XG4gICAgICByZXR1cm4gPEVycm9yVmlldyBkZXNjcmlwdGlvbnM9e1tlcnJvcl19IC8+O1xuICAgIH1cblxuICAgIHJldHVybiAoXG4gICAgICA8T2JzZXJ2ZU1vZGVsIG1vZGVsPXt0aGlzLnByb3BzLnJlcG9zaXRvcnl9IGZldGNoRGF0YT17dGhpcy5mZXRjaFJlcG9zaXRvcnlEYXRhfT5cbiAgICAgICAge3JlcG9EYXRhID0+IHRoaXMucmVuZGVyV2l0aFJlcG9zaXRvcnlEYXRhKHJlcG9EYXRhLCB7dG9rZW4sIHBhdGNofSl9XG4gICAgICA8L09ic2VydmVNb2RlbD5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyV2l0aFJlcG9zaXRvcnlEYXRhKHJlcG9EYXRhLCB7dG9rZW4sIHBhdGNofSkge1xuICAgIGNvbnN0IGVudmlyb25tZW50ID0gUmVsYXlOZXR3b3JrTGF5ZXJNYW5hZ2VyLmdldEVudmlyb25tZW50Rm9ySG9zdCh0aGlzLnByb3BzLmVuZHBvaW50LCB0b2tlbik7XG4gICAgY29uc3QgcXVlcnkgPSBncmFwaHFsYFxuICAgICAgcXVlcnkgcmV2aWV3c0NvbnRhaW5lclF1ZXJ5XG4gICAgICAoXG4gICAgICAgICRyZXBvT3duZXI6IFN0cmluZyFcbiAgICAgICAgJHJlcG9OYW1lOiBTdHJpbmchXG4gICAgICAgICRwck51bWJlcjogSW50IVxuICAgICAgICAkcmV2aWV3Q291bnQ6IEludCFcbiAgICAgICAgJHJldmlld0N1cnNvcjogU3RyaW5nXG4gICAgICAgICR0aHJlYWRDb3VudDogSW50IVxuICAgICAgICAkdGhyZWFkQ3Vyc29yOiBTdHJpbmdcbiAgICAgICAgJGNvbW1lbnRDb3VudDogSW50IVxuICAgICAgICAkY29tbWVudEN1cnNvcjogU3RyaW5nXG4gICAgICApIHtcbiAgICAgICAgcmVwb3NpdG9yeShvd25lcjogJHJlcG9Pd25lciwgbmFtZTogJHJlcG9OYW1lKSB7XG4gICAgICAgICAgLi4ucmV2aWV3c0NvbnRyb2xsZXJfcmVwb3NpdG9yeVxuICAgICAgICAgIHB1bGxSZXF1ZXN0KG51bWJlcjogJHByTnVtYmVyKSB7XG4gICAgICAgICAgICBoZWFkUmVmT2lkXG4gICAgICAgICAgICAuLi5hZ2dyZWdhdGVkUmV2aWV3c0NvbnRhaW5lcl9wdWxsUmVxdWVzdCBAYXJndW1lbnRzKFxuICAgICAgICAgICAgICByZXZpZXdDb3VudDogJHJldmlld0NvdW50XG4gICAgICAgICAgICAgIHJldmlld0N1cnNvcjogJHJldmlld0N1cnNvclxuICAgICAgICAgICAgICB0aHJlYWRDb3VudDogJHRocmVhZENvdW50XG4gICAgICAgICAgICAgIHRocmVhZEN1cnNvcjogJHRocmVhZEN1cnNvclxuICAgICAgICAgICAgICBjb21tZW50Q291bnQ6ICRjb21tZW50Q291bnRcbiAgICAgICAgICAgICAgY29tbWVudEN1cnNvcjogJGNvbW1lbnRDdXJzb3JcbiAgICAgICAgICAgIClcbiAgICAgICAgICAgIC4uLnJldmlld3NDb250cm9sbGVyX3B1bGxSZXF1ZXN0XG4gICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgdmlld2VyIHtcbiAgICAgICAgICAuLi5yZXZpZXdzQ29udHJvbGxlcl92aWV3ZXJcbiAgICAgICAgfVxuICAgICAgfVxuICAgIGA7XG4gICAgY29uc3QgdmFyaWFibGVzID0ge1xuICAgICAgcmVwb093bmVyOiB0aGlzLnByb3BzLm93bmVyLFxuICAgICAgcmVwb05hbWU6IHRoaXMucHJvcHMucmVwbyxcbiAgICAgIHByTnVtYmVyOiB0aGlzLnByb3BzLm51bWJlcixcbiAgICAgIHJldmlld0NvdW50OiBQQUdFX1NJWkUsXG4gICAgICByZXZpZXdDdXJzb3I6IG51bGwsXG4gICAgICB0aHJlYWRDb3VudDogUEFHRV9TSVpFLFxuICAgICAgdGhyZWFkQ3Vyc29yOiBudWxsLFxuICAgICAgY29tbWVudENvdW50OiBQQUdFX1NJWkUsXG4gICAgICBjb21tZW50Q3Vyc29yOiBudWxsLFxuICAgIH07XG5cbiAgICByZXR1cm4gKFxuICAgICAgPFJlbGF5RW52aXJvbm1lbnQuUHJvdmlkZXIgdmFsdWU9e2Vudmlyb25tZW50fT5cbiAgICAgICAgPFF1ZXJ5UmVuZGVyZXJcbiAgICAgICAgICBlbnZpcm9ubWVudD17ZW52aXJvbm1lbnR9XG4gICAgICAgICAgcXVlcnk9e3F1ZXJ5fVxuICAgICAgICAgIHZhcmlhYmxlcz17dmFyaWFibGVzfVxuICAgICAgICAgIHJlbmRlcj17cXVlcnlSZXN1bHQgPT4gdGhpcy5yZW5kZXJXaXRoUXVlcnkocXVlcnlSZXN1bHQsIHtyZXBvRGF0YSwgcGF0Y2h9KX1cbiAgICAgICAgLz5cbiAgICAgIDwvUmVsYXlFbnZpcm9ubWVudC5Qcm92aWRlcj5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyV2l0aFF1ZXJ5KHtlcnJvciwgcHJvcHMsIHJldHJ5fSwge3JlcG9EYXRhLCBwYXRjaH0pIHtcbiAgICBpZiAoZXJyb3IpIHtcbiAgICAgIHJldHVybiAoXG4gICAgICAgIDxRdWVyeUVycm9yVmlld1xuICAgICAgICAgIGVycm9yPXtlcnJvcn1cbiAgICAgICAgICBsb2dpbj17dGhpcy5oYW5kbGVMb2dpbn1cbiAgICAgICAgICByZXRyeT17cmV0cnl9XG4gICAgICAgICAgbG9nb3V0PXt0aGlzLmhhbmRsZUxvZ291dH1cbiAgICAgICAgLz5cbiAgICAgICk7XG4gICAgfVxuXG4gICAgaWYgKCFwcm9wcyB8fCAhcmVwb0RhdGEgfHwgIXBhdGNoKSB7XG4gICAgICByZXR1cm4gPExvYWRpbmdWaWV3IC8+O1xuICAgIH1cblxuICAgIHJldHVybiAoXG4gICAgICA8QWdncmVnYXRlZFJldmlld3NDb250YWluZXJcbiAgICAgICAgcHVsbFJlcXVlc3Q9e3Byb3BzLnJlcG9zaXRvcnkucHVsbFJlcXVlc3R9XG4gICAgICAgIHJlcG9ydFJlbGF5RXJyb3I9e3RoaXMucHJvcHMucmVwb3J0UmVsYXlFcnJvcn0+XG4gICAgICAgIHsoe2Vycm9ycywgc3VtbWFyaWVzLCBjb21tZW50VGhyZWFkcywgcmVmZXRjaH0pID0+IHtcbiAgICAgICAgICBpZiAoZXJyb3JzICYmIGVycm9ycy5sZW5ndGggPiAwKSB7XG4gICAgICAgICAgICByZXR1cm4gZXJyb3JzLm1hcCgoZXJyLCBpKSA9PiAoXG4gICAgICAgICAgICAgIDxFcnJvclZpZXdcbiAgICAgICAgICAgICAgICBrZXk9e2BlcnJvci0ke2l9YH1cbiAgICAgICAgICAgICAgICB0aXRsZT1cIlBhZ2luYXRpb24gZXJyb3JcIlxuICAgICAgICAgICAgICAgIGRlc2NyaXB0aW9ucz17W2Vyci5zdGFja119XG4gICAgICAgICAgICAgIC8+XG4gICAgICAgICAgICApKTtcbiAgICAgICAgICB9XG4gICAgICAgICAgY29uc3QgYWdncmVnYXRpb25SZXN1bHQgPSB7c3VtbWFyaWVzLCBjb21tZW50VGhyZWFkcywgcmVmZXRjaH07XG5cbiAgICAgICAgICByZXR1cm4gdGhpcy5yZW5kZXJXaXRoUmVzdWx0KHtcbiAgICAgICAgICAgIGFnZ3JlZ2F0aW9uUmVzdWx0LFxuICAgICAgICAgICAgcXVlcnlQcm9wczogcHJvcHMsXG4gICAgICAgICAgICByZXBvRGF0YSxcbiAgICAgICAgICAgIHBhdGNoLFxuICAgICAgICAgICAgcmVmZXRjaCxcbiAgICAgICAgICB9KTtcbiAgICAgICAgfX1cbiAgICAgIDwvQWdncmVnYXRlZFJldmlld3NDb250YWluZXI+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlcldpdGhSZXN1bHQoe2FnZ3JlZ2F0aW9uUmVzdWx0LCBxdWVyeVByb3BzLCByZXBvRGF0YSwgcGF0Y2h9KSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxDb21tZW50UG9zaXRpb25pbmdDb250YWluZXJcbiAgICAgICAgbXVsdGlGaWxlUGF0Y2g9e3BhdGNofVxuICAgICAgICB7Li4uYWdncmVnYXRpb25SZXN1bHR9XG4gICAgICAgIHByQ29tbWl0U2hhPXtxdWVyeVByb3BzLnJlcG9zaXRvcnkucHVsbFJlcXVlc3QuaGVhZFJlZk9pZH1cbiAgICAgICAgbG9jYWxSZXBvc2l0b3J5PXt0aGlzLnByb3BzLnJlcG9zaXRvcnl9PlxuICAgICAgICB7Y29tbWVudFRyYW5zbGF0aW9ucyA9PiB7XG4gICAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgIDxSZXZpZXdzQ29udHJvbGxlclxuICAgICAgICAgICAgICB7Li4udGhpcy5wcm9wc31cbiAgICAgICAgICAgICAgey4uLmFnZ3JlZ2F0aW9uUmVzdWx0fVxuICAgICAgICAgICAgICBjb21tZW50VHJhbnNsYXRpb25zPXtjb21tZW50VHJhbnNsYXRpb25zfVxuICAgICAgICAgICAgICBsb2NhbFJlcG9zaXRvcnk9e3RoaXMucHJvcHMucmVwb3NpdG9yeX1cbiAgICAgICAgICAgICAgbXVsdGlGaWxlUGF0Y2g9e3BhdGNofVxuICAgICAgICAgICAgICByZXBvc2l0b3J5PXtxdWVyeVByb3BzLnJlcG9zaXRvcnl9XG4gICAgICAgICAgICAgIHB1bGxSZXF1ZXN0PXtxdWVyeVByb3BzLnJlcG9zaXRvcnkucHVsbFJlcXVlc3R9XG4gICAgICAgICAgICAgIHZpZXdlcj17cXVlcnlQcm9wcy52aWV3ZXJ9XG4gICAgICAgICAgICAgIHsuLi5yZXBvRGF0YX1cbiAgICAgICAgICAgIC8+XG4gICAgICAgICAgKTtcbiAgICAgICAgfX1cbiAgICAgIDwvQ29tbWVudFBvc2l0aW9uaW5nQ29udGFpbmVyPlxuICAgICk7XG4gIH1cblxuICBmZXRjaFRva2VuID0gbG9naW5Nb2RlbCA9PiBsb2dpbk1vZGVsLmdldFRva2VuKHRoaXMucHJvcHMuZW5kcG9pbnQuZ2V0TG9naW5BY2NvdW50KCkpO1xuXG4gIGZldGNoUmVwb3NpdG9yeURhdGEgPSByZXBvc2l0b3J5ID0+IHtcbiAgICByZXR1cm4geXViaWtpcmkoe1xuICAgICAgYnJhbmNoZXM6IHJlcG9zaXRvcnkuZ2V0QnJhbmNoZXMoKSxcbiAgICAgIHJlbW90ZXM6IHJlcG9zaXRvcnkuZ2V0UmVtb3RlcygpLFxuICAgICAgaXNBYnNlbnQ6IHJlcG9zaXRvcnkuaXNBYnNlbnQoKSxcbiAgICAgIGlzTG9hZGluZzogcmVwb3NpdG9yeS5pc0xvYWRpbmcoKSxcbiAgICAgIGlzUHJlc2VudDogcmVwb3NpdG9yeS5pc1ByZXNlbnQoKSxcbiAgICAgIGlzTWVyZ2luZzogcmVwb3NpdG9yeS5pc01lcmdpbmcoKSxcbiAgICAgIGlzUmViYXNpbmc6IHJlcG9zaXRvcnkuaXNSZWJhc2luZygpLFxuICAgIH0pO1xuICB9XG5cbiAgaGFuZGxlTG9naW4gPSB0b2tlbiA9PiB0aGlzLnByb3BzLmxvZ2luTW9kZWwuc2V0VG9rZW4odGhpcy5wcm9wcy5lbmRwb2ludC5nZXRMb2dpbkFjY291bnQoKSwgdG9rZW4pO1xuXG4gIGhhbmRsZUxvZ291dCA9ICgpID0+IHRoaXMucHJvcHMubG9naW5Nb2RlbC5yZW1vdmVUb2tlbih0aGlzLnByb3BzLmVuZHBvaW50LmdldExvZ2luQWNjb3VudCgpKTtcblxuICBoYW5kbGVUb2tlblJldHJ5ID0gKCkgPT4gdGhpcy5wcm9wcy5sb2dpbk1vZGVsLmRpZFVwZGF0ZSgpO1xufVxuIl19