"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ContextMenuInterceptor extends _react.default.Component {
  static handle(event) {
    for (const [element, callback] of ContextMenuInterceptor.registration) {
      if (element.contains(event.target)) {
        callback(event);
      }
    }
  }

  static dispose() {
    document.removeEventListener('contextmenu', contextMenuHandler, {
      capture: true
    });
  }

  componentDidMount() {
    // Helpfully, addEventListener dedupes listeners for us.
    document.addEventListener('contextmenu', contextMenuHandler, {
      capture: true
    });
    ContextMenuInterceptor.registration.set(this.element, (...args) => this.props.onWillShowContextMenu(...args));
  }

  render() {
    return _react.default.createElement("div", {
      ref: e => {
        this.element = e;
      }
    }, this.props.children);
  }

  componentWillUnmount() {
    ContextMenuInterceptor.registration.delete(this.element);
  }

}

exports.default = ContextMenuInterceptor;

_defineProperty(ContextMenuInterceptor, "propTypes", {
  onWillShowContextMenu: _propTypes.default.func.isRequired,
  children: _propTypes.default.element.isRequired
});

_defineProperty(ContextMenuInterceptor, "registration", new Map());

function contextMenuHandler(event) {
  ContextMenuInterceptor.handle(event);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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