"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _multiFilePatchController = _interopRequireDefault(require("./multi-file-patch-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ChangedFileController extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "surface", () => this.props.surfaceFileAtPath(this.props.relPath, this.props.stagingStatus));
  }

  render() {
    return _react.default.createElement(_multiFilePatchController.default, _extends({
      surface: this.surface
    }, this.props));
  }

}

exports.default = ChangedFileController;

_defineProperty(ChangedFileController, "propTypes", {
  repository: _propTypes.default.object.isRequired,
  stagingStatus: _propTypes.default.oneOf(['staged', 'unstaged']),
  relPath: _propTypes.default.string.isRequired,
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  destroy: _propTypes.default.func.isRequired,
  undoLastDiscard: _propTypes.default.func.isRequired,
  surfaceFileAtPath: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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