"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareCommentDecorationsController = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _reactRelay = require("react-relay");

var _path = _interopRequireDefault(require("path"));

var _editorCommentDecorationsController = _interopRequireDefault(require("./editor-comment-decorations-controller"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _gutter = _interopRequireDefault(require("../atom/gutter"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommentDecorationsController extends _react.default.Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "updateOpenEditors", () => {
      return new Promise(resolve => {
        this.setState({
          openEditors: this.props.workspace.getTextEditors()
        }, resolve);
      });
    });

    _defineProperty(this, "openReviewsTab", () => {
      const [pullRequest] = this.props.pullRequests;
      /* istanbul ignore if */

      if (!pullRequest) {
        return null;
      }

      const uri = _reviewsItem.default.buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.owner,
        repo: this.props.repo,
        number: pullRequest.number,
        workdir: this.props.repoData.workingDirectoryPath
      });

      return this.props.workspace.open(uri, {
        searchAllPanes: true
      });
    });

    this.subscriptions = new _eventKit.CompositeDisposable();
    this.state = {
      openEditors: this.props.workspace.getTextEditors()
    };
  }

  componentDidMount() {
    this.subscriptions.add(this.props.workspace.observeTextEditors(this.updateOpenEditors), this.props.workspace.onDidDestroyPaneItem(this.updateOpenEditors));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }

  render() {
    if (this.props.pullRequests.length === 0) {
      return null;
    }

    const pullRequest = this.props.pullRequests[0]; // only show comment decorations if we're on a checked out pull request
    // otherwise, we'd have no way of knowing which comments to show.

    if (!this.isCheckedOutPullRequest(this.props.repoData.branches, this.props.repoData.remotes, pullRequest)) {
      return null;
    }

    const threadDataByPath = new Map();
    const workdirPath = this.props.repoData.workingDirectoryPath;

    for (const {
      comments,
      thread
    } of this.props.commentThreads) {
      // Skip comment threads that are entirely minimized.
      if (comments.every(comment => comment.isMinimized)) {
        continue;
      } // There may be multiple comments in the thread, but we really only care about the root comment when rendering
      // decorations.


      const threadData = {
        rootCommentID: comments[0].id,
        threadID: thread.id,
        position: comments[0].position,
        nativeRelPath: (0, _helpers.toNativePathSep)(comments[0].path),
        fullPath: _path.default.join(workdirPath, (0, _helpers.toNativePathSep)(comments[0].path))
      };

      if (threadDataByPath.get(threadData.fullPath)) {
        threadDataByPath.get(threadData.fullPath).push(threadData);
      } else {
        threadDataByPath.set(threadData.fullPath, [threadData]);
      }
    }

    const openEditorsWithCommentThreads = this.getOpenEditorsWithCommentThreads(threadDataByPath);
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement(_commands.default, {
      registry: this.props.commands,
      target: "atom-workspace"
    }, _react.default.createElement(_commands.Command, {
      command: "github:open-reviews-tab",
      callback: this.openReviewsTab
    })), openEditorsWithCommentThreads.map(editor => {
      const threadData = threadDataByPath.get(editor.getPath());
      const translations = this.props.commentTranslations.get(threadData[0].nativeRelPath);
      return _react.default.createElement(_react.Fragment, {
        key: `github-editor-decoration-${editor.id}`
      }, _react.default.createElement(_gutter.default, {
        name: "github-comment-icon",
        priority: 1,
        className: "comment",
        editor: editor,
        type: "decorated"
      }), _react.default.createElement(_editorCommentDecorationsController.default, {
        endpoint: this.props.endpoint,
        owner: this.props.owner,
        repo: this.props.repo,
        number: pullRequest.number,
        workdir: workdirPath,
        workspace: this.props.workspace,
        editor: editor,
        fileName: editor.getPath(),
        headSha: pullRequest.headRefOid,
        threadsForPath: threadData,
        commentTranslationsForPath: translations
      }));
    }));
  }

  getOpenEditorsWithCommentThreads(threadDataByPath) {
    const haveThreads = [];

    for (const editor of this.state.openEditors) {
      if (threadDataByPath.has(editor.getPath())) {
        haveThreads.push(editor);
      }
    }

    return haveThreads;
  } // Determine if we already have this PR checked out.
  // todo: if this is similar enough to pr-checkout-controller, extract a single
  // helper function to do this check.


  isCheckedOutPullRequest(branches, remotes, pullRequest) {
    // determine if pullRequest.headRepository is null
    // this can happen if a repository has been deleted.
    if (!pullRequest.headRepository) {
      return false;
    }

    const {
      repository
    } = pullRequest;
    const headPush = branches.getHeadBranch().getPush();
    const headRemote = remotes.withName(headPush.getRemoteName()); // (detect checkout from pull/### refspec)

    const fromPullRefspec = headRemote.getOwner() === repository.owner.login && headRemote.getRepo() === repository.name && headPush.getShortRemoteRef() === `pull/${pullRequest.number}/head`; // (detect checkout from head repository)

    const fromHeadRepo = headRemote.getOwner() === pullRequest.headRepository.owner.login && headRemote.getRepo() === pullRequest.headRepository.name && headPush.getShortRemoteRef() === pullRequest.headRefName;

    if (fromPullRefspec || fromHeadRepo) {
      return true;
    }

    return false;
  }

}

exports.BareCommentDecorationsController = BareCommentDecorationsController;

_defineProperty(BareCommentDecorationsController, "propTypes", {
  // Relay response
  relay: _propTypes.default.object.isRequired,
  pullRequests: _propTypes.default.arrayOf(_propTypes.default.shape({
    number: _propTypes.default.number.isRequired,
    headRefName: _propTypes.default.string.isRequired,
    headRefOid: _propTypes.default.string.isRequired,
    headRepository: _propTypes.default.shape({
      name: _propTypes.default.string.isRequired,
      owner: _propTypes.default.shape({
        login: _propTypes.default.string.isRequired
      }).isRequired
    }),
    repository: _propTypes.default.shape({
      name: _propTypes.default.string.isRequired,
      owner: _propTypes.default.shape({
        login: _propTypes.default.string.isRequired
      }).isRequired
    }).isRequired
  })),
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  owner: _propTypes.default.string.isRequired,
  repo: _propTypes.default.string.isRequired,
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  // Models
  repoData: _propTypes.default.shape({
    branches: _propTypes2.BranchSetPropType.isRequired,
    remotes: _propTypes2.RemoteSetPropType.isRequired,
    currentRemote: _propTypes2.RemotePropType.isRequired,
    workingDirectoryPath: _propTypes.default.string.isRequired
  }).isRequired,
  commentThreads: _propTypes.default.arrayOf(_propTypes.default.shape({
    comments: _propTypes.default.arrayOf(_propTypes.default.object).isRequired,
    thread: _propTypes.default.shape({
      id: _propTypes.default.string.isRequired
    }).isRequired
  })).isRequired,
  commentTranslations: _propTypes.default.shape({
    get: _propTypes.default.func.isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommentDecorationsController, {
  pullRequests: function () {
    const node = require("./__generated__/commentDecorationsController_pullRequests.graphql");

    if (node.hash && node.hash !== "62f96ccd13dfc2649112a7b4afaf4ba2") {
      console.error("The definition of 'commentDecorationsController_pullRequests' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commentDecorationsController_pullRequests.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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