"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _commitDetailView = _interopRequireDefault(require("../views/commit-detail-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitDetailController extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "toggleMessage", () => {
      return new Promise(resolve => {
        this.setState(prevState => ({
          messageOpen: !prevState.messageOpen
        }), resolve);
      });
    });

    this.state = {
      messageCollapsible: this.props.commit.isBodyLong(),
      messageOpen: !this.props.commit.isBodyLong()
    };
  }

  render() {
    return _react.default.createElement(_commitDetailView.default, _extends({
      messageCollapsible: this.state.messageCollapsible,
      messageOpen: this.state.messageOpen,
      toggleMessage: this.toggleMessage
    }, this.props));
  }

}

exports.default = CommitDetailController;

_defineProperty(CommitDetailController, "propTypes", _objectSpread2({}, _commitDetailView.default.drilledPropTypes, {
  commit: _propTypes.default.object.isRequired
}));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbW1pdC1kZXRhaWwtY29udHJvbGxlci5qcyJdLCJuYW1lcyI6WyJDb21taXREZXRhaWxDb250cm9sbGVyIiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwiUHJvbWlzZSIsInJlc29sdmUiLCJzZXRTdGF0ZSIsInByZXZTdGF0ZSIsIm1lc3NhZ2VPcGVuIiwic3RhdGUiLCJtZXNzYWdlQ29sbGFwc2libGUiLCJjb21taXQiLCJpc0JvZHlMb25nIiwicmVuZGVyIiwidG9nZ2xlTWVzc2FnZSIsIkNvbW1pdERldGFpbFZpZXciLCJkcmlsbGVkUHJvcFR5cGVzIiwiUHJvcFR5cGVzIiwib2JqZWN0IiwiaXNSZXF1aXJlZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUVBOzs7Ozs7Ozs7O0FBRWUsTUFBTUEsc0JBQU4sU0FBcUNDLGVBQU1DLFNBQTNDLENBQXFEO0FBT2xFQyxFQUFBQSxXQUFXLENBQUNDLEtBQUQsRUFBUTtBQUNqQixVQUFNQSxLQUFOOztBQURpQiwyQ0FvQkgsTUFBTTtBQUNwQixhQUFPLElBQUlDLE9BQUosQ0FBWUMsT0FBTyxJQUFJO0FBQzVCLGFBQUtDLFFBQUwsQ0FBY0MsU0FBUyxLQUFLO0FBQUNDLFVBQUFBLFdBQVcsRUFBRSxDQUFDRCxTQUFTLENBQUNDO0FBQXpCLFNBQUwsQ0FBdkIsRUFBb0VILE9BQXBFO0FBQ0QsT0FGTSxDQUFQO0FBR0QsS0F4QmtCOztBQUdqQixTQUFLSSxLQUFMLEdBQWE7QUFDWEMsTUFBQUEsa0JBQWtCLEVBQUUsS0FBS1AsS0FBTCxDQUFXUSxNQUFYLENBQWtCQyxVQUFsQixFQURUO0FBRVhKLE1BQUFBLFdBQVcsRUFBRSxDQUFDLEtBQUtMLEtBQUwsQ0FBV1EsTUFBWCxDQUFrQkMsVUFBbEI7QUFGSCxLQUFiO0FBSUQ7O0FBRURDLEVBQUFBLE1BQU0sR0FBRztBQUNQLFdBQ0UsNkJBQUMseUJBQUQ7QUFDRSxNQUFBLGtCQUFrQixFQUFFLEtBQUtKLEtBQUwsQ0FBV0Msa0JBRGpDO0FBRUUsTUFBQSxXQUFXLEVBQUUsS0FBS0QsS0FBTCxDQUFXRCxXQUYxQjtBQUdFLE1BQUEsYUFBYSxFQUFFLEtBQUtNO0FBSHRCLE9BSU0sS0FBS1gsS0FKWCxFQURGO0FBUUQ7O0FBekJpRTs7OztnQkFBL0NKLHNCLGtDQUVkZ0IsMEJBQWlCQyxnQjtBQUVwQkwsRUFBQUEsTUFBTSxFQUFFTSxtQkFBVUMsTUFBVixDQUFpQkMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5cbmltcG9ydCBDb21taXREZXRhaWxWaWV3IGZyb20gJy4uL3ZpZXdzL2NvbW1pdC1kZXRhaWwtdmlldyc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIENvbW1pdERldGFpbENvbnRyb2xsZXIgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIC4uLkNvbW1pdERldGFpbFZpZXcuZHJpbGxlZFByb3BUeXBlcyxcblxuICAgIGNvbW1pdDogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG5cbiAgICB0aGlzLnN0YXRlID0ge1xuICAgICAgbWVzc2FnZUNvbGxhcHNpYmxlOiB0aGlzLnByb3BzLmNvbW1pdC5pc0JvZHlMb25nKCksXG4gICAgICBtZXNzYWdlT3BlbjogIXRoaXMucHJvcHMuY29tbWl0LmlzQm9keUxvbmcoKSxcbiAgICB9O1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8Q29tbWl0RGV0YWlsVmlld1xuICAgICAgICBtZXNzYWdlQ29sbGFwc2libGU9e3RoaXMuc3RhdGUubWVzc2FnZUNvbGxhcHNpYmxlfVxuICAgICAgICBtZXNzYWdlT3Blbj17dGhpcy5zdGF0ZS5tZXNzYWdlT3Blbn1cbiAgICAgICAgdG9nZ2xlTWVzc2FnZT17dGhpcy50b2dnbGVNZXNzYWdlfVxuICAgICAgICB7Li4udGhpcy5wcm9wc31cbiAgICAgIC8+XG4gICAgKTtcbiAgfVxuXG4gIHRvZ2dsZU1lc3NhZ2UgPSAoKSA9PiB7XG4gICAgcmV0dXJuIG5ldyBQcm9taXNlKHJlc29sdmUgPT4ge1xuICAgICAgdGhpcy5zZXRTdGF0ZShwcmV2U3RhdGUgPT4gKHttZXNzYWdlT3BlbjogIXByZXZTdGF0ZS5tZXNzYWdlT3Blbn0pLCByZXNvbHZlKTtcbiAgICB9KTtcbiAgfVxufVxuIl19