"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _helpers = require("../helpers");

var _source = require("../models/conflicts/source");

var _decoration = _interopRequireDefault(require("../atom/decoration"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const {
  Menu,
  MenuItem
} = _electron.remote;

class ConflictController extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'showResolveMenu');
    this.state = {
      chosenSide: this.props.conflict.getChosenSide()
    };
  }

  resolveAsSequence(sources) {
    this.props.resolveAsSequence(sources);
    this.setState({
      chosenSide: this.props.conflict.getChosenSide()
    });
  }

  revert(side) {
    side.isModified() && side.revert();
    side.isBannerModified() && side.revertBanner();
  }

  showResolveMenu(event) {
    event.preventDefault();
    const menu = new Menu();
    menu.append(new MenuItem({
      label: 'Resolve as Ours',
      click: this.resolveAsSequence.bind(this, [_source.OURS])
    }));

    if (this.props.conflict.getSide(_source.BASE)) {
      menu.append(new MenuItem({
        label: 'Resolve as Base',
        click: this.resolveAsSequence.bind(this, [_source.BASE])
      }));
    }

    menu.append(new MenuItem({
      label: 'Resolve as Theirs',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS])
    }));
    menu.append(new MenuItem({
      type: 'separator'
    }));
    menu.append(new MenuItem({
      label: 'Resolve as Ours Then Theirs',
      click: this.resolveAsSequence.bind(this, [_source.OURS, _source.THEIRS])
    }));
    menu.append(new MenuItem({
      label: 'Resolve as Theirs Then Ours',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS, _source.OURS])
    }));
    menu.append(new MenuItem({
      type: 'separator'
    }));
    menu.append(new MenuItem({
      label: 'Dismiss',
      click: this.props.dismiss
    }));
    menu.popup(_electron.remote.getCurrentWindow());
  }

  render() {
    if (!this.state.chosenSide) {
      const ours = this.props.conflict.getSide(_source.OURS);
      const base = this.props.conflict.getSide(_source.BASE);
      const theirs = this.props.conflict.getSide(_source.THEIRS);
      return _react.default.createElement("div", null, this.renderSide(ours), base && this.renderSide(base), _react.default.createElement(_decoration.default, {
        key: this.props.conflict.getSeparator().getMarker().id,
        editor: this.props.editor,
        decorable: this.props.conflict.getSeparator().getMarker(),
        type: "line",
        className: "github-ConflictSeparator"
      }), this.renderSide(theirs));
    } else if (!this.state.chosenSide.isEmpty()) {
      return _react.default.createElement(_decoration.default, {
        editor: this.props.editor,
        decorable: this.state.chosenSide.getMarker(),
        type: "line",
        className: "github-ResolvedLines"
      });
    } else {
      return null;
    }
  }

  renderSide(side) {
    const source = side.getSource();
    return _react.default.createElement("div", null, _react.default.createElement(_decoration.default, {
      key: side.banner.marker.id,
      editor: this.props.editor,
      decorable: side.getBannerMarker(),
      type: "line",
      className: side.getBannerCSSClass()
    }), side.isBannerModified() || _react.default.createElement(_decoration.default, {
      key: 'banner-modified-' + side.banner.marker.id,
      editor: this.props.editor,
      decorable: side.getBannerMarker(),
      type: "line",
      className: "github-ConflictUnmodifiedBanner"
    }), _react.default.createElement(_decoration.default, {
      key: side.marker.id,
      editor: this.props.editor,
      decorable: side.getMarker(),
      type: "line",
      className: side.getLineCSSClass()
    }), _react.default.createElement(_decoration.default, {
      key: 'block-' + side.marker.id,
      editor: this.props.editor,
      decorable: side.getBlockMarker(),
      type: "block",
      position: side.getBlockPosition()
    }, _react.default.createElement("div", {
      className: side.getBlockCSSClasses()
    }, _react.default.createElement("span", {
      className: "github-ResolutionControls"
    }, _react.default.createElement("button", {
      className: "btn btn-sm inline-block",
      onClick: () => this.resolveAsSequence([source])
    }, "Use me"), (side.isModified() || side.isBannerModified()) && _react.default.createElement("button", {
      className: "btn btn-sm inline-block",
      onClick: () => this.revert(side)
    }, "Revert"), _react.default.createElement(_octicon.default, {
      icon: "ellipses",
      className: "inline-block",
      onClick: this.showResolveMenu
    })), _react.default.createElement("span", {
      className: "github-SideDescription"
    }, source.toUIString()))));
  }

}

exports.default = ConflictController;

_defineProperty(ConflictController, "propTypes", {
  editor: _propTypes.default.object.isRequired,
  conflict: _propTypes.default.object.isRequired,
  resolveAsSequence: _propTypes.default.func,
  dismiss: _propTypes.default.func
});

_defineProperty(ConflictController, "defaultProps", {
  resolveAsSequence: sources => {},
  dismiss: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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