"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareCreateDialogController = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _atom = require("atom");

var _eventKit = require("event-kit");

var _path = _interopRequireDefault(require("path"));

var _createDialogView = _interopRequireDefault(require("../views/create-dialog-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCreateDialogController extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "didChangeRepoName", () => {
      this.modified.repoName = true;

      if (!this.modified.localPath) {
        if (this.localPath.getText() === this.projectHome) {
          this.localPath.setText(_path.default.join(this.projectHome, this.repoName.getText()));
        } else {
          const dirName = _path.default.dirname(this.localPath.getText());

          this.localPath.setText(_path.default.join(dirName, this.repoName.getText()));
        }

        this.modified.localPath = false;
      }

      this.recheckAcceptEnablement();
    });

    _defineProperty(this, "didChangeOwnerID", ownerID => new Promise(resolve => this.setState({
      selectedOwnerID: ownerID
    }, resolve)));

    _defineProperty(this, "didChangeLocalPath", () => {
      this.modified.localPath = true;

      if (!this.modified.repoName) {
        this.repoName.setText(_path.default.basename(this.localPath.getText()));
        this.modified.repoName = false;
      }

      this.recheckAcceptEnablement();
    });

    _defineProperty(this, "didChangeVisibility", visibility => {
      return new Promise(resolve => this.setState({
        selectedVisibility: visibility
      }, resolve));
    });

    _defineProperty(this, "didChangeSourceRemoteName", () => {
      this.writeSourceRemoteNameSetting();
      this.recheckAcceptEnablement();
    });

    _defineProperty(this, "didChangeProtocol", async protocol => {
      await new Promise(resolve => this.setState({
        selectedProtocol: protocol
      }, resolve));
      this.writeRemoteFetchProtocolSetting(protocol);
    });

    _defineProperty(this, "readSourceRemoteNameSetting", ({
      newValue
    }) => {
      if (newValue !== this.sourceRemoteName.getText()) {
        this.sourceRemoteName.setText(newValue);
      }
    });

    _defineProperty(this, "readRemoteFetchProtocolSetting", ({
      newValue
    }) => {
      if (newValue !== this.state.selectedProtocol) {
        this.setState({
          selectedProtocol: newValue
        });
      }
    });

    _defineProperty(this, "accept", () => {
      if (!this.acceptIsEnabled()) {
        return Promise.resolve();
      }

      const ownerID = this.state.selectedOwnerID !== '' ? this.state.selectedOwnerID : this.props.user.id;
      return this.props.request.accept({
        ownerID,
        name: this.repoName.getText(),
        visibility: this.state.selectedVisibility,
        localPath: this.localPath.getText(),
        protocol: this.state.selectedProtocol,
        sourceRemoteName: this.sourceRemoteName.getText()
      });
    });

    const {
      localDir
    } = this.props.request.getParams();
    this.projectHome = this.props.config.get('core.projectHome');
    this.modified = {
      repoName: false,
      localPath: false
    };
    this.repoName = new _atom.TextBuffer({
      text: localDir ? _path.default.basename(localDir) : ''
    });
    this.localPath = new _atom.TextBuffer({
      text: localDir || this.projectHome
    });
    this.sourceRemoteName = new _atom.TextBuffer({
      text: this.props.config.get('github.sourceRemoteName')
    });
    this.subs = new _eventKit.CompositeDisposable(this.repoName.onDidChange(this.didChangeRepoName), this.localPath.onDidChange(this.didChangeLocalPath), this.sourceRemoteName.onDidChange(this.didChangeSourceRemoteName), this.props.config.onDidChange('github.sourceRemoteName', this.readSourceRemoteNameSetting), this.props.config.onDidChange('github.remoteFetchProtocol', this.readRemoteFetchProtocolSetting));
    this.state = {
      acceptEnabled: this.acceptIsEnabled(),
      selectedVisibility: 'PUBLIC',
      selectedProtocol: this.props.config.get('github.remoteFetchProtocol'),
      selectedOwnerID: this.props.user ? this.props.user.id : ''
    };
  }

  render() {
    return _react.default.createElement(_createDialogView.default, _extends({
      selectedOwnerID: this.state.selectedOwnerID,
      repoName: this.repoName,
      selectedVisibility: this.state.selectedVisibility,
      localPath: this.localPath,
      sourceRemoteName: this.sourceRemoteName,
      selectedProtocol: this.state.selectedProtocol,
      didChangeOwnerID: this.didChangeOwnerID,
      didChangeVisibility: this.didChangeVisibility,
      didChangeProtocol: this.didChangeProtocol,
      acceptEnabled: this.state.acceptEnabled,
      accept: this.accept
    }, this.props));
  }

  componentDidUpdate(prevProps) {
    if (this.props.user !== prevProps.user) {
      this.recheckAcceptEnablement();
    }
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  writeSourceRemoteNameSetting() {
    if (this.props.config.get('github.sourceRemoteName') !== this.sourceRemoteName.getText()) {
      this.props.config.set('github.sourceRemoteName', this.sourceRemoteName.getText());
    }
  }

  writeRemoteFetchProtocolSetting(protocol) {
    if (this.props.config.get('github.remoteFetchProtocol') !== protocol) {
      this.props.config.set('github.remoteFetchProtocol', protocol);
    }
  }

  acceptIsEnabled() {
    return !this.repoName.isEmpty() && !this.localPath.isEmpty() && !this.sourceRemoteName.isEmpty() && this.props.user !== null;
  }

  recheckAcceptEnablement() {
    const nextEnablement = this.acceptIsEnabled();

    if (nextEnablement !== this.state.acceptEnabled) {
      this.setState({
        acceptEnabled: nextEnablement
      });
    }
  }

}

exports.BareCreateDialogController = BareCreateDialogController;

_defineProperty(BareCreateDialogController, "propTypes", {
  // Relay
  user: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired
  }),
  // Model
  request: _propTypes.default.shape({
    getParams: _propTypes.default.func.isRequired,
    accept: _propTypes.default.func.isRequired
  }).isRequired,
  error: _propTypes.default.instanceOf(Error),
  isLoading: _propTypes.default.bool.isRequired,
  inProgress: _propTypes.default.bool.isRequired,
  // Atom environment
  currentWindow: _propTypes.default.object.isRequired,
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCreateDialogController, {
  user: function () {
    const node = require("./__generated__/createDialogController_user.graphql");

    if (node.hash && node.hash !== "729f5d41fc5444c5f12632127f89ed21") {
      console.error("The definition of 'createDialogController_user' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/createDialogController_user.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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