"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dialogRequests = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _initDialog = _interopRequireDefault(require("../views/init-dialog"));

var _cloneDialog = _interopRequireDefault(require("../views/clone-dialog"));

var _credentialDialog = _interopRequireDefault(require("../views/credential-dialog"));

var _openIssueishDialog = _interopRequireDefault(require("../views/open-issueish-dialog"));

var _openCommitDialog = _interopRequireDefault(require("../views/open-commit-dialog"));

var _createDialog = _interopRequireDefault(require("../views/create-dialog"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const DIALOG_COMPONENTS = {
  null: NullDialog,
  init: _initDialog.default,
  clone: _cloneDialog.default,
  credential: _credentialDialog.default,
  issueish: _openIssueishDialog.default,
  commit: _openCommitDialog.default,
  create: _createDialog.default,
  publish: _createDialog.default
};

class DialogsController extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      requestInProgress: null,
      requestError: [null, null]
    });
  }

  render() {
    const DialogComponent = DIALOG_COMPONENTS[this.props.request.identifier];
    return _react.default.createElement(DialogComponent, this.getCommonProps());
  }

  getCommonProps() {
    const {
      request
    } = this.props;
    const accept = request.isProgressing ? async (...args) => {
      this.setState({
        requestError: [null, null],
        requestInProgress: request
      });

      try {
        const result = await request.accept(...args);
        this.setState({
          requestInProgress: null
        });
        return result;
      } catch (error) {
        this.setState({
          requestError: [request, error],
          requestInProgress: null
        });
        return undefined;
      }
    } : (...args) => {
      this.setState({
        requestError: [null, null]
      });

      try {
        return request.accept(...args);
      } catch (error) {
        this.setState({
          requestError: [request, error]
        });
        return undefined;
      }
    };
    const wrapped = wrapDialogRequest(request, {
      accept
    });
    return {
      loginModel: this.props.loginModel,
      request: wrapped,
      inProgress: this.state.requestInProgress === request,
      currentWindow: this.props.currentWindow,
      workspace: this.props.workspace,
      commands: this.props.commands,
      config: this.props.config,
      error: this.state.requestError[0] === request ? this.state.requestError[1] : null
    };
  }

}

exports.default = DialogsController;

_defineProperty(DialogsController, "propTypes", {
  // Model
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  request: _propTypes.default.shape({
    identifier: _propTypes.default.string.isRequired,
    isProgressing: _propTypes.default.bool.isRequired
  }).isRequired,
  // Atom environment
  currentWindow: _propTypes.default.object.isRequired,
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired
});

function NullDialog() {
  return null;
}

class DialogRequest {
  constructor(identifier, params = {}) {
    this.identifier = identifier;
    this.params = params;
    this.isProgressing = false;

    this.accept = () => {};

    this.cancel = () => {};
  }

  onAccept(cb) {
    this.accept = cb;
  }

  onProgressingAccept(cb) {
    this.isProgressing = true;
    this.onAccept(cb);
  }

  onCancel(cb) {
    this.cancel = cb;
  }

  getParams() {
    return this.params;
  }

}

function wrapDialogRequest(original, {
  accept
}) {
  const dup = new DialogRequest(original.identifier, original.params);
  dup.isProgressing = original.isProgressing;
  dup.onAccept(accept);
  dup.onCancel(original.cancel);
  return dup;
}

const dialogRequests = {
  null: {
    identifier: 'null',
    isProgressing: false,
    params: {},
    accept: () => {},
    cancel: () => {}
  },

  init({
    dirPath
  }) {
    return new DialogRequest('init', {
      dirPath
    });
  },

  clone(opts) {
    return new DialogRequest('clone', _objectSpread2({
      sourceURL: '',
      destPath: ''
    }, opts));
  },

  credential(opts) {
    return new DialogRequest('credential', _objectSpread2({
      includeUsername: false,
      includeRemember: false,
      prompt: 'Please authenticate'
    }, opts));
  },

  issueish() {
    return new DialogRequest('issueish');
  },

  commit() {
    return new DialogRequest('commit');
  },

  create() {
    return new DialogRequest('create');
  },

  publish({
    localDir
  }) {
    return new DialogRequest('publish', {
      localDir
    });
  }

};
exports.dialogRequests = dialogRequests;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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