"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

var _marker = _interopRequireDefault(require("../atom/marker"));

var _decoration = _interopRequireDefault(require("../atom/decoration"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _commentGutterDecorationController = _interopRequireDefault(require("../controllers/comment-gutter-decoration-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class EditorCommentDecorationsController extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openReviewThread", async threadId => {
      const uri = _reviewsItem.default.buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdir
      });

      const reviewsItem = await this.props.workspace.open(uri, {
        searchAllPanes: true
      });
      reviewsItem.jumpToThread(threadId);
      (0, _reporterProxy.addEvent)('open-review-thread', {
        package: 'github',
        from: this.constructor.name
      });
    });

    this.rangesByRootID = new Map();
  }

  shouldComponentUpdate(nextProps) {
    return translationDigestFrom(this.props) !== translationDigestFrom(nextProps);
  }

  render() {
    if (!this.props.commentTranslationsForPath) {
      return null;
    }

    if (this.props.commentTranslationsForPath.removed && this.props.threadsForPath.length > 0) {
      const [firstThread] = this.props.threadsForPath;
      return _react.default.createElement(_marker.default, {
        editor: this.props.editor,
        exclusive: true,
        invalidate: "surround",
        bufferRange: _atom.Range.fromObject([[0, 0], [0, 0]])
      }, _react.default.createElement(_decoration.default, {
        type: "block",
        editor: this.props.editor,
        className: "github-EditorComment-omitted"
      }, _react.default.createElement("p", null, "This file has review comments, but its patch is too large for Atom to load."), _react.default.createElement("p", null, "Review comments may still be viewed within", _react.default.createElement("button", {
        className: "btn",
        onClick: () => this.openReviewThread(firstThread.threadID)
      }, "the review tab"), ".")));
    }

    return this.props.threadsForPath.map(thread => {
      const range = this.getRangeForThread(thread);

      if (!range) {
        return null;
      }

      return _react.default.createElement(_react.Fragment, {
        key: `github-editor-review-decoration-${thread.rootCommentID}`
      }, _react.default.createElement(_marker.default, {
        editor: this.props.editor,
        exclusive: true,
        invalidate: "surround",
        bufferRange: range,
        didChange: evt => this.markerDidChange(thread.rootCommentID, evt)
      }, _react.default.createElement(_decoration.default, {
        type: "line",
        editor: this.props.editor,
        className: "github-editorCommentHighlight",
        omitEmptyLastRow: false
      })), _react.default.createElement(_commentGutterDecorationController.default, {
        commentRow: range.start.row,
        threadId: thread.threadID,
        editor: this.props.editor,
        workspace: this.props.workspace,
        endpoint: this.props.endpoint,
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdir,
        parent: this.constructor.name
      }));
    });
  }

  markerDidChange(rootCommentID, {
    newRange
  }) {
    this.rangesByRootID.set(rootCommentID, _atom.Range.fromObject(newRange));
  }

  getRangeForThread(thread) {
    const translations = this.props.commentTranslationsForPath;

    if (thread.position === null) {
      this.rangesByRootID.delete(thread.rootCommentID);
      return null;
    }

    let adjustedPosition = translations.diffToFilePosition.get(thread.position);

    if (!adjustedPosition) {
      this.rangesByRootID.delete(thread.rootCommentID);
      return null;
    }

    if (translations.fileTranslations) {
      adjustedPosition = translations.fileTranslations.get(adjustedPosition).newPosition;

      if (!adjustedPosition) {
        this.rangesByRootID.delete(thread.rootCommentID);
        return null;
      }
    }

    const editorRow = adjustedPosition - 1;
    let localRange = this.rangesByRootID.get(thread.rootCommentID);

    if (!localRange) {
      localRange = _atom.Range.fromObject([[editorRow, 0], [editorRow, Infinity]]);
      this.rangesByRootID.set(thread.rootCommentID, localRange);
    }

    return localRange;
  }

}

exports.default = EditorCommentDecorationsController;

_defineProperty(EditorCommentDecorationsController, "propTypes", {
  endpoint: _propTypes2.EndpointPropType.isRequired,
  owner: _propTypes.default.string.isRequired,
  repo: _propTypes.default.string.isRequired,
  number: _propTypes.default.number.isRequired,
  workdir: _propTypes.default.string.isRequired,
  workspace: _propTypes.default.object.isRequired,
  editor: _propTypes.default.object.isRequired,
  threadsForPath: _propTypes.default.arrayOf(_propTypes.default.shape({
    rootCommentID: _propTypes.default.string.isRequired,
    position: _propTypes.default.number,
    threadID: _propTypes.default.string.isRequired
  })).isRequired,
  commentTranslationsForPath: _propTypes.default.shape({
    diffToFilePosition: _propTypes.default.shape({
      get: _propTypes.default.func.isRequired
    }).isRequired,
    fileTranslations: _propTypes.default.shape({
      get: _propTypes.default.func.isRequired
    }),
    removed: _propTypes.default.bool.isRequired,
    digest: _propTypes.default.string
  })
});

function translationDigestFrom(props) {
  const translations = props.commentTranslationsForPath;
  return translations ? translations.digest : null;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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