"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _path = _interopRequireDefault(require("path"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _gitTabView = _interopRequireDefault(require("../views/git-tab-view"));

var _userStore = _interopRequireDefault(require("../models/user-store"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitTabController extends _react.default.Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "attemptStageAllOperation", stageStatus => {
      return this.attemptFileStageOperation(['.'], stageStatus);
    });

    _defineProperty(this, "attemptFileStageOperation", (filePaths, stageStatus) => {
      if (this.stagingOperationInProgress) {
        return {
          stageOperationPromise: Promise.resolve(),
          selectionUpdatePromise: Promise.resolve()
        };
      }

      this.stagingOperationInProgress = true;
      const fileListUpdatePromise = this.refStagingView.map(view => {
        return view.getNextListUpdatePromise();
      }).getOr(Promise.resolve());
      let stageOperationPromise;

      if (stageStatus === 'staged') {
        stageOperationPromise = this.unstageFiles(filePaths);
      } else {
        stageOperationPromise = this.stageFiles(filePaths);
      }

      const selectionUpdatePromise = fileListUpdatePromise.then(() => {
        this.stagingOperationInProgress = false;
      });
      return {
        stageOperationPromise,
        selectionUpdatePromise
      };
    });

    _defineProperty(this, "prepareToCommit", async () => {
      return !(await this.props.ensureGitTab());
    });

    _defineProperty(this, "commit", (message, options) => {
      return this.props.repository.commit(message, options);
    });

    _defineProperty(this, "updateSelectedCoAuthors", (selectedCoAuthors, newAuthor) => {
      if (newAuthor) {
        this.userStore.addUsers([newAuthor]);
        selectedCoAuthors = selectedCoAuthors.concat([newAuthor]);
      }

      this.setState({
        selectedCoAuthors
      });
    });

    _defineProperty(this, "undoLastCommit", async () => {
      const repo = this.props.repository;
      const lastCommit = await repo.getLastCommit();

      if (lastCommit.isUnbornRef()) {
        return null;
      }

      await repo.undoLastCommit();
      repo.setCommitMessage(lastCommit.getFullMessage());
      this.updateSelectedCoAuthors(lastCommit.getCoAuthors());
      return null;
    });

    _defineProperty(this, "abortMerge", async () => {
      const choice = this.props.confirm({
        message: 'Abort merge',
        detailedMessage: 'Are you sure?',
        buttons: ['Abort', 'Cancel']
      });

      if (choice !== 0) {
        return;
      }

      try {
        await this.props.repository.abortMerge();
      } catch (e) {
        if (e.code === 'EDIRTYSTAGED') {
          this.props.notificationManager.addError(`Cannot abort because ${e.path} is both dirty and staged.`, {
            dismissable: true
          });
        } else {
          throw e;
        }
      }
    });

    _defineProperty(this, "resolveAsOurs", async paths => {
      if (this.props.fetchInProgress) {
        return;
      }

      const side = this.props.isRebasing ? 'theirs' : 'ours';
      await this.props.repository.checkoutSide(side, paths);
      this.refreshResolutionProgress(false, true);
    });

    _defineProperty(this, "resolveAsTheirs", async paths => {
      if (this.props.fetchInProgress) {
        return;
      }

      const side = this.props.isRebasing ? 'ours' : 'theirs';
      await this.props.repository.checkoutSide(side, paths);
      this.refreshResolutionProgress(false, true);
    });

    _defineProperty(this, "checkout", (branchName, options) => {
      return this.props.repository.checkout(branchName, options);
    });

    _defineProperty(this, "rememberLastFocus", event => {
      this.lastFocus = this.refView.map(view => view.getFocus(event.target)).getOr(null) || _gitTabView.default.focus.STAGING;
    });

    _defineProperty(this, "toggleIdentityEditor", () => this.setState(before => ({
      editingIdentity: !before.editingIdentity
    })));

    _defineProperty(this, "closeIdentityEditor", () => this.setState({
      editingIdentity: false
    }));

    _defineProperty(this, "setLocalIdentity", () => this.setIdentity({}));

    _defineProperty(this, "setGlobalIdentity", () => this.setIdentity({
      global: true
    }));

    this.stagingOperationInProgress = false;
    this.lastFocus = _gitTabView.default.focus.STAGING;
    this.refView = new _refHolder.default();
    this.refRoot = new _refHolder.default();
    this.refStagingView = new _refHolder.default();
    this.state = {
      selectedCoAuthors: [],
      editingIdentity: false
    };
    this.usernameBuffer = new _atom.TextBuffer({
      text: props.username
    });
    this.usernameBuffer.retain();
    this.emailBuffer = new _atom.TextBuffer({
      text: props.email
    });
    this.emailBuffer.retain();
    this.userStore = new _userStore.default({
      repository: this.props.repository,
      login: this.props.loginModel,
      config: this.props.config
    });
  }

  static getDerivedStateFromProps(props, state) {
    return {
      editingIdentity: state.editingIdentity || !props.fetchInProgress && props.repository.isPresent() && !props.repositoryDrift && (props.username === '' || props.email === '')
    };
  }

  render() {
    return _react.default.createElement(_gitTabView.default, {
      ref: this.refView.setter,
      refRoot: this.refRoot,
      refStagingView: this.refStagingView,
      isLoading: this.props.fetchInProgress,
      editingIdentity: this.state.editingIdentity,
      repository: this.props.repository,
      usernameBuffer: this.usernameBuffer,
      emailBuffer: this.emailBuffer,
      lastCommit: this.props.lastCommit,
      recentCommits: this.props.recentCommits,
      isMerging: this.props.isMerging,
      isRebasing: this.props.isRebasing,
      hasUndoHistory: this.props.hasUndoHistory,
      currentBranch: this.props.currentBranch,
      unstagedChanges: this.props.unstagedChanges,
      stagedChanges: this.props.stagedChanges,
      mergeConflicts: this.props.mergeConflicts,
      workingDirectoryPath: this.props.workingDirectoryPath || this.props.currentWorkDir,
      mergeMessage: this.props.mergeMessage,
      userStore: this.userStore,
      selectedCoAuthors: this.state.selectedCoAuthors,
      updateSelectedCoAuthors: this.updateSelectedCoAuthors,
      resolutionProgress: this.props.resolutionProgress,
      workspace: this.props.workspace,
      commands: this.props.commands,
      grammars: this.props.grammars,
      tooltips: this.props.tooltips,
      notificationManager: this.props.notificationManager,
      project: this.props.project,
      confirm: this.props.confirm,
      config: this.props.config,
      toggleIdentityEditor: this.toggleIdentityEditor,
      closeIdentityEditor: this.closeIdentityEditor,
      setLocalIdentity: this.setLocalIdentity,
      setGlobalIdentity: this.setGlobalIdentity,
      openInitializeDialog: this.props.openInitializeDialog,
      openFiles: this.props.openFiles,
      discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
      undoLastDiscard: this.props.undoLastDiscard,
      contextLocked: this.props.contextLocked,
      changeWorkingDirectory: this.props.changeWorkingDirectory,
      setContextLock: this.props.setContextLock,
      getCurrentWorkDirs: this.props.getCurrentWorkDirs,
      onDidChangeWorkDirs: this.props.onDidChangeWorkDirs,
      attemptFileStageOperation: this.attemptFileStageOperation,
      attemptStageAllOperation: this.attemptStageAllOperation,
      prepareToCommit: this.prepareToCommit,
      commit: this.commit,
      undoLastCommit: this.undoLastCommit,
      push: this.push,
      pull: this.pull,
      fetch: this.fetch,
      checkout: this.checkout,
      abortMerge: this.abortMerge,
      resolveAsOurs: this.resolveAsOurs,
      resolveAsTheirs: this.resolveAsTheirs
    });
  }

  componentDidMount() {
    this.refreshResolutionProgress(false, false);
    this.refRoot.map(root => root.addEventListener('focusin', this.rememberLastFocus));

    if (this.props.controllerRef) {
      this.props.controllerRef.setter(this);
    }
  }

  componentDidUpdate(prevProps) {
    this.userStore.setRepository(this.props.repository);
    this.userStore.setLoginModel(this.props.loginModel);
    this.refreshResolutionProgress(false, false);

    if (prevProps.username !== this.props.username) {
      this.usernameBuffer.setTextViaDiff(this.props.username);
    }

    if (prevProps.email !== this.props.email) {
      this.emailBuffer.setTextViaDiff(this.props.email);
    }
  }

  componentWillUnmount() {
    this.refRoot.map(root => root.removeEventListener('focusin', this.rememberLastFocus));
  }
  /*
   * Begin (but don't await) an async conflict-counting task for each merge conflict path that has no conflict
   * marker count yet. Omit any path that's already open in a TextEditor or that has already been counted.
   *
   * includeOpen - update marker counts for files that are currently open in TextEditors
   * includeCounted - update marker counts for files that have been counted before
   */


  refreshResolutionProgress(includeOpen, includeCounted) {
    if (this.props.fetchInProgress) {
      return;
    }

    const openPaths = new Set(this.props.workspace.getTextEditors().map(editor => editor.getPath()));

    for (let i = 0; i < this.props.mergeConflicts.length; i++) {
      const conflictPath = _path.default.join(this.props.workingDirectoryPath, this.props.mergeConflicts[i].filePath);

      if (!includeOpen && openPaths.has(conflictPath)) {
        continue;
      }

      if (!includeCounted && this.props.resolutionProgress.getRemaining(conflictPath) !== undefined) {
        continue;
      }

      this.props.refreshResolutionProgress(conflictPath);
    }
  }

  async stageFiles(filePaths) {
    const pathsToStage = new Set(filePaths);
    const mergeMarkers = await Promise.all(filePaths.map(async filePath => {
      return {
        filePath,
        hasMarkers: await this.props.repository.pathHasMergeMarkers(filePath)
      };
    }));

    for (const {
      filePath,
      hasMarkers
    } of mergeMarkers) {
      if (hasMarkers) {
        const choice = this.props.confirm({
          message: 'File contains merge markers: ',
          detailedMessage: `Do you still want to stage this file?\n${filePath}`,
          buttons: ['Stage', 'Cancel']
        });

        if (choice !== 0) {
          pathsToStage.delete(filePath);
        }
      }
    }

    return this.props.repository.stageFiles(Array.from(pathsToStage));
  }

  unstageFiles(filePaths) {
    return this.props.repository.unstageFiles(filePaths);
  }

  async setIdentity(options) {
    const newUsername = this.usernameBuffer.getText();
    const newEmail = this.emailBuffer.getText();

    if (newUsername.length > 0 || options.global) {
      await this.props.repository.setConfig('user.name', newUsername, options);
    } else {
      await this.props.repository.unsetConfig('user.name');
    }

    if (newEmail.length > 0 || options.global) {
      await this.props.repository.setConfig('user.email', newEmail, options);
    } else {
      await this.props.repository.unsetConfig('user.email');
    }

    this.closeIdentityEditor();
  }

  restoreFocus() {
    this.refView.map(view => view.setFocus(this.lastFocus));
  }

  hasFocus() {
    return this.refRoot.map(root => root.contains(document.activeElement)).getOr(false);
  }

  wasActivated(isStillActive) {
    process.nextTick(() => {
      isStillActive() && this.restoreFocus();
    });
  }

  focusAndSelectStagingItem(filePath, stagingStatus) {
    return this.refView.map(view => view.focusAndSelectStagingItem(filePath, stagingStatus)).getOr(null);
  }

  focusAndSelectCommitPreviewButton() {
    return this.refView.map(view => view.focusAndSelectCommitPreviewButton());
  }

  focusAndSelectRecentCommit() {
    return this.refView.map(view => view.focusAndSelectRecentCommit());
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.refView.map(view => view.quietlySelectItem(filePath, stagingStatus)).getOr(null);
  }

}

exports.default = GitTabController;

_defineProperty(GitTabController, "focus", _objectSpread2({}, _gitTabView.default.focus));

_defineProperty(GitTabController, "propTypes", {
  repository: _propTypes.default.object.isRequired,
  loginModel: _propTypes.default.object.isRequired,
  username: _propTypes.default.string.isRequired,
  email: _propTypes.default.string.isRequired,
  lastCommit: _propTypes2.CommitPropType.isRequired,
  recentCommits: _propTypes.default.arrayOf(_propTypes2.CommitPropType).isRequired,
  isMerging: _propTypes.default.bool.isRequired,
  isRebasing: _propTypes.default.bool.isRequired,
  hasUndoHistory: _propTypes.default.bool.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  unstagedChanges: _propTypes.default.arrayOf(_propTypes2.FilePatchItemPropType).isRequired,
  stagedChanges: _propTypes.default.arrayOf(_propTypes2.FilePatchItemPropType).isRequired,
  mergeConflicts: _propTypes.default.arrayOf(_propTypes2.MergeConflictItemPropType).isRequired,
  workingDirectoryPath: _propTypes.default.string,
  mergeMessage: _propTypes.default.string,
  fetchInProgress: _propTypes.default.bool.isRequired,
  currentWorkDir: _propTypes.default.string,
  repositoryDrift: _propTypes.default.bool.isRequired,
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  grammars: _propTypes.default.object.isRequired,
  resolutionProgress: _propTypes.default.object.isRequired,
  notificationManager: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  project: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  confirm: _propTypes.default.func.isRequired,
  ensureGitTab: _propTypes.default.func.isRequired,
  refreshResolutionProgress: _propTypes.default.func.isRequired,
  undoLastDiscard: _propTypes.default.func.isRequired,
  discardWorkDirChangesForPaths: _propTypes.default.func.isRequired,
  openFiles: _propTypes.default.func.isRequired,
  openInitializeDialog: _propTypes.default.func.isRequired,
  controllerRef: _propTypes2.RefHolderPropType,
  contextLocked: _propTypes.default.bool.isRequired,
  changeWorkingDirectory: _propTypes.default.func.isRequired,
  setContextLock: _propTypes.default.func.isRequired,
  onDidChangeWorkDirs: _propTypes.default.func.isRequired,
  getCurrentWorkDirs: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdpdC10YWItY29udHJvbGxlci5qcyJdLCJuYW1lcyI6WyJHaXRUYWJDb250cm9sbGVyIiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwiY29udGV4dCIsInN0YWdlU3RhdHVzIiwiYXR0ZW1wdEZpbGVTdGFnZU9wZXJhdGlvbiIsImZpbGVQYXRocyIsInN0YWdpbmdPcGVyYXRpb25JblByb2dyZXNzIiwic3RhZ2VPcGVyYXRpb25Qcm9taXNlIiwiUHJvbWlzZSIsInJlc29sdmUiLCJzZWxlY3Rpb25VcGRhdGVQcm9taXNlIiwiZmlsZUxpc3RVcGRhdGVQcm9taXNlIiwicmVmU3RhZ2luZ1ZpZXciLCJtYXAiLCJ2aWV3IiwiZ2V0TmV4dExpc3RVcGRhdGVQcm9taXNlIiwiZ2V0T3IiLCJ1bnN0YWdlRmlsZXMiLCJzdGFnZUZpbGVzIiwidGhlbiIsImVuc3VyZUdpdFRhYiIsIm1lc3NhZ2UiLCJvcHRpb25zIiwicmVwb3NpdG9yeSIsImNvbW1pdCIsInNlbGVjdGVkQ29BdXRob3JzIiwibmV3QXV0aG9yIiwidXNlclN0b3JlIiwiYWRkVXNlcnMiLCJjb25jYXQiLCJzZXRTdGF0ZSIsInJlcG8iLCJsYXN0Q29tbWl0IiwiZ2V0TGFzdENvbW1pdCIsImlzVW5ib3JuUmVmIiwidW5kb0xhc3RDb21taXQiLCJzZXRDb21taXRNZXNzYWdlIiwiZ2V0RnVsbE1lc3NhZ2UiLCJ1cGRhdGVTZWxlY3RlZENvQXV0aG9ycyIsImdldENvQXV0aG9ycyIsImNob2ljZSIsImNvbmZpcm0iLCJkZXRhaWxlZE1lc3NhZ2UiLCJidXR0b25zIiwiYWJvcnRNZXJnZSIsImUiLCJjb2RlIiwibm90aWZpY2F0aW9uTWFuYWdlciIsImFkZEVycm9yIiwicGF0aCIsImRpc21pc3NhYmxlIiwicGF0aHMiLCJmZXRjaEluUHJvZ3Jlc3MiLCJzaWRlIiwiaXNSZWJhc2luZyIsImNoZWNrb3V0U2lkZSIsInJlZnJlc2hSZXNvbHV0aW9uUHJvZ3Jlc3MiLCJicmFuY2hOYW1lIiwiY2hlY2tvdXQiLCJldmVudCIsImxhc3RGb2N1cyIsInJlZlZpZXciLCJnZXRGb2N1cyIsInRhcmdldCIsIkdpdFRhYlZpZXciLCJmb2N1cyIsIlNUQUdJTkciLCJiZWZvcmUiLCJlZGl0aW5nSWRlbnRpdHkiLCJzZXRJZGVudGl0eSIsImdsb2JhbCIsIlJlZkhvbGRlciIsInJlZlJvb3QiLCJzdGF0ZSIsInVzZXJuYW1lQnVmZmVyIiwiVGV4dEJ1ZmZlciIsInRleHQiLCJ1c2VybmFtZSIsInJldGFpbiIsImVtYWlsQnVmZmVyIiwiZW1haWwiLCJVc2VyU3RvcmUiLCJsb2dpbiIsImxvZ2luTW9kZWwiLCJjb25maWciLCJnZXREZXJpdmVkU3RhdGVGcm9tUHJvcHMiLCJpc1ByZXNlbnQiLCJyZXBvc2l0b3J5RHJpZnQiLCJyZW5kZXIiLCJzZXR0ZXIiLCJyZWNlbnRDb21taXRzIiwiaXNNZXJnaW5nIiwiaGFzVW5kb0hpc3RvcnkiLCJjdXJyZW50QnJhbmNoIiwidW5zdGFnZWRDaGFuZ2VzIiwic3RhZ2VkQ2hhbmdlcyIsIm1lcmdlQ29uZmxpY3RzIiwid29ya2luZ0RpcmVjdG9yeVBhdGgiLCJjdXJyZW50V29ya0RpciIsIm1lcmdlTWVzc2FnZSIsInJlc29sdXRpb25Qcm9ncmVzcyIsIndvcmtzcGFjZSIsImNvbW1hbmRzIiwiZ3JhbW1hcnMiLCJ0b29sdGlwcyIsInByb2plY3QiLCJ0b2dnbGVJZGVudGl0eUVkaXRvciIsImNsb3NlSWRlbnRpdHlFZGl0b3IiLCJzZXRMb2NhbElkZW50aXR5Iiwic2V0R2xvYmFsSWRlbnRpdHkiLCJvcGVuSW5pdGlhbGl6ZURpYWxvZyIsIm9wZW5GaWxlcyIsImRpc2NhcmRXb3JrRGlyQ2hhbmdlc0ZvclBhdGhzIiwidW5kb0xhc3REaXNjYXJkIiwiY29udGV4dExvY2tlZCIsImNoYW5nZVdvcmtpbmdEaXJlY3RvcnkiLCJzZXRDb250ZXh0TG9jayIsImdldEN1cnJlbnRXb3JrRGlycyIsIm9uRGlkQ2hhbmdlV29ya0RpcnMiLCJhdHRlbXB0U3RhZ2VBbGxPcGVyYXRpb24iLCJwcmVwYXJlVG9Db21taXQiLCJwdXNoIiwicHVsbCIsImZldGNoIiwicmVzb2x2ZUFzT3VycyIsInJlc29sdmVBc1RoZWlycyIsImNvbXBvbmVudERpZE1vdW50Iiwicm9vdCIsImFkZEV2ZW50TGlzdGVuZXIiLCJyZW1lbWJlckxhc3RGb2N1cyIsImNvbnRyb2xsZXJSZWYiLCJjb21wb25lbnREaWRVcGRhdGUiLCJwcmV2UHJvcHMiLCJzZXRSZXBvc2l0b3J5Iiwic2V0TG9naW5Nb2RlbCIsInNldFRleHRWaWFEaWZmIiwiY29tcG9uZW50V2lsbFVubW91bnQiLCJyZW1vdmVFdmVudExpc3RlbmVyIiwiaW5jbHVkZU9wZW4iLCJpbmNsdWRlQ291bnRlZCIsIm9wZW5QYXRocyIsIlNldCIsImdldFRleHRFZGl0b3JzIiwiZWRpdG9yIiwiZ2V0UGF0aCIsImkiLCJsZW5ndGgiLCJjb25mbGljdFBhdGgiLCJqb2luIiwiZmlsZVBhdGgiLCJoYXMiLCJnZXRSZW1haW5pbmciLCJ1bmRlZmluZWQiLCJwYXRoc1RvU3RhZ2UiLCJtZXJnZU1hcmtlcnMiLCJhbGwiLCJoYXNNYXJrZXJzIiwicGF0aEhhc01lcmdlTWFya2VycyIsImRlbGV0ZSIsIkFycmF5IiwiZnJvbSIsIm5ld1VzZXJuYW1lIiwiZ2V0VGV4dCIsIm5ld0VtYWlsIiwic2V0Q29uZmlnIiwidW5zZXRDb25maWciLCJyZXN0b3JlRm9jdXMiLCJzZXRGb2N1cyIsImhhc0ZvY3VzIiwiY29udGFpbnMiLCJkb2N1bWVudCIsImFjdGl2ZUVsZW1lbnQiLCJ3YXNBY3RpdmF0ZWQiLCJpc1N0aWxsQWN0aXZlIiwicHJvY2VzcyIsIm5leHRUaWNrIiwiZm9jdXNBbmRTZWxlY3RTdGFnaW5nSXRlbSIsInN0YWdpbmdTdGF0dXMiLCJmb2N1c0FuZFNlbGVjdENvbW1pdFByZXZpZXdCdXR0b24iLCJmb2N1c0FuZFNlbGVjdFJlY2VudENvbW1pdCIsInF1aWV0bHlTZWxlY3RJdGVtIiwiUHJvcFR5cGVzIiwib2JqZWN0IiwiaXNSZXF1aXJlZCIsInN0cmluZyIsIkNvbW1pdFByb3BUeXBlIiwiYXJyYXlPZiIsImJvb2wiLCJCcmFuY2hQcm9wVHlwZSIsIkZpbGVQYXRjaEl0ZW1Qcm9wVHlwZSIsIk1lcmdlQ29uZmxpY3RJdGVtUHJvcFR5cGUiLCJmdW5jIiwiUmVmSG9sZGVyUHJvcFR5cGUiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFFQTs7QUFDQTs7QUFDQTs7QUFFQTs7QUFDQTs7QUFDQTs7QUFDQTs7Ozs7Ozs7QUFJZSxNQUFNQSxnQkFBTixTQUErQkMsZUFBTUMsU0FBckMsQ0FBK0M7QUFrRDVEQyxFQUFBQSxXQUFXLENBQUNDLEtBQUQsRUFBUUMsT0FBUixFQUFpQjtBQUMxQixVQUFNRCxLQUFOLEVBQWFDLE9BQWI7O0FBRDBCLHNEQW9LREMsV0FBVyxJQUFJO0FBQ3hDLGFBQU8sS0FBS0MseUJBQUwsQ0FBK0IsQ0FBQyxHQUFELENBQS9CLEVBQXNDRCxXQUF0QyxDQUFQO0FBQ0QsS0F0SzJCOztBQUFBLHVEQXdLQSxDQUFDRSxTQUFELEVBQVlGLFdBQVosS0FBNEI7QUFDdEQsVUFBSSxLQUFLRywwQkFBVCxFQUFxQztBQUNuQyxlQUFPO0FBQ0xDLFVBQUFBLHFCQUFxQixFQUFFQyxPQUFPLENBQUNDLE9BQVIsRUFEbEI7QUFFTEMsVUFBQUEsc0JBQXNCLEVBQUVGLE9BQU8sQ0FBQ0MsT0FBUjtBQUZuQixTQUFQO0FBSUQ7O0FBRUQsV0FBS0gsMEJBQUwsR0FBa0MsSUFBbEM7QUFFQSxZQUFNSyxxQkFBcUIsR0FBRyxLQUFLQyxjQUFMLENBQW9CQyxHQUFwQixDQUF3QkMsSUFBSSxJQUFJO0FBQzVELGVBQU9BLElBQUksQ0FBQ0Msd0JBQUwsRUFBUDtBQUNELE9BRjZCLEVBRTNCQyxLQUYyQixDQUVyQlIsT0FBTyxDQUFDQyxPQUFSLEVBRnFCLENBQTlCO0FBR0EsVUFBSUYscUJBQUo7O0FBQ0EsVUFBSUosV0FBVyxLQUFLLFFBQXBCLEVBQThCO0FBQzVCSSxRQUFBQSxxQkFBcUIsR0FBRyxLQUFLVSxZQUFMLENBQWtCWixTQUFsQixDQUF4QjtBQUNELE9BRkQsTUFFTztBQUNMRSxRQUFBQSxxQkFBcUIsR0FBRyxLQUFLVyxVQUFMLENBQWdCYixTQUFoQixDQUF4QjtBQUNEOztBQUNELFlBQU1LLHNCQUFzQixHQUFHQyxxQkFBcUIsQ0FBQ1EsSUFBdEIsQ0FBMkIsTUFBTTtBQUM5RCxhQUFLYiwwQkFBTCxHQUFrQyxLQUFsQztBQUNELE9BRjhCLENBQS9CO0FBSUEsYUFBTztBQUFDQyxRQUFBQSxxQkFBRDtBQUF3QkcsUUFBQUE7QUFBeEIsT0FBUDtBQUNELEtBaE0yQjs7QUFBQSw2Q0FnT1YsWUFBWTtBQUM1QixhQUFPLEVBQUMsTUFBTSxLQUFLVCxLQUFMLENBQVdtQixZQUFYLEVBQVAsQ0FBUDtBQUNELEtBbE8yQjs7QUFBQSxvQ0FvT25CLENBQUNDLE9BQUQsRUFBVUMsT0FBVixLQUFzQjtBQUM3QixhQUFPLEtBQUtyQixLQUFMLENBQVdzQixVQUFYLENBQXNCQyxNQUF0QixDQUE2QkgsT0FBN0IsRUFBc0NDLE9BQXRDLENBQVA7QUFDRCxLQXRPMkI7O0FBQUEscURBd09GLENBQUNHLGlCQUFELEVBQW9CQyxTQUFwQixLQUFrQztBQUMxRCxVQUFJQSxTQUFKLEVBQWU7QUFDYixhQUFLQyxTQUFMLENBQWVDLFFBQWYsQ0FBd0IsQ0FBQ0YsU0FBRCxDQUF4QjtBQUNBRCxRQUFBQSxpQkFBaUIsR0FBR0EsaUJBQWlCLENBQUNJLE1BQWxCLENBQXlCLENBQUNILFNBQUQsQ0FBekIsQ0FBcEI7QUFDRDs7QUFDRCxXQUFLSSxRQUFMLENBQWM7QUFBQ0wsUUFBQUE7QUFBRCxPQUFkO0FBQ0QsS0E5TzJCOztBQUFBLDRDQWdQWCxZQUFZO0FBQzNCLFlBQU1NLElBQUksR0FBRyxLQUFLOUIsS0FBTCxDQUFXc0IsVUFBeEI7QUFDQSxZQUFNUyxVQUFVLEdBQUcsTUFBTUQsSUFBSSxDQUFDRSxhQUFMLEVBQXpCOztBQUNBLFVBQUlELFVBQVUsQ0FBQ0UsV0FBWCxFQUFKLEVBQThCO0FBQUUsZUFBTyxJQUFQO0FBQWM7O0FBRTlDLFlBQU1ILElBQUksQ0FBQ0ksY0FBTCxFQUFOO0FBQ0FKLE1BQUFBLElBQUksQ0FBQ0ssZ0JBQUwsQ0FBc0JKLFVBQVUsQ0FBQ0ssY0FBWCxFQUF0QjtBQUNBLFdBQUtDLHVCQUFMLENBQTZCTixVQUFVLENBQUNPLFlBQVgsRUFBN0I7QUFFQSxhQUFPLElBQVA7QUFDRCxLQTFQMkI7O0FBQUEsd0NBNFBmLFlBQVk7QUFDdkIsWUFBTUMsTUFBTSxHQUFHLEtBQUt2QyxLQUFMLENBQVd3QyxPQUFYLENBQW1CO0FBQ2hDcEIsUUFBQUEsT0FBTyxFQUFFLGFBRHVCO0FBRWhDcUIsUUFBQUEsZUFBZSxFQUFFLGVBRmU7QUFHaENDLFFBQUFBLE9BQU8sRUFBRSxDQUFDLE9BQUQsRUFBVSxRQUFWO0FBSHVCLE9BQW5CLENBQWY7O0FBS0EsVUFBSUgsTUFBTSxLQUFLLENBQWYsRUFBa0I7QUFBRTtBQUFTOztBQUU3QixVQUFJO0FBQ0YsY0FBTSxLQUFLdkMsS0FBTCxDQUFXc0IsVUFBWCxDQUFzQnFCLFVBQXRCLEVBQU47QUFDRCxPQUZELENBRUUsT0FBT0MsQ0FBUCxFQUFVO0FBQ1YsWUFBSUEsQ0FBQyxDQUFDQyxJQUFGLEtBQVcsY0FBZixFQUErQjtBQUM3QixlQUFLN0MsS0FBTCxDQUFXOEMsbUJBQVgsQ0FBK0JDLFFBQS9CLENBQ0csd0JBQXVCSCxDQUFDLENBQUNJLElBQUssNEJBRGpDLEVBRUU7QUFBQ0MsWUFBQUEsV0FBVyxFQUFFO0FBQWQsV0FGRjtBQUlELFNBTEQsTUFLTztBQUNMLGdCQUFNTCxDQUFOO0FBQ0Q7QUFDRjtBQUNGLEtBaFIyQjs7QUFBQSwyQ0FrUlosTUFBTU0sS0FBTixJQUFlO0FBQzdCLFVBQUksS0FBS2xELEtBQUwsQ0FBV21ELGVBQWYsRUFBZ0M7QUFDOUI7QUFDRDs7QUFFRCxZQUFNQyxJQUFJLEdBQUcsS0FBS3BELEtBQUwsQ0FBV3FELFVBQVgsR0FBd0IsUUFBeEIsR0FBbUMsTUFBaEQ7QUFDQSxZQUFNLEtBQUtyRCxLQUFMLENBQVdzQixVQUFYLENBQXNCZ0MsWUFBdEIsQ0FBbUNGLElBQW5DLEVBQXlDRixLQUF6QyxDQUFOO0FBQ0EsV0FBS0sseUJBQUwsQ0FBK0IsS0FBL0IsRUFBc0MsSUFBdEM7QUFDRCxLQTFSMkI7O0FBQUEsNkNBNFJWLE1BQU1MLEtBQU4sSUFBZTtBQUMvQixVQUFJLEtBQUtsRCxLQUFMLENBQVdtRCxlQUFmLEVBQWdDO0FBQzlCO0FBQ0Q7O0FBRUQsWUFBTUMsSUFBSSxHQUFHLEtBQUtwRCxLQUFMLENBQVdxRCxVQUFYLEdBQXdCLE1BQXhCLEdBQWlDLFFBQTlDO0FBQ0EsWUFBTSxLQUFLckQsS0FBTCxDQUFXc0IsVUFBWCxDQUFzQmdDLFlBQXRCLENBQW1DRixJQUFuQyxFQUF5Q0YsS0FBekMsQ0FBTjtBQUNBLFdBQUtLLHlCQUFMLENBQStCLEtBQS9CLEVBQXNDLElBQXRDO0FBQ0QsS0FwUzJCOztBQUFBLHNDQXNTakIsQ0FBQ0MsVUFBRCxFQUFhbkMsT0FBYixLQUF5QjtBQUNsQyxhQUFPLEtBQUtyQixLQUFMLENBQVdzQixVQUFYLENBQXNCbUMsUUFBdEIsQ0FBK0JELFVBQS9CLEVBQTJDbkMsT0FBM0MsQ0FBUDtBQUNELEtBeFMyQjs7QUFBQSwrQ0EwU1JxQyxLQUFLLElBQUk7QUFDM0IsV0FBS0MsU0FBTCxHQUFpQixLQUFLQyxPQUFMLENBQWFoRCxHQUFiLENBQWlCQyxJQUFJLElBQUlBLElBQUksQ0FBQ2dELFFBQUwsQ0FBY0gsS0FBSyxDQUFDSSxNQUFwQixDQUF6QixFQUFzRC9DLEtBQXRELENBQTRELElBQTVELEtBQXFFZ0Qsb0JBQVdDLEtBQVgsQ0FBaUJDLE9BQXZHO0FBQ0QsS0E1UzJCOztBQUFBLGtEQThTTCxNQUFNLEtBQUtwQyxRQUFMLENBQWNxQyxNQUFNLEtBQUs7QUFBQ0MsTUFBQUEsZUFBZSxFQUFFLENBQUNELE1BQU0sQ0FBQ0M7QUFBMUIsS0FBTCxDQUFwQixDQTlTRDs7QUFBQSxpREFnVE4sTUFBTSxLQUFLdEMsUUFBTCxDQUFjO0FBQUNzQyxNQUFBQSxlQUFlLEVBQUU7QUFBbEIsS0FBZCxDQWhUQTs7QUFBQSw4Q0FrVFQsTUFBTSxLQUFLQyxXQUFMLENBQWlCLEVBQWpCLENBbFRHOztBQUFBLCtDQW9UUixNQUFNLEtBQUtBLFdBQUwsQ0FBaUI7QUFBQ0MsTUFBQUEsTUFBTSxFQUFFO0FBQVQsS0FBakIsQ0FwVEU7O0FBRzFCLFNBQUtoRSwwQkFBTCxHQUFrQyxLQUFsQztBQUNBLFNBQUtzRCxTQUFMLEdBQWlCSSxvQkFBV0MsS0FBWCxDQUFpQkMsT0FBbEM7QUFFQSxTQUFLTCxPQUFMLEdBQWUsSUFBSVUsa0JBQUosRUFBZjtBQUNBLFNBQUtDLE9BQUwsR0FBZSxJQUFJRCxrQkFBSixFQUFmO0FBQ0EsU0FBSzNELGNBQUwsR0FBc0IsSUFBSTJELGtCQUFKLEVBQXRCO0FBRUEsU0FBS0UsS0FBTCxHQUFhO0FBQ1hoRCxNQUFBQSxpQkFBaUIsRUFBRSxFQURSO0FBRVgyQyxNQUFBQSxlQUFlLEVBQUU7QUFGTixLQUFiO0FBS0EsU0FBS00sY0FBTCxHQUFzQixJQUFJQyxnQkFBSixDQUFlO0FBQUNDLE1BQUFBLElBQUksRUFBRTNFLEtBQUssQ0FBQzRFO0FBQWIsS0FBZixDQUF0QjtBQUNBLFNBQUtILGNBQUwsQ0FBb0JJLE1BQXBCO0FBQ0EsU0FBS0MsV0FBTCxHQUFtQixJQUFJSixnQkFBSixDQUFlO0FBQUNDLE1BQUFBLElBQUksRUFBRTNFLEtBQUssQ0FBQytFO0FBQWIsS0FBZixDQUFuQjtBQUNBLFNBQUtELFdBQUwsQ0FBaUJELE1BQWpCO0FBRUEsU0FBS25ELFNBQUwsR0FBaUIsSUFBSXNELGtCQUFKLENBQWM7QUFDN0IxRCxNQUFBQSxVQUFVLEVBQUUsS0FBS3RCLEtBQUwsQ0FBV3NCLFVBRE07QUFFN0IyRCxNQUFBQSxLQUFLLEVBQUUsS0FBS2pGLEtBQUwsQ0FBV2tGLFVBRlc7QUFHN0JDLE1BQUFBLE1BQU0sRUFBRSxLQUFLbkYsS0FBTCxDQUFXbUY7QUFIVSxLQUFkLENBQWpCO0FBS0Q7O0FBRUQsU0FBT0Msd0JBQVAsQ0FBZ0NwRixLQUFoQyxFQUF1Q3dFLEtBQXZDLEVBQThDO0FBQzVDLFdBQU87QUFDTEwsTUFBQUEsZUFBZSxFQUFFSyxLQUFLLENBQUNMLGVBQU4sSUFDZCxDQUFDbkUsS0FBSyxDQUFDbUQsZUFBUCxJQUEwQm5ELEtBQUssQ0FBQ3NCLFVBQU4sQ0FBaUIrRCxTQUFqQixFQUExQixJQUEwRCxDQUFDckYsS0FBSyxDQUFDc0YsZUFBbEUsS0FDQ3RGLEtBQUssQ0FBQzRFLFFBQU4sS0FBbUIsRUFBbkIsSUFBeUI1RSxLQUFLLENBQUMrRSxLQUFOLEtBQWdCLEVBRDFDO0FBRkcsS0FBUDtBQUtEOztBQUVEUSxFQUFBQSxNQUFNLEdBQUc7QUFDUCxXQUNFLDZCQUFDLG1CQUFEO0FBQ0UsTUFBQSxHQUFHLEVBQUUsS0FBSzNCLE9BQUwsQ0FBYTRCLE1BRHBCO0FBRUUsTUFBQSxPQUFPLEVBQUUsS0FBS2pCLE9BRmhCO0FBR0UsTUFBQSxjQUFjLEVBQUUsS0FBSzVELGNBSHZCO0FBS0UsTUFBQSxTQUFTLEVBQUUsS0FBS1gsS0FBTCxDQUFXbUQsZUFMeEI7QUFNRSxNQUFBLGVBQWUsRUFBRSxLQUFLcUIsS0FBTCxDQUFXTCxlQU45QjtBQU9FLE1BQUEsVUFBVSxFQUFFLEtBQUtuRSxLQUFMLENBQVdzQixVQVB6QjtBQVNFLE1BQUEsY0FBYyxFQUFFLEtBQUttRCxjQVR2QjtBQVVFLE1BQUEsV0FBVyxFQUFFLEtBQUtLLFdBVnBCO0FBV0UsTUFBQSxVQUFVLEVBQUUsS0FBSzlFLEtBQUwsQ0FBVytCLFVBWHpCO0FBWUUsTUFBQSxhQUFhLEVBQUUsS0FBSy9CLEtBQUwsQ0FBV3lGLGFBWjVCO0FBYUUsTUFBQSxTQUFTLEVBQUUsS0FBS3pGLEtBQUwsQ0FBVzBGLFNBYnhCO0FBY0UsTUFBQSxVQUFVLEVBQUUsS0FBSzFGLEtBQUwsQ0FBV3FELFVBZHpCO0FBZUUsTUFBQSxjQUFjLEVBQUUsS0FBS3JELEtBQUwsQ0FBVzJGLGNBZjdCO0FBZ0JFLE1BQUEsYUFBYSxFQUFFLEtBQUszRixLQUFMLENBQVc0RixhQWhCNUI7QUFpQkUsTUFBQSxlQUFlLEVBQUUsS0FBSzVGLEtBQUwsQ0FBVzZGLGVBakI5QjtBQWtCRSxNQUFBLGFBQWEsRUFBRSxLQUFLN0YsS0FBTCxDQUFXOEYsYUFsQjVCO0FBbUJFLE1BQUEsY0FBYyxFQUFFLEtBQUs5RixLQUFMLENBQVcrRixjQW5CN0I7QUFvQkUsTUFBQSxvQkFBb0IsRUFBRSxLQUFLL0YsS0FBTCxDQUFXZ0csb0JBQVgsSUFBbUMsS0FBS2hHLEtBQUwsQ0FBV2lHLGNBcEJ0RTtBQXFCRSxNQUFBLFlBQVksRUFBRSxLQUFLakcsS0FBTCxDQUFXa0csWUFyQjNCO0FBc0JFLE1BQUEsU0FBUyxFQUFFLEtBQUt4RSxTQXRCbEI7QUF1QkUsTUFBQSxpQkFBaUIsRUFBRSxLQUFLOEMsS0FBTCxDQUFXaEQsaUJBdkJoQztBQXdCRSxNQUFBLHVCQUF1QixFQUFFLEtBQUthLHVCQXhCaEM7QUEwQkUsTUFBQSxrQkFBa0IsRUFBRSxLQUFLckMsS0FBTCxDQUFXbUcsa0JBMUJqQztBQTJCRSxNQUFBLFNBQVMsRUFBRSxLQUFLbkcsS0FBTCxDQUFXb0csU0EzQnhCO0FBNEJFLE1BQUEsUUFBUSxFQUFFLEtBQUtwRyxLQUFMLENBQVdxRyxRQTVCdkI7QUE2QkUsTUFBQSxRQUFRLEVBQUUsS0FBS3JHLEtBQUwsQ0FBV3NHLFFBN0J2QjtBQThCRSxNQUFBLFFBQVEsRUFBRSxLQUFLdEcsS0FBTCxDQUFXdUcsUUE5QnZCO0FBK0JFLE1BQUEsbUJBQW1CLEVBQUUsS0FBS3ZHLEtBQUwsQ0FBVzhDLG1CQS9CbEM7QUFnQ0UsTUFBQSxPQUFPLEVBQUUsS0FBSzlDLEtBQUwsQ0FBV3dHLE9BaEN0QjtBQWlDRSxNQUFBLE9BQU8sRUFBRSxLQUFLeEcsS0FBTCxDQUFXd0MsT0FqQ3RCO0FBa0NFLE1BQUEsTUFBTSxFQUFFLEtBQUt4QyxLQUFMLENBQVdtRixNQWxDckI7QUFvQ0UsTUFBQSxvQkFBb0IsRUFBRSxLQUFLc0Isb0JBcEM3QjtBQXFDRSxNQUFBLG1CQUFtQixFQUFFLEtBQUtDLG1CQXJDNUI7QUFzQ0UsTUFBQSxnQkFBZ0IsRUFBRSxLQUFLQyxnQkF0Q3pCO0FBdUNFLE1BQUEsaUJBQWlCLEVBQUUsS0FBS0MsaUJBdkMxQjtBQXdDRSxNQUFBLG9CQUFvQixFQUFFLEtBQUs1RyxLQUFMLENBQVc2RyxvQkF4Q25DO0FBeUNFLE1BQUEsU0FBUyxFQUFFLEtBQUs3RyxLQUFMLENBQVc4RyxTQXpDeEI7QUEwQ0UsTUFBQSw2QkFBNkIsRUFBRSxLQUFLOUcsS0FBTCxDQUFXK0csNkJBMUM1QztBQTJDRSxNQUFBLGVBQWUsRUFBRSxLQUFLL0csS0FBTCxDQUFXZ0gsZUEzQzlCO0FBNENFLE1BQUEsYUFBYSxFQUFFLEtBQUtoSCxLQUFMLENBQVdpSCxhQTVDNUI7QUE2Q0UsTUFBQSxzQkFBc0IsRUFBRSxLQUFLakgsS0FBTCxDQUFXa0gsc0JBN0NyQztBQThDRSxNQUFBLGNBQWMsRUFBRSxLQUFLbEgsS0FBTCxDQUFXbUgsY0E5QzdCO0FBK0NFLE1BQUEsa0JBQWtCLEVBQUUsS0FBS25ILEtBQUwsQ0FBV29ILGtCQS9DakM7QUFnREUsTUFBQSxtQkFBbUIsRUFBRSxLQUFLcEgsS0FBTCxDQUFXcUgsbUJBaERsQztBQWtERSxNQUFBLHlCQUF5QixFQUFFLEtBQUtsSCx5QkFsRGxDO0FBbURFLE1BQUEsd0JBQXdCLEVBQUUsS0FBS21ILHdCQW5EakM7QUFvREUsTUFBQSxlQUFlLEVBQUUsS0FBS0MsZUFwRHhCO0FBcURFLE1BQUEsTUFBTSxFQUFFLEtBQUtoRyxNQXJEZjtBQXNERSxNQUFBLGNBQWMsRUFBRSxLQUFLVyxjQXREdkI7QUF1REUsTUFBQSxJQUFJLEVBQUUsS0FBS3NGLElBdkRiO0FBd0RFLE1BQUEsSUFBSSxFQUFFLEtBQUtDLElBeERiO0FBeURFLE1BQUEsS0FBSyxFQUFFLEtBQUtDLEtBekRkO0FBMERFLE1BQUEsUUFBUSxFQUFFLEtBQUtqRSxRQTFEakI7QUEyREUsTUFBQSxVQUFVLEVBQUUsS0FBS2QsVUEzRG5CO0FBNERFLE1BQUEsYUFBYSxFQUFFLEtBQUtnRixhQTVEdEI7QUE2REUsTUFBQSxlQUFlLEVBQUUsS0FBS0M7QUE3RHhCLE1BREY7QUFpRUQ7O0FBRURDLEVBQUFBLGlCQUFpQixHQUFHO0FBQ2xCLFNBQUt0RSx5QkFBTCxDQUErQixLQUEvQixFQUFzQyxLQUF0QztBQUNBLFNBQUtnQixPQUFMLENBQWEzRCxHQUFiLENBQWlCa0gsSUFBSSxJQUFJQSxJQUFJLENBQUNDLGdCQUFMLENBQXNCLFNBQXRCLEVBQWlDLEtBQUtDLGlCQUF0QyxDQUF6Qjs7QUFFQSxRQUFJLEtBQUtoSSxLQUFMLENBQVdpSSxhQUFmLEVBQThCO0FBQzVCLFdBQUtqSSxLQUFMLENBQVdpSSxhQUFYLENBQXlCekMsTUFBekIsQ0FBZ0MsSUFBaEM7QUFDRDtBQUNGOztBQUVEMEMsRUFBQUEsa0JBQWtCLENBQUNDLFNBQUQsRUFBWTtBQUM1QixTQUFLekcsU0FBTCxDQUFlMEcsYUFBZixDQUE2QixLQUFLcEksS0FBTCxDQUFXc0IsVUFBeEM7QUFDQSxTQUFLSSxTQUFMLENBQWUyRyxhQUFmLENBQTZCLEtBQUtySSxLQUFMLENBQVdrRixVQUF4QztBQUNBLFNBQUszQix5QkFBTCxDQUErQixLQUEvQixFQUFzQyxLQUF0Qzs7QUFFQSxRQUFJNEUsU0FBUyxDQUFDdkQsUUFBVixLQUF1QixLQUFLNUUsS0FBTCxDQUFXNEUsUUFBdEMsRUFBZ0Q7QUFDOUMsV0FBS0gsY0FBTCxDQUFvQjZELGNBQXBCLENBQW1DLEtBQUt0SSxLQUFMLENBQVc0RSxRQUE5QztBQUNEOztBQUVELFFBQUl1RCxTQUFTLENBQUNwRCxLQUFWLEtBQW9CLEtBQUsvRSxLQUFMLENBQVcrRSxLQUFuQyxFQUEwQztBQUN4QyxXQUFLRCxXQUFMLENBQWlCd0QsY0FBakIsQ0FBZ0MsS0FBS3RJLEtBQUwsQ0FBVytFLEtBQTNDO0FBQ0Q7QUFDRjs7QUFFRHdELEVBQUFBLG9CQUFvQixHQUFHO0FBQ3JCLFNBQUtoRSxPQUFMLENBQWEzRCxHQUFiLENBQWlCa0gsSUFBSSxJQUFJQSxJQUFJLENBQUNVLG1CQUFMLENBQXlCLFNBQXpCLEVBQW9DLEtBQUtSLGlCQUF6QyxDQUF6QjtBQUNEO0FBRUQ7Ozs7Ozs7OztBQU9BekUsRUFBQUEseUJBQXlCLENBQUNrRixXQUFELEVBQWNDLGNBQWQsRUFBOEI7QUFDckQsUUFBSSxLQUFLMUksS0FBTCxDQUFXbUQsZUFBZixFQUFnQztBQUM5QjtBQUNEOztBQUVELFVBQU13RixTQUFTLEdBQUcsSUFBSUMsR0FBSixDQUNoQixLQUFLNUksS0FBTCxDQUFXb0csU0FBWCxDQUFxQnlDLGNBQXJCLEdBQXNDakksR0FBdEMsQ0FBMENrSSxNQUFNLElBQUlBLE1BQU0sQ0FBQ0MsT0FBUCxFQUFwRCxDQURnQixDQUFsQjs7QUFJQSxTQUFLLElBQUlDLENBQUMsR0FBRyxDQUFiLEVBQWdCQSxDQUFDLEdBQUcsS0FBS2hKLEtBQUwsQ0FBVytGLGNBQVgsQ0FBMEJrRCxNQUE5QyxFQUFzREQsQ0FBQyxFQUF2RCxFQUEyRDtBQUN6RCxZQUFNRSxZQUFZLEdBQUdsRyxjQUFLbUcsSUFBTCxDQUNuQixLQUFLbkosS0FBTCxDQUFXZ0csb0JBRFEsRUFFbkIsS0FBS2hHLEtBQUwsQ0FBVytGLGNBQVgsQ0FBMEJpRCxDQUExQixFQUE2QkksUUFGVixDQUFyQjs7QUFLQSxVQUFJLENBQUNYLFdBQUQsSUFBZ0JFLFNBQVMsQ0FBQ1UsR0FBVixDQUFjSCxZQUFkLENBQXBCLEVBQWlEO0FBQy9DO0FBQ0Q7O0FBRUQsVUFBSSxDQUFDUixjQUFELElBQW1CLEtBQUsxSSxLQUFMLENBQVdtRyxrQkFBWCxDQUE4Qm1ELFlBQTlCLENBQTJDSixZQUEzQyxNQUE2REssU0FBcEYsRUFBK0Y7QUFDN0Y7QUFDRDs7QUFFRCxXQUFLdkosS0FBTCxDQUFXdUQseUJBQVgsQ0FBcUMyRixZQUFyQztBQUNEO0FBQ0Y7O0FBZ0NELFFBQU1qSSxVQUFOLENBQWlCYixTQUFqQixFQUE0QjtBQUMxQixVQUFNb0osWUFBWSxHQUFHLElBQUlaLEdBQUosQ0FBUXhJLFNBQVIsQ0FBckI7QUFFQSxVQUFNcUosWUFBWSxHQUFHLE1BQU1sSixPQUFPLENBQUNtSixHQUFSLENBQ3pCdEosU0FBUyxDQUFDUSxHQUFWLENBQWMsTUFBTXdJLFFBQU4sSUFBa0I7QUFDOUIsYUFBTztBQUNMQSxRQUFBQSxRQURLO0FBRUxPLFFBQUFBLFVBQVUsRUFBRSxNQUFNLEtBQUszSixLQUFMLENBQVdzQixVQUFYLENBQXNCc0ksbUJBQXRCLENBQTBDUixRQUExQztBQUZiLE9BQVA7QUFJRCxLQUxELENBRHlCLENBQTNCOztBQVNBLFNBQUssTUFBTTtBQUFDQSxNQUFBQSxRQUFEO0FBQVdPLE1BQUFBO0FBQVgsS0FBWCxJQUFxQ0YsWUFBckMsRUFBbUQ7QUFDakQsVUFBSUUsVUFBSixFQUFnQjtBQUNkLGNBQU1wSCxNQUFNLEdBQUcsS0FBS3ZDLEtBQUwsQ0FBV3dDLE9BQVgsQ0FBbUI7QUFDaENwQixVQUFBQSxPQUFPLEVBQUUsK0JBRHVCO0FBRWhDcUIsVUFBQUEsZUFBZSxFQUFHLDBDQUF5QzJHLFFBQVMsRUFGcEM7QUFHaEMxRyxVQUFBQSxPQUFPLEVBQUUsQ0FBQyxPQUFELEVBQVUsUUFBVjtBQUh1QixTQUFuQixDQUFmOztBQUtBLFlBQUlILE1BQU0sS0FBSyxDQUFmLEVBQWtCO0FBQUVpSCxVQUFBQSxZQUFZLENBQUNLLE1BQWIsQ0FBb0JULFFBQXBCO0FBQWdDO0FBQ3JEO0FBQ0Y7O0FBRUQsV0FBTyxLQUFLcEosS0FBTCxDQUFXc0IsVUFBWCxDQUFzQkwsVUFBdEIsQ0FBaUM2SSxLQUFLLENBQUNDLElBQU4sQ0FBV1AsWUFBWCxDQUFqQyxDQUFQO0FBQ0Q7O0FBRUR4SSxFQUFBQSxZQUFZLENBQUNaLFNBQUQsRUFBWTtBQUN0QixXQUFPLEtBQUtKLEtBQUwsQ0FBV3NCLFVBQVgsQ0FBc0JOLFlBQXRCLENBQW1DWixTQUFuQyxDQUFQO0FBQ0Q7O0FBd0ZELFFBQU1nRSxXQUFOLENBQWtCL0MsT0FBbEIsRUFBMkI7QUFDekIsVUFBTTJJLFdBQVcsR0FBRyxLQUFLdkYsY0FBTCxDQUFvQndGLE9BQXBCLEVBQXBCO0FBQ0EsVUFBTUMsUUFBUSxHQUFHLEtBQUtwRixXQUFMLENBQWlCbUYsT0FBakIsRUFBakI7O0FBRUEsUUFBSUQsV0FBVyxDQUFDZixNQUFaLEdBQXFCLENBQXJCLElBQTBCNUgsT0FBTyxDQUFDZ0QsTUFBdEMsRUFBOEM7QUFDNUMsWUFBTSxLQUFLckUsS0FBTCxDQUFXc0IsVUFBWCxDQUFzQjZJLFNBQXRCLENBQWdDLFdBQWhDLEVBQTZDSCxXQUE3QyxFQUEwRDNJLE9BQTFELENBQU47QUFDRCxLQUZELE1BRU87QUFDTCxZQUFNLEtBQUtyQixLQUFMLENBQVdzQixVQUFYLENBQXNCOEksV0FBdEIsQ0FBa0MsV0FBbEMsQ0FBTjtBQUNEOztBQUVELFFBQUlGLFFBQVEsQ0FBQ2pCLE1BQVQsR0FBa0IsQ0FBbEIsSUFBdUI1SCxPQUFPLENBQUNnRCxNQUFuQyxFQUEyQztBQUN6QyxZQUFNLEtBQUtyRSxLQUFMLENBQVdzQixVQUFYLENBQXNCNkksU0FBdEIsQ0FBZ0MsWUFBaEMsRUFBOENELFFBQTlDLEVBQXdEN0ksT0FBeEQsQ0FBTjtBQUNELEtBRkQsTUFFTztBQUNMLFlBQU0sS0FBS3JCLEtBQUwsQ0FBV3NCLFVBQVgsQ0FBc0I4SSxXQUF0QixDQUFrQyxZQUFsQyxDQUFOO0FBQ0Q7O0FBQ0QsU0FBSzFELG1CQUFMO0FBQ0Q7O0FBRUQyRCxFQUFBQSxZQUFZLEdBQUc7QUFDYixTQUFLekcsT0FBTCxDQUFhaEQsR0FBYixDQUFpQkMsSUFBSSxJQUFJQSxJQUFJLENBQUN5SixRQUFMLENBQWMsS0FBSzNHLFNBQW5CLENBQXpCO0FBQ0Q7O0FBRUQ0RyxFQUFBQSxRQUFRLEdBQUc7QUFDVCxXQUFPLEtBQUtoRyxPQUFMLENBQWEzRCxHQUFiLENBQWlCa0gsSUFBSSxJQUFJQSxJQUFJLENBQUMwQyxRQUFMLENBQWNDLFFBQVEsQ0FBQ0MsYUFBdkIsQ0FBekIsRUFBZ0UzSixLQUFoRSxDQUFzRSxLQUF0RSxDQUFQO0FBQ0Q7O0FBRUQ0SixFQUFBQSxZQUFZLENBQUNDLGFBQUQsRUFBZ0I7QUFDMUJDLElBQUFBLE9BQU8sQ0FBQ0MsUUFBUixDQUFpQixNQUFNO0FBQ3JCRixNQUFBQSxhQUFhLE1BQU0sS0FBS1AsWUFBTCxFQUFuQjtBQUNELEtBRkQ7QUFHRDs7QUFFRFUsRUFBQUEseUJBQXlCLENBQUMzQixRQUFELEVBQVc0QixhQUFYLEVBQTBCO0FBQ2pELFdBQU8sS0FBS3BILE9BQUwsQ0FBYWhELEdBQWIsQ0FBaUJDLElBQUksSUFBSUEsSUFBSSxDQUFDa0sseUJBQUwsQ0FBK0IzQixRQUEvQixFQUF5QzRCLGFBQXpDLENBQXpCLEVBQWtGakssS0FBbEYsQ0FBd0YsSUFBeEYsQ0FBUDtBQUNEOztBQUVEa0ssRUFBQUEsaUNBQWlDLEdBQUc7QUFDbEMsV0FBTyxLQUFLckgsT0FBTCxDQUFhaEQsR0FBYixDQUFpQkMsSUFBSSxJQUFJQSxJQUFJLENBQUNvSyxpQ0FBTCxFQUF6QixDQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLDBCQUEwQixHQUFHO0FBQzNCLFdBQU8sS0FBS3RILE9BQUwsQ0FBYWhELEdBQWIsQ0FBaUJDLElBQUksSUFBSUEsSUFBSSxDQUFDcUssMEJBQUwsRUFBekIsQ0FBUDtBQUNEOztBQUVEQyxFQUFBQSxpQkFBaUIsQ0FBQy9CLFFBQUQsRUFBVzRCLGFBQVgsRUFBMEI7QUFDekMsV0FBTyxLQUFLcEgsT0FBTCxDQUFhaEQsR0FBYixDQUFpQkMsSUFBSSxJQUFJQSxJQUFJLENBQUNzSyxpQkFBTCxDQUF1Qi9CLFFBQXZCLEVBQWlDNEIsYUFBakMsQ0FBekIsRUFBMEVqSyxLQUExRSxDQUFnRixJQUFoRixDQUFQO0FBQ0Q7O0FBdFoyRDs7OztnQkFBekNuQixnQiw4QkFFZG1FLG9CQUFXQyxLOztnQkFGR3BFLGdCLGVBS0E7QUFDakIwQixFQUFBQSxVQUFVLEVBQUU4SixtQkFBVUMsTUFBVixDQUFpQkMsVUFEWjtBQUVqQnBHLEVBQUFBLFVBQVUsRUFBRWtHLG1CQUFVQyxNQUFWLENBQWlCQyxVQUZaO0FBSWpCMUcsRUFBQUEsUUFBUSxFQUFFd0csbUJBQVVHLE1BQVYsQ0FBaUJELFVBSlY7QUFLakJ2RyxFQUFBQSxLQUFLLEVBQUVxRyxtQkFBVUcsTUFBVixDQUFpQkQsVUFMUDtBQU1qQnZKLEVBQUFBLFVBQVUsRUFBRXlKLDJCQUFlRixVQU5WO0FBT2pCN0YsRUFBQUEsYUFBYSxFQUFFMkYsbUJBQVVLLE9BQVYsQ0FBa0JELDBCQUFsQixFQUFrQ0YsVUFQaEM7QUFRakI1RixFQUFBQSxTQUFTLEVBQUUwRixtQkFBVU0sSUFBVixDQUFlSixVQVJUO0FBU2pCakksRUFBQUEsVUFBVSxFQUFFK0gsbUJBQVVNLElBQVYsQ0FBZUosVUFUVjtBQVVqQjNGLEVBQUFBLGNBQWMsRUFBRXlGLG1CQUFVTSxJQUFWLENBQWVKLFVBVmQ7QUFXakIxRixFQUFBQSxhQUFhLEVBQUUrRiwyQkFBZUwsVUFYYjtBQVlqQnpGLEVBQUFBLGVBQWUsRUFBRXVGLG1CQUFVSyxPQUFWLENBQWtCRyxpQ0FBbEIsRUFBeUNOLFVBWnpDO0FBYWpCeEYsRUFBQUEsYUFBYSxFQUFFc0YsbUJBQVVLLE9BQVYsQ0FBa0JHLGlDQUFsQixFQUF5Q04sVUFidkM7QUFjakJ2RixFQUFBQSxjQUFjLEVBQUVxRixtQkFBVUssT0FBVixDQUFrQkkscUNBQWxCLEVBQTZDUCxVQWQ1QztBQWVqQnRGLEVBQUFBLG9CQUFvQixFQUFFb0YsbUJBQVVHLE1BZmY7QUFnQmpCckYsRUFBQUEsWUFBWSxFQUFFa0YsbUJBQVVHLE1BaEJQO0FBaUJqQnBJLEVBQUFBLGVBQWUsRUFBRWlJLG1CQUFVTSxJQUFWLENBQWVKLFVBakJmO0FBa0JqQnJGLEVBQUFBLGNBQWMsRUFBRW1GLG1CQUFVRyxNQWxCVDtBQW1CakJqRyxFQUFBQSxlQUFlLEVBQUU4RixtQkFBVU0sSUFBVixDQUFlSixVQW5CZjtBQXFCakJsRixFQUFBQSxTQUFTLEVBQUVnRixtQkFBVUMsTUFBVixDQUFpQkMsVUFyQlg7QUFzQmpCakYsRUFBQUEsUUFBUSxFQUFFK0UsbUJBQVVDLE1BQVYsQ0FBaUJDLFVBdEJWO0FBdUJqQmhGLEVBQUFBLFFBQVEsRUFBRThFLG1CQUFVQyxNQUFWLENBQWlCQyxVQXZCVjtBQXdCakJuRixFQUFBQSxrQkFBa0IsRUFBRWlGLG1CQUFVQyxNQUFWLENBQWlCQyxVQXhCcEI7QUF5QmpCeEksRUFBQUEsbUJBQW1CLEVBQUVzSSxtQkFBVUMsTUFBVixDQUFpQkMsVUF6QnJCO0FBMEJqQm5HLEVBQUFBLE1BQU0sRUFBRWlHLG1CQUFVQyxNQUFWLENBQWlCQyxVQTFCUjtBQTJCakI5RSxFQUFBQSxPQUFPLEVBQUU0RSxtQkFBVUMsTUFBVixDQUFpQkMsVUEzQlQ7QUE0QmpCL0UsRUFBQUEsUUFBUSxFQUFFNkUsbUJBQVVDLE1BQVYsQ0FBaUJDLFVBNUJWO0FBOEJqQjlJLEVBQUFBLE9BQU8sRUFBRTRJLG1CQUFVVSxJQUFWLENBQWVSLFVBOUJQO0FBK0JqQm5LLEVBQUFBLFlBQVksRUFBRWlLLG1CQUFVVSxJQUFWLENBQWVSLFVBL0JaO0FBZ0NqQi9ILEVBQUFBLHlCQUF5QixFQUFFNkgsbUJBQVVVLElBQVYsQ0FBZVIsVUFoQ3pCO0FBaUNqQnRFLEVBQUFBLGVBQWUsRUFBRW9FLG1CQUFVVSxJQUFWLENBQWVSLFVBakNmO0FBa0NqQnZFLEVBQUFBLDZCQUE2QixFQUFFcUUsbUJBQVVVLElBQVYsQ0FBZVIsVUFsQzdCO0FBbUNqQnhFLEVBQUFBLFNBQVMsRUFBRXNFLG1CQUFVVSxJQUFWLENBQWVSLFVBbkNUO0FBb0NqQnpFLEVBQUFBLG9CQUFvQixFQUFFdUUsbUJBQVVVLElBQVYsQ0FBZVIsVUFwQ3BCO0FBcUNqQnJELEVBQUFBLGFBQWEsRUFBRThELDZCQXJDRTtBQXNDakI5RSxFQUFBQSxhQUFhLEVBQUVtRSxtQkFBVU0sSUFBVixDQUFlSixVQXRDYjtBQXVDakJwRSxFQUFBQSxzQkFBc0IsRUFBRWtFLG1CQUFVVSxJQUFWLENBQWVSLFVBdkN0QjtBQXdDakJuRSxFQUFBQSxjQUFjLEVBQUVpRSxtQkFBVVUsSUFBVixDQUFlUixVQXhDZDtBQXlDakJqRSxFQUFBQSxtQkFBbUIsRUFBRStELG1CQUFVVSxJQUFWLENBQWVSLFVBekNuQjtBQTBDakJsRSxFQUFBQSxrQkFBa0IsRUFBRWdFLG1CQUFVVSxJQUFWLENBQWVSO0FBMUNsQixDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBwYXRoIGZyb20gJ3BhdGgnO1xuXG5pbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCB7VGV4dEJ1ZmZlcn0gZnJvbSAnYXRvbSc7XG5cbmltcG9ydCBHaXRUYWJWaWV3IGZyb20gJy4uL3ZpZXdzL2dpdC10YWItdmlldyc7XG5pbXBvcnQgVXNlclN0b3JlIGZyb20gJy4uL21vZGVscy91c2VyLXN0b3JlJztcbmltcG9ydCBSZWZIb2xkZXIgZnJvbSAnLi4vbW9kZWxzL3JlZi1ob2xkZXInO1xuaW1wb3J0IHtcbiAgQ29tbWl0UHJvcFR5cGUsIEJyYW5jaFByb3BUeXBlLCBGaWxlUGF0Y2hJdGVtUHJvcFR5cGUsIE1lcmdlQ29uZmxpY3RJdGVtUHJvcFR5cGUsIFJlZkhvbGRlclByb3BUeXBlLFxufSBmcm9tICcuLi9wcm9wLXR5cGVzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgR2l0VGFiQ29udHJvbGxlciBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBmb2N1cyA9IHtcbiAgICAuLi5HaXRUYWJWaWV3LmZvY3VzLFxuICB9O1xuXG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgcmVwb3NpdG9yeTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGxvZ2luTW9kZWw6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcblxuICAgIHVzZXJuYW1lOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgZW1haWw6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICBsYXN0Q29tbWl0OiBDb21taXRQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIHJlY2VudENvbW1pdHM6IFByb3BUeXBlcy5hcnJheU9mKENvbW1pdFByb3BUeXBlKS5pc1JlcXVpcmVkLFxuICAgIGlzTWVyZ2luZzogUHJvcFR5cGVzLmJvb2wuaXNSZXF1aXJlZCxcbiAgICBpc1JlYmFzaW5nOiBQcm9wVHlwZXMuYm9vbC5pc1JlcXVpcmVkLFxuICAgIGhhc1VuZG9IaXN0b3J5OiBQcm9wVHlwZXMuYm9vbC5pc1JlcXVpcmVkLFxuICAgIGN1cnJlbnRCcmFuY2g6IEJyYW5jaFByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgdW5zdGFnZWRDaGFuZ2VzOiBQcm9wVHlwZXMuYXJyYXlPZihGaWxlUGF0Y2hJdGVtUHJvcFR5cGUpLmlzUmVxdWlyZWQsXG4gICAgc3RhZ2VkQ2hhbmdlczogUHJvcFR5cGVzLmFycmF5T2YoRmlsZVBhdGNoSXRlbVByb3BUeXBlKS5pc1JlcXVpcmVkLFxuICAgIG1lcmdlQ29uZmxpY3RzOiBQcm9wVHlwZXMuYXJyYXlPZihNZXJnZUNvbmZsaWN0SXRlbVByb3BUeXBlKS5pc1JlcXVpcmVkLFxuICAgIHdvcmtpbmdEaXJlY3RvcnlQYXRoOiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgIG1lcmdlTWVzc2FnZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgICBmZXRjaEluUHJvZ3Jlc3M6IFByb3BUeXBlcy5ib29sLmlzUmVxdWlyZWQsXG4gICAgY3VycmVudFdvcmtEaXI6IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgcmVwb3NpdG9yeURyaWZ0OiBQcm9wVHlwZXMuYm9vbC5pc1JlcXVpcmVkLFxuXG4gICAgd29ya3NwYWNlOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgY29tbWFuZHM6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBncmFtbWFyczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIHJlc29sdXRpb25Qcm9ncmVzczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIG5vdGlmaWNhdGlvbk1hbmFnZXI6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBjb25maWc6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBwcm9qZWN0OiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgdG9vbHRpcHM6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcblxuICAgIGNvbmZpcm06IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgZW5zdXJlR2l0VGFiOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIHJlZnJlc2hSZXNvbHV0aW9uUHJvZ3Jlc3M6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgdW5kb0xhc3REaXNjYXJkOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIGRpc2NhcmRXb3JrRGlyQ2hhbmdlc0ZvclBhdGhzOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIG9wZW5GaWxlczogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBvcGVuSW5pdGlhbGl6ZURpYWxvZzogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBjb250cm9sbGVyUmVmOiBSZWZIb2xkZXJQcm9wVHlwZSxcbiAgICBjb250ZXh0TG9ja2VkOiBQcm9wVHlwZXMuYm9vbC5pc1JlcXVpcmVkLFxuICAgIGNoYW5nZVdvcmtpbmdEaXJlY3Rvcnk6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgc2V0Q29udGV4dExvY2s6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgb25EaWRDaGFuZ2VXb3JrRGlyczogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBnZXRDdXJyZW50V29ya0RpcnM6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gIH07XG5cbiAgY29uc3RydWN0b3IocHJvcHMsIGNvbnRleHQpIHtcbiAgICBzdXBlcihwcm9wcywgY29udGV4dCk7XG5cbiAgICB0aGlzLnN0YWdpbmdPcGVyYXRpb25JblByb2dyZXNzID0gZmFsc2U7XG4gICAgdGhpcy5sYXN0Rm9jdXMgPSBHaXRUYWJWaWV3LmZvY3VzLlNUQUdJTkc7XG5cbiAgICB0aGlzLnJlZlZpZXcgPSBuZXcgUmVmSG9sZGVyKCk7XG4gICAgdGhpcy5yZWZSb290ID0gbmV3IFJlZkhvbGRlcigpO1xuICAgIHRoaXMucmVmU3RhZ2luZ1ZpZXcgPSBuZXcgUmVmSG9sZGVyKCk7XG5cbiAgICB0aGlzLnN0YXRlID0ge1xuICAgICAgc2VsZWN0ZWRDb0F1dGhvcnM6IFtdLFxuICAgICAgZWRpdGluZ0lkZW50aXR5OiBmYWxzZSxcbiAgICB9O1xuXG4gICAgdGhpcy51c2VybmFtZUJ1ZmZlciA9IG5ldyBUZXh0QnVmZmVyKHt0ZXh0OiBwcm9wcy51c2VybmFtZX0pO1xuICAgIHRoaXMudXNlcm5hbWVCdWZmZXIucmV0YWluKCk7XG4gICAgdGhpcy5lbWFpbEJ1ZmZlciA9IG5ldyBUZXh0QnVmZmVyKHt0ZXh0OiBwcm9wcy5lbWFpbH0pO1xuICAgIHRoaXMuZW1haWxCdWZmZXIucmV0YWluKCk7XG5cbiAgICB0aGlzLnVzZXJTdG9yZSA9IG5ldyBVc2VyU3RvcmUoe1xuICAgICAgcmVwb3NpdG9yeTogdGhpcy5wcm9wcy5yZXBvc2l0b3J5LFxuICAgICAgbG9naW46IHRoaXMucHJvcHMubG9naW5Nb2RlbCxcbiAgICAgIGNvbmZpZzogdGhpcy5wcm9wcy5jb25maWcsXG4gICAgfSk7XG4gIH1cblxuICBzdGF0aWMgZ2V0RGVyaXZlZFN0YXRlRnJvbVByb3BzKHByb3BzLCBzdGF0ZSkge1xuICAgIHJldHVybiB7XG4gICAgICBlZGl0aW5nSWRlbnRpdHk6IHN0YXRlLmVkaXRpbmdJZGVudGl0eSB8fFxuICAgICAgICAoIXByb3BzLmZldGNoSW5Qcm9ncmVzcyAmJiBwcm9wcy5yZXBvc2l0b3J5LmlzUHJlc2VudCgpICYmICFwcm9wcy5yZXBvc2l0b3J5RHJpZnQpICYmXG4gICAgICAgIChwcm9wcy51c2VybmFtZSA9PT0gJycgfHwgcHJvcHMuZW1haWwgPT09ICcnKSxcbiAgICB9O1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8R2l0VGFiVmlld1xuICAgICAgICByZWY9e3RoaXMucmVmVmlldy5zZXR0ZXJ9XG4gICAgICAgIHJlZlJvb3Q9e3RoaXMucmVmUm9vdH1cbiAgICAgICAgcmVmU3RhZ2luZ1ZpZXc9e3RoaXMucmVmU3RhZ2luZ1ZpZXd9XG5cbiAgICAgICAgaXNMb2FkaW5nPXt0aGlzLnByb3BzLmZldGNoSW5Qcm9ncmVzc31cbiAgICAgICAgZWRpdGluZ0lkZW50aXR5PXt0aGlzLnN0YXRlLmVkaXRpbmdJZGVudGl0eX1cbiAgICAgICAgcmVwb3NpdG9yeT17dGhpcy5wcm9wcy5yZXBvc2l0b3J5fVxuXG4gICAgICAgIHVzZXJuYW1lQnVmZmVyPXt0aGlzLnVzZXJuYW1lQnVmZmVyfVxuICAgICAgICBlbWFpbEJ1ZmZlcj17dGhpcy5lbWFpbEJ1ZmZlcn1cbiAgICAgICAgbGFzdENvbW1pdD17dGhpcy5wcm9wcy5sYXN0Q29tbWl0fVxuICAgICAgICByZWNlbnRDb21taXRzPXt0aGlzLnByb3BzLnJlY2VudENvbW1pdHN9XG4gICAgICAgIGlzTWVyZ2luZz17dGhpcy5wcm9wcy5pc01lcmdpbmd9XG4gICAgICAgIGlzUmViYXNpbmc9e3RoaXMucHJvcHMuaXNSZWJhc2luZ31cbiAgICAgICAgaGFzVW5kb0hpc3Rvcnk9e3RoaXMucHJvcHMuaGFzVW5kb0hpc3Rvcnl9XG4gICAgICAgIGN1cnJlbnRCcmFuY2g9e3RoaXMucHJvcHMuY3VycmVudEJyYW5jaH1cbiAgICAgICAgdW5zdGFnZWRDaGFuZ2VzPXt0aGlzLnByb3BzLnVuc3RhZ2VkQ2hhbmdlc31cbiAgICAgICAgc3RhZ2VkQ2hhbmdlcz17dGhpcy5wcm9wcy5zdGFnZWRDaGFuZ2VzfVxuICAgICAgICBtZXJnZUNvbmZsaWN0cz17dGhpcy5wcm9wcy5tZXJnZUNvbmZsaWN0c31cbiAgICAgICAgd29ya2luZ0RpcmVjdG9yeVBhdGg9e3RoaXMucHJvcHMud29ya2luZ0RpcmVjdG9yeVBhdGggfHwgdGhpcy5wcm9wcy5jdXJyZW50V29ya0Rpcn1cbiAgICAgICAgbWVyZ2VNZXNzYWdlPXt0aGlzLnByb3BzLm1lcmdlTWVzc2FnZX1cbiAgICAgICAgdXNlclN0b3JlPXt0aGlzLnVzZXJTdG9yZX1cbiAgICAgICAgc2VsZWN0ZWRDb0F1dGhvcnM9e3RoaXMuc3RhdGUuc2VsZWN0ZWRDb0F1dGhvcnN9XG4gICAgICAgIHVwZGF0ZVNlbGVjdGVkQ29BdXRob3JzPXt0aGlzLnVwZGF0ZVNlbGVjdGVkQ29BdXRob3JzfVxuXG4gICAgICAgIHJlc29sdXRpb25Qcm9ncmVzcz17dGhpcy5wcm9wcy5yZXNvbHV0aW9uUHJvZ3Jlc3N9XG4gICAgICAgIHdvcmtzcGFjZT17dGhpcy5wcm9wcy53b3Jrc3BhY2V9XG4gICAgICAgIGNvbW1hbmRzPXt0aGlzLnByb3BzLmNvbW1hbmRzfVxuICAgICAgICBncmFtbWFycz17dGhpcy5wcm9wcy5ncmFtbWFyc31cbiAgICAgICAgdG9vbHRpcHM9e3RoaXMucHJvcHMudG9vbHRpcHN9XG4gICAgICAgIG5vdGlmaWNhdGlvbk1hbmFnZXI9e3RoaXMucHJvcHMubm90aWZpY2F0aW9uTWFuYWdlcn1cbiAgICAgICAgcHJvamVjdD17dGhpcy5wcm9wcy5wcm9qZWN0fVxuICAgICAgICBjb25maXJtPXt0aGlzLnByb3BzLmNvbmZpcm19XG4gICAgICAgIGNvbmZpZz17dGhpcy5wcm9wcy5jb25maWd9XG5cbiAgICAgICAgdG9nZ2xlSWRlbnRpdHlFZGl0b3I9e3RoaXMudG9nZ2xlSWRlbnRpdHlFZGl0b3J9XG4gICAgICAgIGNsb3NlSWRlbnRpdHlFZGl0b3I9e3RoaXMuY2xvc2VJZGVudGl0eUVkaXRvcn1cbiAgICAgICAgc2V0TG9jYWxJZGVudGl0eT17dGhpcy5zZXRMb2NhbElkZW50aXR5fVxuICAgICAgICBzZXRHbG9iYWxJZGVudGl0eT17dGhpcy5zZXRHbG9iYWxJZGVudGl0eX1cbiAgICAgICAgb3BlbkluaXRpYWxpemVEaWFsb2c9e3RoaXMucHJvcHMub3BlbkluaXRpYWxpemVEaWFsb2d9XG4gICAgICAgIG9wZW5GaWxlcz17dGhpcy5wcm9wcy5vcGVuRmlsZXN9XG4gICAgICAgIGRpc2NhcmRXb3JrRGlyQ2hhbmdlc0ZvclBhdGhzPXt0aGlzLnByb3BzLmRpc2NhcmRXb3JrRGlyQ2hhbmdlc0ZvclBhdGhzfVxuICAgICAgICB1bmRvTGFzdERpc2NhcmQ9e3RoaXMucHJvcHMudW5kb0xhc3REaXNjYXJkfVxuICAgICAgICBjb250ZXh0TG9ja2VkPXt0aGlzLnByb3BzLmNvbnRleHRMb2NrZWR9XG4gICAgICAgIGNoYW5nZVdvcmtpbmdEaXJlY3Rvcnk9e3RoaXMucHJvcHMuY2hhbmdlV29ya2luZ0RpcmVjdG9yeX1cbiAgICAgICAgc2V0Q29udGV4dExvY2s9e3RoaXMucHJvcHMuc2V0Q29udGV4dExvY2t9XG4gICAgICAgIGdldEN1cnJlbnRXb3JrRGlycz17dGhpcy5wcm9wcy5nZXRDdXJyZW50V29ya0RpcnN9XG4gICAgICAgIG9uRGlkQ2hhbmdlV29ya0RpcnM9e3RoaXMucHJvcHMub25EaWRDaGFuZ2VXb3JrRGlyc31cblxuICAgICAgICBhdHRlbXB0RmlsZVN0YWdlT3BlcmF0aW9uPXt0aGlzLmF0dGVtcHRGaWxlU3RhZ2VPcGVyYXRpb259XG4gICAgICAgIGF0dGVtcHRTdGFnZUFsbE9wZXJhdGlvbj17dGhpcy5hdHRlbXB0U3RhZ2VBbGxPcGVyYXRpb259XG4gICAgICAgIHByZXBhcmVUb0NvbW1pdD17dGhpcy5wcmVwYXJlVG9Db21taXR9XG4gICAgICAgIGNvbW1pdD17dGhpcy5jb21taXR9XG4gICAgICAgIHVuZG9MYXN0Q29tbWl0PXt0aGlzLnVuZG9MYXN0Q29tbWl0fVxuICAgICAgICBwdXNoPXt0aGlzLnB1c2h9XG4gICAgICAgIHB1bGw9e3RoaXMucHVsbH1cbiAgICAgICAgZmV0Y2g9e3RoaXMuZmV0Y2h9XG4gICAgICAgIGNoZWNrb3V0PXt0aGlzLmNoZWNrb3V0fVxuICAgICAgICBhYm9ydE1lcmdlPXt0aGlzLmFib3J0TWVyZ2V9XG4gICAgICAgIHJlc29sdmVBc091cnM9e3RoaXMucmVzb2x2ZUFzT3Vyc31cbiAgICAgICAgcmVzb2x2ZUFzVGhlaXJzPXt0aGlzLnJlc29sdmVBc1RoZWlyc31cbiAgICAgIC8+XG4gICAgKTtcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIHRoaXMucmVmcmVzaFJlc29sdXRpb25Qcm9ncmVzcyhmYWxzZSwgZmFsc2UpO1xuICAgIHRoaXMucmVmUm9vdC5tYXAocm9vdCA9PiByb290LmFkZEV2ZW50TGlzdGVuZXIoJ2ZvY3VzaW4nLCB0aGlzLnJlbWVtYmVyTGFzdEZvY3VzKSk7XG5cbiAgICBpZiAodGhpcy5wcm9wcy5jb250cm9sbGVyUmVmKSB7XG4gICAgICB0aGlzLnByb3BzLmNvbnRyb2xsZXJSZWYuc2V0dGVyKHRoaXMpO1xuICAgIH1cbiAgfVxuXG4gIGNvbXBvbmVudERpZFVwZGF0ZShwcmV2UHJvcHMpIHtcbiAgICB0aGlzLnVzZXJTdG9yZS5zZXRSZXBvc2l0b3J5KHRoaXMucHJvcHMucmVwb3NpdG9yeSk7XG4gICAgdGhpcy51c2VyU3RvcmUuc2V0TG9naW5Nb2RlbCh0aGlzLnByb3BzLmxvZ2luTW9kZWwpO1xuICAgIHRoaXMucmVmcmVzaFJlc29sdXRpb25Qcm9ncmVzcyhmYWxzZSwgZmFsc2UpO1xuXG4gICAgaWYgKHByZXZQcm9wcy51c2VybmFtZSAhPT0gdGhpcy5wcm9wcy51c2VybmFtZSkge1xuICAgICAgdGhpcy51c2VybmFtZUJ1ZmZlci5zZXRUZXh0VmlhRGlmZih0aGlzLnByb3BzLnVzZXJuYW1lKTtcbiAgICB9XG5cbiAgICBpZiAocHJldlByb3BzLmVtYWlsICE9PSB0aGlzLnByb3BzLmVtYWlsKSB7XG4gICAgICB0aGlzLmVtYWlsQnVmZmVyLnNldFRleHRWaWFEaWZmKHRoaXMucHJvcHMuZW1haWwpO1xuICAgIH1cbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIHRoaXMucmVmUm9vdC5tYXAocm9vdCA9PiByb290LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2ZvY3VzaW4nLCB0aGlzLnJlbWVtYmVyTGFzdEZvY3VzKSk7XG4gIH1cblxuICAvKlxuICAgKiBCZWdpbiAoYnV0IGRvbid0IGF3YWl0KSBhbiBhc3luYyBjb25mbGljdC1jb3VudGluZyB0YXNrIGZvciBlYWNoIG1lcmdlIGNvbmZsaWN0IHBhdGggdGhhdCBoYXMgbm8gY29uZmxpY3RcbiAgICogbWFya2VyIGNvdW50IHlldC4gT21pdCBhbnkgcGF0aCB0aGF0J3MgYWxyZWFkeSBvcGVuIGluIGEgVGV4dEVkaXRvciBvciB0aGF0IGhhcyBhbHJlYWR5IGJlZW4gY291bnRlZC5cbiAgICpcbiAgICogaW5jbHVkZU9wZW4gLSB1cGRhdGUgbWFya2VyIGNvdW50cyBmb3IgZmlsZXMgdGhhdCBhcmUgY3VycmVudGx5IG9wZW4gaW4gVGV4dEVkaXRvcnNcbiAgICogaW5jbHVkZUNvdW50ZWQgLSB1cGRhdGUgbWFya2VyIGNvdW50cyBmb3IgZmlsZXMgdGhhdCBoYXZlIGJlZW4gY291bnRlZCBiZWZvcmVcbiAgICovXG4gIHJlZnJlc2hSZXNvbHV0aW9uUHJvZ3Jlc3MoaW5jbHVkZU9wZW4sIGluY2x1ZGVDb3VudGVkKSB7XG4gICAgaWYgKHRoaXMucHJvcHMuZmV0Y2hJblByb2dyZXNzKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3Qgb3BlblBhdGhzID0gbmV3IFNldChcbiAgICAgIHRoaXMucHJvcHMud29ya3NwYWNlLmdldFRleHRFZGl0b3JzKCkubWFwKGVkaXRvciA9PiBlZGl0b3IuZ2V0UGF0aCgpKSxcbiAgICApO1xuXG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCB0aGlzLnByb3BzLm1lcmdlQ29uZmxpY3RzLmxlbmd0aDsgaSsrKSB7XG4gICAgICBjb25zdCBjb25mbGljdFBhdGggPSBwYXRoLmpvaW4oXG4gICAgICAgIHRoaXMucHJvcHMud29ya2luZ0RpcmVjdG9yeVBhdGgsXG4gICAgICAgIHRoaXMucHJvcHMubWVyZ2VDb25mbGljdHNbaV0uZmlsZVBhdGgsXG4gICAgICApO1xuXG4gICAgICBpZiAoIWluY2x1ZGVPcGVuICYmIG9wZW5QYXRocy5oYXMoY29uZmxpY3RQYXRoKSkge1xuICAgICAgICBjb250aW51ZTtcbiAgICAgIH1cblxuICAgICAgaWYgKCFpbmNsdWRlQ291bnRlZCAmJiB0aGlzLnByb3BzLnJlc29sdXRpb25Qcm9ncmVzcy5nZXRSZW1haW5pbmcoY29uZmxpY3RQYXRoKSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgIGNvbnRpbnVlO1xuICAgICAgfVxuXG4gICAgICB0aGlzLnByb3BzLnJlZnJlc2hSZXNvbHV0aW9uUHJvZ3Jlc3MoY29uZmxpY3RQYXRoKTtcbiAgICB9XG4gIH1cblxuICBhdHRlbXB0U3RhZ2VBbGxPcGVyYXRpb24gPSBzdGFnZVN0YXR1cyA9PiB7XG4gICAgcmV0dXJuIHRoaXMuYXR0ZW1wdEZpbGVTdGFnZU9wZXJhdGlvbihbJy4nXSwgc3RhZ2VTdGF0dXMpO1xuICB9XG5cbiAgYXR0ZW1wdEZpbGVTdGFnZU9wZXJhdGlvbiA9IChmaWxlUGF0aHMsIHN0YWdlU3RhdHVzKSA9PiB7XG4gICAgaWYgKHRoaXMuc3RhZ2luZ09wZXJhdGlvbkluUHJvZ3Jlc3MpIHtcbiAgICAgIHJldHVybiB7XG4gICAgICAgIHN0YWdlT3BlcmF0aW9uUHJvbWlzZTogUHJvbWlzZS5yZXNvbHZlKCksXG4gICAgICAgIHNlbGVjdGlvblVwZGF0ZVByb21pc2U6IFByb21pc2UucmVzb2x2ZSgpLFxuICAgICAgfTtcbiAgICB9XG5cbiAgICB0aGlzLnN0YWdpbmdPcGVyYXRpb25JblByb2dyZXNzID0gdHJ1ZTtcblxuICAgIGNvbnN0IGZpbGVMaXN0VXBkYXRlUHJvbWlzZSA9IHRoaXMucmVmU3RhZ2luZ1ZpZXcubWFwKHZpZXcgPT4ge1xuICAgICAgcmV0dXJuIHZpZXcuZ2V0TmV4dExpc3RVcGRhdGVQcm9taXNlKCk7XG4gICAgfSkuZ2V0T3IoUHJvbWlzZS5yZXNvbHZlKCkpO1xuICAgIGxldCBzdGFnZU9wZXJhdGlvblByb21pc2U7XG4gICAgaWYgKHN0YWdlU3RhdHVzID09PSAnc3RhZ2VkJykge1xuICAgICAgc3RhZ2VPcGVyYXRpb25Qcm9taXNlID0gdGhpcy51bnN0YWdlRmlsZXMoZmlsZVBhdGhzKTtcbiAgICB9IGVsc2Uge1xuICAgICAgc3RhZ2VPcGVyYXRpb25Qcm9taXNlID0gdGhpcy5zdGFnZUZpbGVzKGZpbGVQYXRocyk7XG4gICAgfVxuICAgIGNvbnN0IHNlbGVjdGlvblVwZGF0ZVByb21pc2UgPSBmaWxlTGlzdFVwZGF0ZVByb21pc2UudGhlbigoKSA9PiB7XG4gICAgICB0aGlzLnN0YWdpbmdPcGVyYXRpb25JblByb2dyZXNzID0gZmFsc2U7XG4gICAgfSk7XG5cbiAgICByZXR1cm4ge3N0YWdlT3BlcmF0aW9uUHJvbWlzZSwgc2VsZWN0aW9uVXBkYXRlUHJvbWlzZX07XG4gIH1cblxuICBhc3luYyBzdGFnZUZpbGVzKGZpbGVQYXRocykge1xuICAgIGNvbnN0IHBhdGhzVG9TdGFnZSA9IG5ldyBTZXQoZmlsZVBhdGhzKTtcblxuICAgIGNvbnN0IG1lcmdlTWFya2VycyA9IGF3YWl0IFByb21pc2UuYWxsKFxuICAgICAgZmlsZVBhdGhzLm1hcChhc3luYyBmaWxlUGF0aCA9PiB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgZmlsZVBhdGgsXG4gICAgICAgICAgaGFzTWFya2VyczogYXdhaXQgdGhpcy5wcm9wcy5yZXBvc2l0b3J5LnBhdGhIYXNNZXJnZU1hcmtlcnMoZmlsZVBhdGgpLFxuICAgICAgICB9O1xuICAgICAgfSksXG4gICAgKTtcblxuICAgIGZvciAoY29uc3Qge2ZpbGVQYXRoLCBoYXNNYXJrZXJzfSBvZiBtZXJnZU1hcmtlcnMpIHtcbiAgICAgIGlmIChoYXNNYXJrZXJzKSB7XG4gICAgICAgIGNvbnN0IGNob2ljZSA9IHRoaXMucHJvcHMuY29uZmlybSh7XG4gICAgICAgICAgbWVzc2FnZTogJ0ZpbGUgY29udGFpbnMgbWVyZ2UgbWFya2VyczogJyxcbiAgICAgICAgICBkZXRhaWxlZE1lc3NhZ2U6IGBEbyB5b3Ugc3RpbGwgd2FudCB0byBzdGFnZSB0aGlzIGZpbGU/XFxuJHtmaWxlUGF0aH1gLFxuICAgICAgICAgIGJ1dHRvbnM6IFsnU3RhZ2UnLCAnQ2FuY2VsJ10sXG4gICAgICAgIH0pO1xuICAgICAgICBpZiAoY2hvaWNlICE9PSAwKSB7IHBhdGhzVG9TdGFnZS5kZWxldGUoZmlsZVBhdGgpOyB9XG4gICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMucHJvcHMucmVwb3NpdG9yeS5zdGFnZUZpbGVzKEFycmF5LmZyb20ocGF0aHNUb1N0YWdlKSk7XG4gIH1cblxuICB1bnN0YWdlRmlsZXMoZmlsZVBhdGhzKSB7XG4gICAgcmV0dXJuIHRoaXMucHJvcHMucmVwb3NpdG9yeS51bnN0YWdlRmlsZXMoZmlsZVBhdGhzKTtcbiAgfVxuXG4gIHByZXBhcmVUb0NvbW1pdCA9IGFzeW5jICgpID0+IHtcbiAgICByZXR1cm4gIWF3YWl0IHRoaXMucHJvcHMuZW5zdXJlR2l0VGFiKCk7XG4gIH1cblxuICBjb21taXQgPSAobWVzc2FnZSwgb3B0aW9ucykgPT4ge1xuICAgIHJldHVybiB0aGlzLnByb3BzLnJlcG9zaXRvcnkuY29tbWl0KG1lc3NhZ2UsIG9wdGlvbnMpO1xuICB9XG5cbiAgdXBkYXRlU2VsZWN0ZWRDb0F1dGhvcnMgPSAoc2VsZWN0ZWRDb0F1dGhvcnMsIG5ld0F1dGhvcikgPT4ge1xuICAgIGlmIChuZXdBdXRob3IpIHtcbiAgICAgIHRoaXMudXNlclN0b3JlLmFkZFVzZXJzKFtuZXdBdXRob3JdKTtcbiAgICAgIHNlbGVjdGVkQ29BdXRob3JzID0gc2VsZWN0ZWRDb0F1dGhvcnMuY29uY2F0KFtuZXdBdXRob3JdKTtcbiAgICB9XG4gICAgdGhpcy5zZXRTdGF0ZSh7c2VsZWN0ZWRDb0F1dGhvcnN9KTtcbiAgfVxuXG4gIHVuZG9MYXN0Q29tbWl0ID0gYXN5bmMgKCkgPT4ge1xuICAgIGNvbnN0IHJlcG8gPSB0aGlzLnByb3BzLnJlcG9zaXRvcnk7XG4gICAgY29uc3QgbGFzdENvbW1pdCA9IGF3YWl0IHJlcG8uZ2V0TGFzdENvbW1pdCgpO1xuICAgIGlmIChsYXN0Q29tbWl0LmlzVW5ib3JuUmVmKCkpIHsgcmV0dXJuIG51bGw7IH1cblxuICAgIGF3YWl0IHJlcG8udW5kb0xhc3RDb21taXQoKTtcbiAgICByZXBvLnNldENvbW1pdE1lc3NhZ2UobGFzdENvbW1pdC5nZXRGdWxsTWVzc2FnZSgpKTtcbiAgICB0aGlzLnVwZGF0ZVNlbGVjdGVkQ29BdXRob3JzKGxhc3RDb21taXQuZ2V0Q29BdXRob3JzKCkpO1xuXG4gICAgcmV0dXJuIG51bGw7XG4gIH1cblxuICBhYm9ydE1lcmdlID0gYXN5bmMgKCkgPT4ge1xuICAgIGNvbnN0IGNob2ljZSA9IHRoaXMucHJvcHMuY29uZmlybSh7XG4gICAgICBtZXNzYWdlOiAnQWJvcnQgbWVyZ2UnLFxuICAgICAgZGV0YWlsZWRNZXNzYWdlOiAnQXJlIHlvdSBzdXJlPycsXG4gICAgICBidXR0b25zOiBbJ0Fib3J0JywgJ0NhbmNlbCddLFxuICAgIH0pO1xuICAgIGlmIChjaG9pY2UgIT09IDApIHsgcmV0dXJuOyB9XG5cbiAgICB0cnkge1xuICAgICAgYXdhaXQgdGhpcy5wcm9wcy5yZXBvc2l0b3J5LmFib3J0TWVyZ2UoKTtcbiAgICB9IGNhdGNoIChlKSB7XG4gICAgICBpZiAoZS5jb2RlID09PSAnRURJUlRZU1RBR0VEJykge1xuICAgICAgICB0aGlzLnByb3BzLm5vdGlmaWNhdGlvbk1hbmFnZXIuYWRkRXJyb3IoXG4gICAgICAgICAgYENhbm5vdCBhYm9ydCBiZWNhdXNlICR7ZS5wYXRofSBpcyBib3RoIGRpcnR5IGFuZCBzdGFnZWQuYCxcbiAgICAgICAgICB7ZGlzbWlzc2FibGU6IHRydWV9LFxuICAgICAgICApO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhyb3cgZTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICByZXNvbHZlQXNPdXJzID0gYXN5bmMgcGF0aHMgPT4ge1xuICAgIGlmICh0aGlzLnByb3BzLmZldGNoSW5Qcm9ncmVzcykge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGNvbnN0IHNpZGUgPSB0aGlzLnByb3BzLmlzUmViYXNpbmcgPyAndGhlaXJzJyA6ICdvdXJzJztcbiAgICBhd2FpdCB0aGlzLnByb3BzLnJlcG9zaXRvcnkuY2hlY2tvdXRTaWRlKHNpZGUsIHBhdGhzKTtcbiAgICB0aGlzLnJlZnJlc2hSZXNvbHV0aW9uUHJvZ3Jlc3MoZmFsc2UsIHRydWUpO1xuICB9XG5cbiAgcmVzb2x2ZUFzVGhlaXJzID0gYXN5bmMgcGF0aHMgPT4ge1xuICAgIGlmICh0aGlzLnByb3BzLmZldGNoSW5Qcm9ncmVzcykge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGNvbnN0IHNpZGUgPSB0aGlzLnByb3BzLmlzUmViYXNpbmcgPyAnb3VycycgOiAndGhlaXJzJztcbiAgICBhd2FpdCB0aGlzLnByb3BzLnJlcG9zaXRvcnkuY2hlY2tvdXRTaWRlKHNpZGUsIHBhdGhzKTtcbiAgICB0aGlzLnJlZnJlc2hSZXNvbHV0aW9uUHJvZ3Jlc3MoZmFsc2UsIHRydWUpO1xuICB9XG5cbiAgY2hlY2tvdXQgPSAoYnJhbmNoTmFtZSwgb3B0aW9ucykgPT4ge1xuICAgIHJldHVybiB0aGlzLnByb3BzLnJlcG9zaXRvcnkuY2hlY2tvdXQoYnJhbmNoTmFtZSwgb3B0aW9ucyk7XG4gIH1cblxuICByZW1lbWJlckxhc3RGb2N1cyA9IGV2ZW50ID0+IHtcbiAgICB0aGlzLmxhc3RGb2N1cyA9IHRoaXMucmVmVmlldy5tYXAodmlldyA9PiB2aWV3LmdldEZvY3VzKGV2ZW50LnRhcmdldCkpLmdldE9yKG51bGwpIHx8IEdpdFRhYlZpZXcuZm9jdXMuU1RBR0lORztcbiAgfVxuXG4gIHRvZ2dsZUlkZW50aXR5RWRpdG9yID0gKCkgPT4gdGhpcy5zZXRTdGF0ZShiZWZvcmUgPT4gKHtlZGl0aW5nSWRlbnRpdHk6ICFiZWZvcmUuZWRpdGluZ0lkZW50aXR5fSkpXG5cbiAgY2xvc2VJZGVudGl0eUVkaXRvciA9ICgpID0+IHRoaXMuc2V0U3RhdGUoe2VkaXRpbmdJZGVudGl0eTogZmFsc2V9KVxuXG4gIHNldExvY2FsSWRlbnRpdHkgPSAoKSA9PiB0aGlzLnNldElkZW50aXR5KHt9KTtcblxuICBzZXRHbG9iYWxJZGVudGl0eSA9ICgpID0+IHRoaXMuc2V0SWRlbnRpdHkoe2dsb2JhbDogdHJ1ZX0pO1xuXG4gIGFzeW5jIHNldElkZW50aXR5KG9wdGlvbnMpIHtcbiAgICBjb25zdCBuZXdVc2VybmFtZSA9IHRoaXMudXNlcm5hbWVCdWZmZXIuZ2V0VGV4dCgpO1xuICAgIGNvbnN0IG5ld0VtYWlsID0gdGhpcy5lbWFpbEJ1ZmZlci5nZXRUZXh0KCk7XG5cbiAgICBpZiAobmV3VXNlcm5hbWUubGVuZ3RoID4gMCB8fCBvcHRpb25zLmdsb2JhbCkge1xuICAgICAgYXdhaXQgdGhpcy5wcm9wcy5yZXBvc2l0b3J5LnNldENvbmZpZygndXNlci5uYW1lJywgbmV3VXNlcm5hbWUsIG9wdGlvbnMpO1xuICAgIH0gZWxzZSB7XG4gICAgICBhd2FpdCB0aGlzLnByb3BzLnJlcG9zaXRvcnkudW5zZXRDb25maWcoJ3VzZXIubmFtZScpO1xuICAgIH1cblxuICAgIGlmIChuZXdFbWFpbC5sZW5ndGggPiAwIHx8IG9wdGlvbnMuZ2xvYmFsKSB7XG4gICAgICBhd2FpdCB0aGlzLnByb3BzLnJlcG9zaXRvcnkuc2V0Q29uZmlnKCd1c2VyLmVtYWlsJywgbmV3RW1haWwsIG9wdGlvbnMpO1xuICAgIH0gZWxzZSB7XG4gICAgICBhd2FpdCB0aGlzLnByb3BzLnJlcG9zaXRvcnkudW5zZXRDb25maWcoJ3VzZXIuZW1haWwnKTtcbiAgICB9XG4gICAgdGhpcy5jbG9zZUlkZW50aXR5RWRpdG9yKCk7XG4gIH1cblxuICByZXN0b3JlRm9jdXMoKSB7XG4gICAgdGhpcy5yZWZWaWV3Lm1hcCh2aWV3ID0+IHZpZXcuc2V0Rm9jdXModGhpcy5sYXN0Rm9jdXMpKTtcbiAgfVxuXG4gIGhhc0ZvY3VzKCkge1xuICAgIHJldHVybiB0aGlzLnJlZlJvb3QubWFwKHJvb3QgPT4gcm9vdC5jb250YWlucyhkb2N1bWVudC5hY3RpdmVFbGVtZW50KSkuZ2V0T3IoZmFsc2UpO1xuICB9XG5cbiAgd2FzQWN0aXZhdGVkKGlzU3RpbGxBY3RpdmUpIHtcbiAgICBwcm9jZXNzLm5leHRUaWNrKCgpID0+IHtcbiAgICAgIGlzU3RpbGxBY3RpdmUoKSAmJiB0aGlzLnJlc3RvcmVGb2N1cygpO1xuICAgIH0pO1xuICB9XG5cbiAgZm9jdXNBbmRTZWxlY3RTdGFnaW5nSXRlbShmaWxlUGF0aCwgc3RhZ2luZ1N0YXR1cykge1xuICAgIHJldHVybiB0aGlzLnJlZlZpZXcubWFwKHZpZXcgPT4gdmlldy5mb2N1c0FuZFNlbGVjdFN0YWdpbmdJdGVtKGZpbGVQYXRoLCBzdGFnaW5nU3RhdHVzKSkuZ2V0T3IobnVsbCk7XG4gIH1cblxuICBmb2N1c0FuZFNlbGVjdENvbW1pdFByZXZpZXdCdXR0b24oKSB7XG4gICAgcmV0dXJuIHRoaXMucmVmVmlldy5tYXAodmlldyA9PiB2aWV3LmZvY3VzQW5kU2VsZWN0Q29tbWl0UHJldmlld0J1dHRvbigpKTtcbiAgfVxuXG4gIGZvY3VzQW5kU2VsZWN0UmVjZW50Q29tbWl0KCkge1xuICAgIHJldHVybiB0aGlzLnJlZlZpZXcubWFwKHZpZXcgPT4gdmlldy5mb2N1c0FuZFNlbGVjdFJlY2VudENvbW1pdCgpKTtcbiAgfVxuXG4gIHF1aWV0bHlTZWxlY3RJdGVtKGZpbGVQYXRoLCBzdGFnaW5nU3RhdHVzKSB7XG4gICAgcmV0dXJuIHRoaXMucmVmVmlldy5tYXAodmlldyA9PiB2aWV3LnF1aWV0bHlTZWxlY3RJdGVtKGZpbGVQYXRoLCBzdGFnaW5nU3RhdHVzKSkuZ2V0T3IobnVsbCk7XG4gIH1cbn1cbiJdfQ==