"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _author = require("../models/author");

var _gitTabHeaderView = _interopRequireDefault(require("../views/git-tab-header-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitTabHeaderController extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "handleLockToggle", async () => {
      if (this.state.changingLock !== null) {
        return;
      }

      const nextLock = !this.props.contextLocked;

      try {
        this.setState({
          changingLock: nextLock
        });
        await this.props.setContextLock(this.getWorkDir(), nextLock);
      } finally {
        await new Promise(resolve => this.setState({
          changingLock: null
        }, resolve));
      }
    });

    _defineProperty(this, "handleWorkDirSelect", async e => {
      if (this.state.changingWorkDir !== null) {
        return;
      }

      const nextWorkDir = e.target.value;

      try {
        this.setState({
          changingWorkDir: nextWorkDir
        });
        await this.props.changeWorkingDirectory(nextWorkDir);
      } finally {
        await new Promise(resolve => this.setState({
          changingWorkDir: null
        }, resolve));
      }
    });

    _defineProperty(this, "resetWorkDirs", () => {
      this.setState(() => ({
        currentWorkDirs: []
      }));
    });

    _defineProperty(this, "updateCommitter", async () => {
      const committer = (await this.props.getCommitter()) || _author.nullAuthor;

      if (this._isMounted) {
        this.setState({
          committer
        });
      }
    });

    this._isMounted = false;
    this.state = {
      currentWorkDirs: [],
      committer: _author.nullAuthor,
      changingLock: null,
      changingWorkDir: null
    };
    this.disposable = new _atom.CompositeDisposable();
  }

  static getDerivedStateFromProps(props) {
    return {
      currentWorkDirs: props.getCurrentWorkDirs()
    };
  }

  componentDidMount() {
    this._isMounted = true;
    this.disposable.add(this.props.onDidChangeWorkDirs(this.resetWorkDirs));
    this.disposable.add(this.props.onDidUpdateRepo(this.updateCommitter));
    this.updateCommitter();
  }

  componentDidUpdate(prevProps) {
    if (prevProps.onDidChangeWorkDirs !== this.props.onDidChangeWorkDirs || prevProps.onDidUpdateRepo !== this.props.onDidUpdateRepo) {
      this.disposable.dispose();
      this.disposable = new _atom.CompositeDisposable();
      this.disposable.add(this.props.onDidChangeWorkDirs(this.resetWorkDirs));
      this.disposable.add(this.props.onDidUpdateRepo(this.updateCommitter));
    }

    if (prevProps.getCommitter !== this.props.getCommitter) {
      this.updateCommitter();
    }
  }

  render() {
    return _react.default.createElement(_gitTabHeaderView.default, {
      committer: this.state.committer // Workspace
      ,
      workdir: this.getWorkDir(),
      workdirs: this.state.currentWorkDirs,
      contextLocked: this.getLocked(),
      changingWorkDir: this.state.changingWorkDir !== null,
      changingLock: this.state.changingLock !== null // Event Handlers
      ,
      handleAvatarClick: this.props.onDidClickAvatar,
      handleWorkDirSelect: this.handleWorkDirSelect,
      handleLockToggle: this.handleLockToggle
    });
  }

  getWorkDir() {
    return this.state.changingWorkDir !== null ? this.state.changingWorkDir : this.props.currentWorkDir;
  }

  getLocked() {
    return this.state.changingLock !== null ? this.state.changingLock : this.props.contextLocked;
  }

  componentWillUnmount() {
    this._isMounted = false;
    this.disposable.dispose();
  }

}

exports.default = GitTabHeaderController;

_defineProperty(GitTabHeaderController, "propTypes", {
  getCommitter: _propTypes.default.func.isRequired,
  // Workspace
  currentWorkDir: _propTypes.default.string,
  getCurrentWorkDirs: _propTypes.default.func.isRequired,
  changeWorkingDirectory: _propTypes.default.func.isRequired,
  contextLocked: _propTypes.default.bool.isRequired,
  setContextLock: _propTypes.default.func.isRequired,
  // Event Handlers
  onDidClickAvatar: _propTypes.default.func.isRequired,
  onDidChangeWorkDirs: _propTypes.default.func.isRequired,
  onDidUpdateRepo: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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