"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _githubTabView = _interopRequireDefault(require("../views/github-tab-view"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabController extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "handlePushBranch", (currentBranch, targetRemote) => {
      return this.props.repository.push(currentBranch.getName(), {
        remote: targetRemote,
        setUpstream: true
      });
    });

    _defineProperty(this, "handleRemoteSelect", (e, remote) => {
      e.preventDefault();
      return this.props.repository.setConfig('atomGithub.currentRemote', remote.getName());
    });

    _defineProperty(this, "openBoundPublishDialog", () => this.props.openPublishDialog(this.props.repository));

    _defineProperty(this, "handleLogin", token => {
      (0, _reporterProxy.incrementCounter)('github-login');
      this.props.loginModel.setToken(this.currentEndpoint().getLoginAccount(), token);
    });

    _defineProperty(this, "handleLogout", () => {
      (0, _reporterProxy.incrementCounter)('github-logout');
      this.props.loginModel.removeToken(this.currentEndpoint().getLoginAccount());
    });

    _defineProperty(this, "handleTokenRetry", () => this.props.loginModel.didUpdate());
  }

  render() {
    return _react.default.createElement(_githubTabView.default // Connection
    , {
      endpoint: this.currentEndpoint(),
      token: this.props.token,
      workspace: this.props.workspace,
      refresher: this.props.refresher,
      rootHolder: this.props.rootHolder,
      workingDirectory: this.props.workingDirectory || this.props.currentWorkDir,
      contextLocked: this.props.contextLocked,
      repository: this.props.repository,
      branches: this.props.branches,
      currentBranch: this.props.currentBranch,
      remotes: this.props.githubRemotes,
      currentRemote: this.props.currentRemote,
      manyRemotesAvailable: this.props.manyRemotesAvailable,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      isLoading: this.props.isLoading,
      handleLogin: this.handleLogin,
      handleLogout: this.handleLogout,
      handleTokenRetry: this.handleTokenRetry,
      handlePushBranch: this.handlePushBranch,
      handleRemoteSelect: this.handleRemoteSelect,
      changeWorkingDirectory: this.props.changeWorkingDirectory,
      setContextLock: this.props.setContextLock,
      getCurrentWorkDirs: this.props.getCurrentWorkDirs,
      onDidChangeWorkDirs: this.props.onDidChangeWorkDirs,
      openCreateDialog: this.props.openCreateDialog,
      openBoundPublishDialog: this.openBoundPublishDialog,
      openCloneDialog: this.props.openCloneDialog,
      openGitTab: this.props.openGitTab
    });
  }

  currentEndpoint() {
    return this.props.currentRemote.getEndpointOrDotcom();
  }

}

exports.default = GitHubTabController;

_defineProperty(GitHubTabController, "propTypes", {
  workspace: _propTypes.default.object.isRequired,
  refresher: _propTypes2.RefresherPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  token: _propTypes2.TokenPropType,
  rootHolder: _propTypes2.RefHolderPropType.isRequired,
  workingDirectory: _propTypes.default.string,
  repository: _propTypes.default.object.isRequired,
  allRemotes: _propTypes2.RemoteSetPropType.isRequired,
  githubRemotes: _propTypes2.RemoteSetPropType.isRequired,
  currentRemote: _propTypes2.RemotePropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  aheadCount: _propTypes.default.number.isRequired,
  manyRemotesAvailable: _propTypes.default.bool.isRequired,
  pushInProgress: _propTypes.default.bool.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  currentWorkDir: _propTypes.default.string,
  changeWorkingDirectory: _propTypes.default.func.isRequired,
  setContextLock: _propTypes.default.func.isRequired,
  contextLocked: _propTypes.default.bool.isRequired,
  onDidChangeWorkDirs: _propTypes.default.func.isRequired,
  getCurrentWorkDirs: _propTypes.default.func.isRequired,
  openCreateDialog: _propTypes.default.func.isRequired,
  openPublishDialog: _propTypes.default.func.isRequired,
  openCloneDialog: _propTypes.default.func.isRequired,
  openGitTab: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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