"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _githubTabHeaderView = _interopRequireDefault(require("../views/github-tab-header-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GithubTabHeaderController extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "resetWorkDirs", () => {
      this.setState(() => ({
        currentWorkDirs: []
      }));
    });

    _defineProperty(this, "handleLockToggle", async () => {
      if (this.state.changingLock !== null) {
        return;
      }

      const nextLock = !this.props.contextLocked;

      try {
        this.setState({
          changingLock: nextLock
        });
        await this.props.setContextLock(this.state.changingWorkDir || this.props.currentWorkDir, nextLock);
      } finally {
        await new Promise(resolve => this.setState({
          changingLock: null
        }, resolve));
      }
    });

    _defineProperty(this, "handleWorkDirChange", async e => {
      if (this.state.changingWorkDir !== null) {
        return;
      }

      const nextWorkDir = e.target.value;

      try {
        this.setState({
          changingWorkDir: nextWorkDir
        });
        await this.props.changeWorkingDirectory(nextWorkDir);
      } finally {
        await new Promise(resolve => this.setState({
          changingWorkDir: null
        }, resolve));
      }
    });

    this.state = {
      currentWorkDirs: [],
      changingLock: null,
      changingWorkDir: null
    };
  }

  static getDerivedStateFromProps(props) {
    return {
      currentWorkDirs: props.getCurrentWorkDirs()
    };
  }

  componentDidMount() {
    this.disposable = this.props.onDidChangeWorkDirs(this.resetWorkDirs);
  }

  componentDidUpdate(prevProps) {
    if (prevProps.onDidChangeWorkDirs !== this.props.onDidChangeWorkDirs) {
      if (this.disposable) {
        this.disposable.dispose();
      }

      this.disposable = this.props.onDidChangeWorkDirs(this.resetWorkDirs);
    }
  }

  render() {
    return _react.default.createElement(_githubTabHeaderView.default, {
      user: this.props.user // Workspace
      ,
      workdir: this.getWorkDir(),
      workdirs: this.state.currentWorkDirs,
      contextLocked: this.getContextLocked(),
      changingWorkDir: this.state.changingWorkDir !== null,
      changingLock: this.state.changingLock !== null,
      handleWorkDirChange: this.handleWorkDirChange,
      handleLockToggle: this.handleLockToggle
    });
  }

  getWorkDir() {
    return this.state.changingWorkDir !== null ? this.state.changingWorkDir : this.props.currentWorkDir;
  }

  getContextLocked() {
    return this.state.changingLock !== null ? this.state.changingLock : this.props.contextLocked;
  }

  componentWillUnmount() {
    this.disposable.dispose();
  }

}

exports.default = GithubTabHeaderController;

_defineProperty(GithubTabHeaderController, "propTypes", {
  user: _propTypes2.AuthorPropType.isRequired,
  // Workspace
  currentWorkDir: _propTypes.default.string,
  contextLocked: _propTypes.default.bool.isRequired,
  changeWorkingDirectory: _propTypes.default.func.isRequired,
  setContextLock: _propTypes.default.func.isRequired,
  getCurrentWorkDirs: _propTypes.default.func.isRequired,
  // Event Handlers
  onDidChangeWorkDirs: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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