"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareIssueishListController = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _issueishListView = _interopRequireDefault(require("../views/issueish-list-view"));

var _issueish = _interopRequireDefault(require("../models/issueish"));

var _electron = require("electron");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const {
  Menu,
  MenuItem
} = _electron.remote;

const StatePropType = _propTypes.default.oneOf(['EXPECTED', 'PENDING', 'SUCCESS', 'ERROR', 'FAILURE']);

class BareIssueishListController extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openOnGitHub", async url => {
      await _electron.shell.openExternal(url);
      (0, _reporterProxy.addEvent)('open-issueish-in-browser', {
        package: 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "showActionsMenu",
    /* istanbul ignore next */
    issueish => {
      const menu = new Menu();
      menu.append(new MenuItem({
        label: 'See reviews',
        click: () => this.props.onOpenReviews(issueish)
      }));
      menu.append(new MenuItem({
        label: 'Open on GitHub',
        click: () => this.openOnGitHub(issueish.getGitHubURL())
      }));
      menu.popup(_electron.remote.getCurrentWindow());
    });

    this.state = {};
  }

  static getDerivedStateFromProps(props, state) {
    if (props.results === null) {
      return {
        lastResults: null,
        issueishes: []
      };
    }

    if (props.results !== state.lastResults) {
      return {
        lastResults: props.results,
        issueishes: props.results.map(node => new _issueish.default(node)).filter(props.resultFilter)
      };
    }

    return null;
  }

  render() {
    return _react.default.createElement(_issueishListView.default, {
      title: this.props.title,
      isLoading: this.props.isLoading,
      total: this.props.total,
      issueishes: this.state.issueishes,
      error: this.props.error,
      needReviewsButton: this.props.needReviewsButton,
      onIssueishClick: this.props.onOpenIssueish,
      onMoreClick: this.props.onOpenMore,
      openReviews: this.props.onOpenReviews,
      openOnGitHub: this.openOnGitHub,
      showActionsMenu: this.showActionsMenu,
      emptyComponent: this.props.emptyComponent
    });
  }

}

exports.BareIssueishListController = BareIssueishListController;

_defineProperty(BareIssueishListController, "propTypes", {
  results: _propTypes.default.arrayOf(_propTypes.default.shape({
    number: _propTypes.default.number.isRequired,
    title: _propTypes.default.string.isRequired,
    url: _propTypes.default.string.isRequired,
    author: _propTypes.default.shape({
      login: _propTypes.default.string.isRequired,
      avatarUrl: _propTypes.default.string.isRequired
    }),
    createdAt: _propTypes.default.string.isRequired,
    headRefName: _propTypes.default.string.isRequired,
    repository: _propTypes.default.shape({
      id: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired,
      owner: _propTypes.default.shape({
        login: _propTypes.default.string.isRequired
      }).isRequired
    }).isRequired,
    commits: _propTypes.default.shape({
      nodes: _propTypes.default.arrayOf(_propTypes.default.shape({
        commit: _propTypes.default.shape({
          status: _propTypes.default.shape({
            contexts: _propTypes.default.arrayOf(_propTypes.default.shape({
              state: StatePropType.isRequired
            }).isRequired).isRequired
          })
        })
      }))
    })
  })),
  total: _propTypes.default.number.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  title: _propTypes.default.string.isRequired,
  error: _propTypes.default.object,
  resultFilter: _propTypes.default.func,
  onOpenIssueish: _propTypes.default.func.isRequired,
  onOpenReviews: _propTypes.default.func.isRequired,
  onOpenMore: _propTypes.default.func,
  emptyComponent: _propTypes.default.func,
  endpoint: _propTypes2.EndpointPropType,
  needReviewsButton: _propTypes.default.bool
});

_defineProperty(BareIssueishListController, "defaultProps", {
  results: [],
  total: 0,
  resultFilter: () => true
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishListController, {
  results: function () {
    const node = require("./__generated__/issueishListController_results.graphql");

    if (node.hash && node.hash !== "af31b5400d8cce5026fc1bb3fc42dc91") {
      console.error("The definition of 'issueishListController_results' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishListController_results.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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