"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _propTypes2 = require("../prop-types");

var _search = _interopRequireDefault(require("../models/search"));

var _issueishSearchContainer = _interopRequireDefault(require("../containers/issueish-search-container"));

var _currentPullRequestContainer = _interopRequireDefault(require("../containers/current-pull-request-container"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishSearchesController extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {});

    _defineProperty(this, "onOpenReviews", issueish => {
      const uri = _reviewsItem.default.buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.remote.getOwner(),
        repo: this.props.remote.getRepo(),
        number: issueish.getNumber(),
        workdir: this.props.workingDirectory
      });

      return this.props.workspace.open(uri).then(() => {
        (0, _reporterProxy.addEvent)('open-reviews-tab', {
          package: 'github',
          from: this.constructor.name
        });
      });
    });

    _defineProperty(this, "onOpenIssueish", issueish => {
      return this.props.workspace.open(_issueishDetailItem.default.buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.remote.getOwner(),
        repo: this.props.remote.getRepo(),
        number: issueish.getNumber(),
        workdir: this.props.workingDirectory
      }), {
        pending: true,
        searchAllPanes: true
      }).then(() => {
        (0, _reporterProxy.addEvent)('open-issueish-in-pane', {
          package: 'github',
          from: 'issueish-list'
        });
      });
    });

    _defineProperty(this, "onOpenSearch", async search => {
      const searchURL = search.getWebURL(this.props.remote);
      await _electron.shell.openExternal(searchURL);
    });
  }

  static getDerivedStateFromProps(props) {
    return {
      searches: [_search.default.inRemote(props.remote, 'Open pull requests', 'type:pr state:open')]
    };
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-IssueishSearch"
    }, _react.default.createElement(_currentPullRequestContainer.default, {
      repository: this.props.repository,
      token: this.props.token,
      endpoint: this.props.endpoint,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      workspace: this.props.workspace,
      workingDirectory: this.props.workingDirectory,
      onOpenIssueish: this.onOpenIssueish,
      onOpenReviews: this.onOpenReviews,
      onCreatePr: this.props.onCreatePr
    }), this.state.searches.map(search => _react.default.createElement(_issueishSearchContainer.default, {
      key: search.getName(),
      token: this.props.token,
      endpoint: this.props.endpoint,
      search: search,
      onOpenIssueish: this.onOpenIssueish,
      onOpenSearch: this.onOpenSearch,
      onOpenReviews: this.onOpenReviews
    })));
  }

}

exports.default = IssueishSearchesController;

_defineProperty(IssueishSearchesController, "propTypes", {
  // Relay payload
  repository: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    defaultBranchRef: _propTypes.default.shape({
      prefix: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired
    })
  }),
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes.default.string.isRequired,
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  // Repository model attributes
  workingDirectory: _propTypes.default.string,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes.default.number,
  pushInProgress: _propTypes.default.bool.isRequired,
  // Actions
  onCreatePr: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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