"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reporterProxy = require("../reporter-proxy");

var _eventKit = require("event-kit");

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _uriPattern = _interopRequireDefault(require("../atom/uri-pattern"));

var _recentCommitsView = _interopRequireDefault(require("../views/recent-commits-view"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RecentCommitsController extends _react.default.Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "updateSelectedCommit", () => {
      const activeItem = this.props.workspace.getActivePaneItem();
      const pattern = new _uriPattern.default(decodeURIComponent(_commitDetailItem.default.buildURI(this.props.repository.getWorkingDirectoryPath(), '{sha}')));

      if (activeItem && activeItem.getURI) {
        const match = pattern.matches(activeItem.getURI());
        const {
          sha
        } = match.getParams();

        if (match.ok() && sha && sha !== this.state.selectedCommitSha) {
          return new Promise(resolve => this.setState({
            selectedCommitSha: sha
          }, resolve));
        }
      }

      return Promise.resolve();
    });

    _defineProperty(this, "openCommit", async ({
      sha,
      preserveFocus
    }) => {
      const workdir = this.props.repository.getWorkingDirectoryPath();

      const uri = _commitDetailItem.default.buildURI(workdir, sha);

      const item = await this.props.workspace.open(uri, {
        pending: true
      });

      if (preserveFocus) {
        item.preventFocus();
        this.setFocus(this.constructor.focus.RECENT_COMMIT);
      }

      (0, _reporterProxy.addEvent)('open-commit-in-pane', {
        package: 'github',
        from: this.constructor.name
      });
    });

    _defineProperty(this, "selectNextCommit", () => this.setSelectedCommitIndex(this.getSelectedCommitIndex() + 1));

    _defineProperty(this, "selectPreviousCommit", () => this.setSelectedCommitIndex(Math.max(this.getSelectedCommitIndex() - 1, 0)));

    this.subscriptions = new _eventKit.CompositeDisposable(this.props.workspace.onDidChangeActivePaneItem(this.updateSelectedCommit));
    this.refView = new _refHolder.default();
    this.state = {
      selectedCommitSha: ''
    };
  }

  render() {
    return _react.default.createElement(_recentCommitsView.default, {
      ref: this.refView.setter,
      commits: this.props.commits,
      isLoading: this.props.isLoading,
      undoLastCommit: this.props.undoLastCommit,
      openCommit: this.openCommit,
      selectNextCommit: this.selectNextCommit,
      selectPreviousCommit: this.selectPreviousCommit,
      selectedCommitSha: this.state.selectedCommitSha,
      commands: this.props.commands,
      clipboard: atom.clipboard
    });
  }

  getSelectedCommitIndex() {
    return this.props.commits.findIndex(commit => commit.getSha() === this.state.selectedCommitSha);
  }

  setSelectedCommitIndex(ind) {
    const commit = this.props.commits[ind];

    if (commit) {
      return new Promise(resolve => this.setState({
        selectedCommitSha: commit.getSha()
      }, resolve));
    } else {
      return Promise.resolve();
    }
  }

  getFocus(element) {
    return this.refView.map(view => view.getFocus(element)).getOr(null);
  }

  setFocus(focus) {
    return this.refView.map(view => {
      const wasFocused = view.setFocus(focus);

      if (wasFocused && this.getSelectedCommitIndex() === -1) {
        this.setSelectedCommitIndex(0);
      }

      return wasFocused;
    }).getOr(false);
  }

  advanceFocusFrom(focus) {
    return this.refView.map(view => view.advanceFocusFrom(focus)).getOr(Promise.resolve(null));
  }

  retreatFocusFrom(focus) {
    return this.refView.map(view => view.retreatFocusFrom(focus)).getOr(Promise.resolve(null));
  }

}

exports.default = RecentCommitsController;

_defineProperty(RecentCommitsController, "propTypes", {
  commits: _propTypes.default.arrayOf(_propTypes.default.object).isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  undoLastCommit: _propTypes.default.func.isRequired,
  workspace: _propTypes.default.object.isRequired,
  repository: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired
});

_defineProperty(RecentCommitsController, "focus", _recentCommitsView.default.focus);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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