"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _reporterProxy = require("../reporter-proxy");

var _propTypes2 = require("../prop-types");

var _issueishSearchesController = _interopRequireDefault(require("./issueish-searches-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteController extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "onCreatePr", async () => {
      const currentBranch = this.props.branches.getHeadBranch();
      const upstream = currentBranch.getUpstream();

      if (!upstream.isPresent() || this.props.aheadCount > 0) {
        await this.props.onPushBranch();
      }

      let createPrUrl = 'https://github.com/';
      createPrUrl += this.props.remote.getOwner() + '/' + this.props.remote.getRepo();
      createPrUrl += '/compare/' + encodeURIComponent(currentBranch.getName());
      createPrUrl += '?expand=1';
      await _electron.shell.openExternal(createPrUrl);
      (0, _reporterProxy.incrementCounter)('create-pull-request');
    });
  }

  render() {
    return _react.default.createElement(_issueishSearchesController.default, {
      endpoint: this.props.endpoint,
      token: this.props.token,
      workingDirectory: this.props.workingDirectory,
      repository: this.props.repository,
      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.onCreatePr
    });
  }

}

exports.default = RemoteController;

_defineProperty(RemoteController, "propTypes", {
  // Relay payload
  repository: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    defaultBranchRef: _propTypes.default.shape({
      prefix: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired
    })
  }),
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes2.TokenPropType.isRequired,
  // Repository derived attributes
  workingDirectory: _propTypes.default.string,
  workspace: _propTypes.default.object.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes.default.number,
  pushInProgress: _propTypes.default.bool.isRequired,
  // Actions
  onPushBranch: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJlbW90ZS1jb250cm9sbGVyLmpzIl0sIm5hbWVzIjpbIlJlbW90ZUNvbnRyb2xsZXIiLCJSZWFjdCIsIkNvbXBvbmVudCIsImN1cnJlbnRCcmFuY2giLCJwcm9wcyIsImJyYW5jaGVzIiwiZ2V0SGVhZEJyYW5jaCIsInVwc3RyZWFtIiwiZ2V0VXBzdHJlYW0iLCJpc1ByZXNlbnQiLCJhaGVhZENvdW50Iiwib25QdXNoQnJhbmNoIiwiY3JlYXRlUHJVcmwiLCJyZW1vdGUiLCJnZXRPd25lciIsImdldFJlcG8iLCJlbmNvZGVVUklDb21wb25lbnQiLCJnZXROYW1lIiwic2hlbGwiLCJvcGVuRXh0ZXJuYWwiLCJyZW5kZXIiLCJlbmRwb2ludCIsInRva2VuIiwid29ya2luZ0RpcmVjdG9yeSIsInJlcG9zaXRvcnkiLCJ3b3Jrc3BhY2UiLCJyZW1vdGVzIiwicHVzaEluUHJvZ3Jlc3MiLCJvbkNyZWF0ZVByIiwiUHJvcFR5cGVzIiwic2hhcGUiLCJpZCIsInN0cmluZyIsImlzUmVxdWlyZWQiLCJkZWZhdWx0QnJhbmNoUmVmIiwicHJlZml4IiwibmFtZSIsIkVuZHBvaW50UHJvcFR5cGUiLCJUb2tlblByb3BUeXBlIiwib2JqZWN0IiwiUmVtb3RlUHJvcFR5cGUiLCJSZW1vdGVTZXRQcm9wVHlwZSIsIkJyYW5jaFNldFByb3BUeXBlIiwibnVtYmVyIiwiYm9vbCIsImZ1bmMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFDQTs7QUFFQTs7QUFDQTs7QUFDQTs7Ozs7O0FBRWUsTUFBTUEsZ0JBQU4sU0FBK0JDLGVBQU1DLFNBQXJDLENBQStDO0FBQUE7QUFBQTs7QUFBQSx3Q0FpRC9DLFlBQVk7QUFDdkIsWUFBTUMsYUFBYSxHQUFHLEtBQUtDLEtBQUwsQ0FBV0MsUUFBWCxDQUFvQkMsYUFBcEIsRUFBdEI7QUFDQSxZQUFNQyxRQUFRLEdBQUdKLGFBQWEsQ0FBQ0ssV0FBZCxFQUFqQjs7QUFDQSxVQUFJLENBQUNELFFBQVEsQ0FBQ0UsU0FBVCxFQUFELElBQXlCLEtBQUtMLEtBQUwsQ0FBV00sVUFBWCxHQUF3QixDQUFyRCxFQUF3RDtBQUN0RCxjQUFNLEtBQUtOLEtBQUwsQ0FBV08sWUFBWCxFQUFOO0FBQ0Q7O0FBRUQsVUFBSUMsV0FBVyxHQUFHLHFCQUFsQjtBQUNBQSxNQUFBQSxXQUFXLElBQUksS0FBS1IsS0FBTCxDQUFXUyxNQUFYLENBQWtCQyxRQUFsQixLQUErQixHQUEvQixHQUFxQyxLQUFLVixLQUFMLENBQVdTLE1BQVgsQ0FBa0JFLE9BQWxCLEVBQXBEO0FBQ0FILE1BQUFBLFdBQVcsSUFBSSxjQUFjSSxrQkFBa0IsQ0FBQ2IsYUFBYSxDQUFDYyxPQUFkLEVBQUQsQ0FBL0M7QUFDQUwsTUFBQUEsV0FBVyxJQUFJLFdBQWY7QUFFQSxZQUFNTSxnQkFBTUMsWUFBTixDQUFtQlAsV0FBbkIsQ0FBTjtBQUNBLDJDQUFpQixxQkFBakI7QUFDRCxLQS9EMkQ7QUFBQTs7QUE0QjVEUSxFQUFBQSxNQUFNLEdBQUc7QUFDUCxXQUNFLDZCQUFDLG1DQUFEO0FBQ0UsTUFBQSxRQUFRLEVBQUUsS0FBS2hCLEtBQUwsQ0FBV2lCLFFBRHZCO0FBRUUsTUFBQSxLQUFLLEVBQUUsS0FBS2pCLEtBQUwsQ0FBV2tCLEtBRnBCO0FBSUUsTUFBQSxnQkFBZ0IsRUFBRSxLQUFLbEIsS0FBTCxDQUFXbUIsZ0JBSi9CO0FBS0UsTUFBQSxVQUFVLEVBQUUsS0FBS25CLEtBQUwsQ0FBV29CLFVBTHpCO0FBT0UsTUFBQSxTQUFTLEVBQUUsS0FBS3BCLEtBQUwsQ0FBV3FCLFNBUHhCO0FBUUUsTUFBQSxNQUFNLEVBQUUsS0FBS3JCLEtBQUwsQ0FBV1MsTUFSckI7QUFTRSxNQUFBLE9BQU8sRUFBRSxLQUFLVCxLQUFMLENBQVdzQixPQVR0QjtBQVVFLE1BQUEsUUFBUSxFQUFFLEtBQUt0QixLQUFMLENBQVdDLFFBVnZCO0FBV0UsTUFBQSxVQUFVLEVBQUUsS0FBS0QsS0FBTCxDQUFXTSxVQVh6QjtBQVlFLE1BQUEsY0FBYyxFQUFFLEtBQUtOLEtBQUwsQ0FBV3VCLGNBWjdCO0FBY0UsTUFBQSxVQUFVLEVBQUUsS0FBS0M7QUFkbkIsTUFERjtBQWtCRDs7QUEvQzJEOzs7O2dCQUF6QzVCLGdCLGVBQ0E7QUFDakI7QUFDQXdCLEVBQUFBLFVBQVUsRUFBRUssbUJBQVVDLEtBQVYsQ0FBZ0I7QUFDMUJDLElBQUFBLEVBQUUsRUFBRUYsbUJBQVVHLE1BQVYsQ0FBaUJDLFVBREs7QUFFMUJDLElBQUFBLGdCQUFnQixFQUFFTCxtQkFBVUMsS0FBVixDQUFnQjtBQUNoQ0ssTUFBQUEsTUFBTSxFQUFFTixtQkFBVUcsTUFBVixDQUFpQkMsVUFETztBQUVoQ0csTUFBQUEsSUFBSSxFQUFFUCxtQkFBVUcsTUFBVixDQUFpQkM7QUFGUyxLQUFoQjtBQUZRLEdBQWhCLENBRks7QUFVakI7QUFDQVosRUFBQUEsUUFBUSxFQUFFZ0IsNkJBQWlCSixVQVhWO0FBWWpCWCxFQUFBQSxLQUFLLEVBQUVnQiwwQkFBY0wsVUFaSjtBQWNqQjtBQUNBVixFQUFBQSxnQkFBZ0IsRUFBRU0sbUJBQVVHLE1BZlg7QUFnQmpCUCxFQUFBQSxTQUFTLEVBQUVJLG1CQUFVVSxNQUFWLENBQWlCTixVQWhCWDtBQWlCakJwQixFQUFBQSxNQUFNLEVBQUUyQiwyQkFBZVAsVUFqQk47QUFrQmpCUCxFQUFBQSxPQUFPLEVBQUVlLDhCQUFrQlIsVUFsQlY7QUFtQmpCNUIsRUFBQUEsUUFBUSxFQUFFcUMsOEJBQWtCVCxVQW5CWDtBQW9CakJ2QixFQUFBQSxVQUFVLEVBQUVtQixtQkFBVWMsTUFwQkw7QUFxQmpCaEIsRUFBQUEsY0FBYyxFQUFFRSxtQkFBVWUsSUFBVixDQUFlWCxVQXJCZDtBQXVCakI7QUFDQXRCLEVBQUFBLFlBQVksRUFBRWtCLG1CQUFVZ0IsSUFBVixDQUFlWjtBQXhCWixDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IHtzaGVsbH0gZnJvbSAnZWxlY3Ryb24nO1xuXG5pbXBvcnQge2luY3JlbWVudENvdW50ZXJ9IGZyb20gJy4uL3JlcG9ydGVyLXByb3h5JztcbmltcG9ydCB7UmVtb3RlUHJvcFR5cGUsIFJlbW90ZVNldFByb3BUeXBlLCBCcmFuY2hTZXRQcm9wVHlwZSwgRW5kcG9pbnRQcm9wVHlwZSwgVG9rZW5Qcm9wVHlwZX0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQgSXNzdWVpc2hTZWFyY2hlc0NvbnRyb2xsZXIgZnJvbSAnLi9pc3N1ZWlzaC1zZWFyY2hlcy1jb250cm9sbGVyJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgUmVtb3RlQ29udHJvbGxlciBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgLy8gUmVsYXkgcGF5bG9hZFxuICAgIHJlcG9zaXRvcnk6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICBpZDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgZGVmYXVsdEJyYW5jaFJlZjogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgICAgcHJlZml4OiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICAgIG5hbWU6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgIH0pLFxuICAgIH0pLFxuXG4gICAgLy8gQ29ubmVjdGlvblxuICAgIGVuZHBvaW50OiBFbmRwb2ludFByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgdG9rZW46IFRva2VuUHJvcFR5cGUuaXNSZXF1aXJlZCxcblxuICAgIC8vIFJlcG9zaXRvcnkgZGVyaXZlZCBhdHRyaWJ1dGVzXG4gICAgd29ya2luZ0RpcmVjdG9yeTogUHJvcFR5cGVzLnN0cmluZyxcbiAgICB3b3Jrc3BhY2U6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICByZW1vdGU6IFJlbW90ZVByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgcmVtb3RlczogUmVtb3RlU2V0UHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICBicmFuY2hlczogQnJhbmNoU2V0UHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICBhaGVhZENvdW50OiBQcm9wVHlwZXMubnVtYmVyLFxuICAgIHB1c2hJblByb2dyZXNzOiBQcm9wVHlwZXMuYm9vbC5pc1JlcXVpcmVkLFxuXG4gICAgLy8gQWN0aW9uc1xuICAgIG9uUHVzaEJyYW5jaDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPElzc3VlaXNoU2VhcmNoZXNDb250cm9sbGVyXG4gICAgICAgIGVuZHBvaW50PXt0aGlzLnByb3BzLmVuZHBvaW50fVxuICAgICAgICB0b2tlbj17dGhpcy5wcm9wcy50b2tlbn1cblxuICAgICAgICB3b3JraW5nRGlyZWN0b3J5PXt0aGlzLnByb3BzLndvcmtpbmdEaXJlY3Rvcnl9XG4gICAgICAgIHJlcG9zaXRvcnk9e3RoaXMucHJvcHMucmVwb3NpdG9yeX1cblxuICAgICAgICB3b3Jrc3BhY2U9e3RoaXMucHJvcHMud29ya3NwYWNlfVxuICAgICAgICByZW1vdGU9e3RoaXMucHJvcHMucmVtb3RlfVxuICAgICAgICByZW1vdGVzPXt0aGlzLnByb3BzLnJlbW90ZXN9XG4gICAgICAgIGJyYW5jaGVzPXt0aGlzLnByb3BzLmJyYW5jaGVzfVxuICAgICAgICBhaGVhZENvdW50PXt0aGlzLnByb3BzLmFoZWFkQ291bnR9XG4gICAgICAgIHB1c2hJblByb2dyZXNzPXt0aGlzLnByb3BzLnB1c2hJblByb2dyZXNzfVxuXG4gICAgICAgIG9uQ3JlYXRlUHI9e3RoaXMub25DcmVhdGVQcn1cbiAgICAgIC8+XG4gICAgKTtcbiAgfVxuXG4gIG9uQ3JlYXRlUHIgPSBhc3luYyAoKSA9PiB7XG4gICAgY29uc3QgY3VycmVudEJyYW5jaCA9IHRoaXMucHJvcHMuYnJhbmNoZXMuZ2V0SGVhZEJyYW5jaCgpO1xuICAgIGNvbnN0IHVwc3RyZWFtID0gY3VycmVudEJyYW5jaC5nZXRVcHN0cmVhbSgpO1xuICAgIGlmICghdXBzdHJlYW0uaXNQcmVzZW50KCkgfHwgdGhpcy5wcm9wcy5haGVhZENvdW50ID4gMCkge1xuICAgICAgYXdhaXQgdGhpcy5wcm9wcy5vblB1c2hCcmFuY2goKTtcbiAgICB9XG5cbiAgICBsZXQgY3JlYXRlUHJVcmwgPSAnaHR0cHM6Ly9naXRodWIuY29tLyc7XG4gICAgY3JlYXRlUHJVcmwgKz0gdGhpcy5wcm9wcy5yZW1vdGUuZ2V0T3duZXIoKSArICcvJyArIHRoaXMucHJvcHMucmVtb3RlLmdldFJlcG8oKTtcbiAgICBjcmVhdGVQclVybCArPSAnL2NvbXBhcmUvJyArIGVuY29kZVVSSUNvbXBvbmVudChjdXJyZW50QnJhbmNoLmdldE5hbWUoKSk7XG4gICAgY3JlYXRlUHJVcmwgKz0gJz9leHBhbmQ9MSc7XG5cbiAgICBhd2FpdCBzaGVsbC5vcGVuRXh0ZXJuYWwoY3JlYXRlUHJVcmwpO1xuICAgIGluY3JlbWVudENvdW50ZXIoJ2NyZWF0ZS1wdWxsLXJlcXVlc3QnKTtcbiAgfVxufVxuIl19