"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _branchView = _interopRequireDefault(require("../views/branch-view"));

var _branchMenuView = _interopRequireDefault(require("../views/branch-menu-view"));

var _pushPullView = _interopRequireDefault(require("../views/push-pull-view"));

var _changedFilesCountView = _interopRequireDefault(require("../views/changed-files-count-view"));

var _githubTileView = _interopRequireDefault(require("../views/github-tile-view"));

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class StatusBarTileController extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "fetchData", repository => {
      return (0, _yubikiri.default)({
        currentBranch: repository.getCurrentBranch(),
        branches: repository.getBranches(),
        statusesForChangedFiles: repository.getStatusesForChangedFiles(),
        currentRemote: async query => repository.getRemoteForBranch((await query.currentBranch).getName()),
        aheadCount: async query => repository.getAheadCount((await query.currentBranch).getName()),
        behindCount: async query => repository.getBehindCount((await query.currentBranch).getName()),
        originExists: async () => (await repository.getRemotes()).withName('origin').isPresent()
      });
    });

    _defineProperty(this, "handleOpenGitTimingsView", e => {
      e && e.preventDefault();
      this.props.workspace.open('atom-github://debug/timings');
    });

    _defineProperty(this, "checkout", (branchName, options) => {
      return this.props.repository.checkout(branchName, options);
    });

    this.refBranchViewRoot = new _refHolder.default();
  }

  getChangedFilesCount(data) {
    const {
      stagedFiles,
      unstagedFiles,
      mergeConflictFiles
    } = data.statusesForChangedFiles;
    const changedFiles = new Set();

    for (const filePath in unstagedFiles) {
      changedFiles.add(filePath);
    }

    for (const filePath in stagedFiles) {
      changedFiles.add(filePath);
    }

    for (const filePath in mergeConflictFiles) {
      changedFiles.add(filePath);
    }

    return changedFiles.size;
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchData
    }, data => data ? this.renderWithData(data) : null);
  }

  renderWithData(data) {
    let changedFilesCount, mergeConflictsPresent;

    if (data.statusesForChangedFiles) {
      changedFilesCount = this.getChangedFilesCount(data);
      mergeConflictsPresent = Object.keys(data.statusesForChangedFiles.mergeConflictFiles).length > 0;
    }

    const repoProps = {
      repository: this.props.repository,
      currentBranch: data.currentBranch,
      branches: data.branches,
      currentRemote: data.currentRemote,
      aheadCount: data.aheadCount,
      behindCount: data.behindCount,
      originExists: data.originExists,
      changedFilesCount,
      mergeConflictsPresent
    };
    return _react.default.createElement(_react.Fragment, null, this.renderTiles(repoProps), _react.default.createElement(_githubTileView.default, {
      didClick: this.props.toggleGithubTab
    }), _react.default.createElement(_changedFilesCountView.default, {
      didClick: this.props.toggleGitTab,
      changedFilesCount: repoProps.changedFilesCount,
      mergeConflictsPresent: repoProps.mergeConflictsPresent
    }));
  }

  renderTiles(repoProps) {
    if (!this.props.repository.showStatusBarTiles()) {
      return null;
    }

    const operationStates = this.props.repository.getOperationStates();
    const pushInProgress = operationStates.isPushInProgress();
    const pullInProgress = operationStates.isPullInProgress();
    const fetchInProgress = operationStates.isFetchInProgress();
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement(_commands.default, {
      registry: this.props.commands,
      target: "atom-workspace"
    }, _react.default.createElement(_commands.Command, {
      command: "github:fetch",
      callback: this.fetch(repoProps)
    }), _react.default.createElement(_commands.Command, {
      command: "github:pull",
      callback: this.pull(repoProps)
    }), _react.default.createElement(_commands.Command, {
      command: "github:push",
      callback: () => this.push(repoProps)({
        force: false,
        setUpstream: !repoProps.currentRemote.isPresent()
      })
    }), _react.default.createElement(_commands.Command, {
      command: "github:force-push",
      callback: () => this.push(repoProps)({
        force: true,
        setUpstream: !repoProps.currentRemote.isPresent()
      })
    })), _react.default.createElement(_branchView.default, {
      refRoot: this.refBranchViewRoot.setter,
      workspace: this.props.workspace,
      checkout: this.checkout,
      currentBranch: repoProps.currentBranch
    }), _react.default.createElement(_tooltip.default, {
      manager: this.props.tooltips,
      target: this.refBranchViewRoot,
      trigger: "click",
      className: "github-StatusBarTileController-tooltipMenu"
    }, _react.default.createElement(_branchMenuView.default, {
      workspace: this.props.workspace,
      notificationManager: this.props.notificationManager,
      commands: this.props.commands,
      checkout: this.checkout,
      branches: repoProps.branches,
      currentBranch: repoProps.currentBranch
    })), _react.default.createElement(_pushPullView.default, {
      isSyncing: fetchInProgress || pullInProgress || pushInProgress,
      isFetching: fetchInProgress,
      isPulling: pullInProgress,
      isPushing: pushInProgress,
      push: this.push(repoProps),
      pull: this.pull(repoProps),
      fetch: this.fetch(repoProps),
      tooltipManager: this.props.tooltips,
      currentBranch: repoProps.currentBranch,
      currentRemote: repoProps.currentRemote,
      behindCount: repoProps.behindCount,
      aheadCount: repoProps.aheadCount,
      originExists: repoProps.originExists
    }));
  }

  push(data) {
    return ({
      force,
      setUpstream
    } = {}) => {
      return this.props.repository.push(data.currentBranch.getName(), {
        force,
        setUpstream,
        refSpec: data.currentBranch.getRefSpec('PUSH')
      });
    };
  }

  pull(data) {
    return () => {
      return this.props.repository.pull(data.currentBranch.getName(), {
        refSpec: data.currentBranch.getRefSpec('PULL')
      });
    };
  }

  fetch(data) {
    return () => {
      const upstream = data.currentBranch.getUpstream();
      return this.props.repository.fetch(upstream.getRemoteRef(), {
        remoteName: upstream.getRemoteName()
      });
    };
  }

}

exports.default = StatusBarTileController;

_defineProperty(StatusBarTileController, "propTypes", {
  workspace: _propTypes.default.object.isRequired,
  notificationManager: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  confirm: _propTypes.default.func.isRequired,
  repository: _propTypes.default.object.isRequired,
  toggleGitTab: _propTypes.default.func,
  toggleGithubTab: _propTypes.default.func
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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