"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ErrorBoundary extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      hasError: false,
      error: null,
      errorInfo: null
    };
  }

  static getDerivedStateFromError(error) {
    // Update state so the next render will show the fallback UI.
    return {
      hasError: true
    };
  }

  componentDidCatch(error, errorInfo) {
    this.setState({
      error,
      errorInfo
    });
  }

  render() {
    if (this.state.hasError) {
      // You can render any custom fallback UI
      return this.props.fallback ? this.props.fallback : null;
    }

    return this.props.children;
  }

}

exports.default = ErrorBoundary;

_defineProperty(ErrorBoundary, "propTypes", {
  children: _propTypes.default.node.isRequired,
  fallback: _propTypes.default.any
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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