"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BIN_SCRIPTS = void 0;

var _os = _interopRequireDefault(require("os"));

var _path = _interopRequireDefault(require("path"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _helpers = require("./helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const BIN_SCRIPTS = {
  getCredentialHelperJs: 'git-credential-atom.js',
  getCredentialHelperSh: 'git-credential-atom.sh',
  getAskPassJs: 'git-askpass-atom.js',
  getAskPassSh: 'git-askpass-atom.sh',
  getSshWrapperSh: 'linux-ssh-wrapper.sh',
  getGpgWrapperSh: 'gpg-wrapper.sh'
};
exports.BIN_SCRIPTS = BIN_SCRIPTS;

class GitTempDir {
  constructor() {
    this.created = false;
  }

  async ensure() {
    if (this.created) {
      return;
    }

    this.root = await (0, _helpers.getTempDir)({
      dir: process.platform === 'win32' ? _os.default.tmpdir() : '/tmp',
      prefix: 'github-',
      symlinkOk: true
    });
    await Promise.all(Object.values(BIN_SCRIPTS).map(async filename => {
      await _fsExtra.default.copy(_path.default.resolve((0, _helpers.getPackageRoot)(), 'bin', filename), _path.default.join(this.root, filename));

      if (_path.default.extname(filename) === '.sh') {
        await _fsExtra.default.chmod(_path.default.join(this.root, filename), 0o700);
      }
    }));
    this.created = true;
  }

  getRootPath() {
    return this.root;
  }

  getScriptPath(filename) {
    if (!this.created) {
      throw new Error(`Attempt to access filename ${filename} in uninitialized GitTempDir`);
    }

    return _path.default.join(this.root, filename);
  }

  getSocketOptions() {
    if (process.platform === 'win32') {
      return {
        port: 0,
        host: 'localhost'
      };
    } else {
      return {
        path: this.getScriptPath('helper.sock')
      };
    }
  }

  dispose() {
    return _fsExtra.default.remove(this.root);
  }

}

exports.default = GitTempDir;

function createGetter(key) {
  const filename = BIN_SCRIPTS[key];
  return function () {
    return this.getScriptPath(filename);
  };
}

for (const key in BIN_SCRIPTS) {
  GitTempDir.prototype[key] = createGetter(key);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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