"use strict";

var _githubPackage = _interopRequireDefault(require("./github-package"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let pack;
const entry = {
  initialize() {
    pack = new _githubPackage.default({
      workspace: atom.workspace,
      project: atom.project,
      commands: atom.commands,
      notificationManager: atom.notifications,
      tooltips: atom.tooltips,
      styles: atom.styles,
      keymaps: atom.keymaps,
      grammars: atom.grammars,
      config: atom.config,
      deserializers: atom.deserializers,
      confirm: atom.confirm.bind(atom),
      getLoadSettings: atom.getLoadSettings.bind(atom),
      currentWindow: atom.getCurrentWindow(),
      configDirPath: atom.getConfigDirPath()
    });
  }

};
module.exports = new Proxy(entry, {
  get(target, name) {
    if (pack && Reflect.has(pack, name)) {
      let item = pack[name];

      if (typeof item === 'function') {
        item = item.bind(pack);
      }

      return item;
    } else {
      return target[name];
    }
  }

});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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