"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _commitDetailContainer = _interopRequireDefault(require("../containers/commit-detail-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitDetailItem extends _react.default.Component {
  static buildURI(workingDirectory, sha) {
    return `atom-github://commit-detail?workdir=${encodeURIComponent(workingDirectory)}&sha=${encodeURIComponent(sha)}`;
  }

  constructor(props) {
    super(props);

    _defineProperty(this, "destroy", () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    });

    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
    this.shouldFocus = true;
    this.refInitialFocus = new _refHolder.default();
    this.refEditor = new _refHolder.default();
    this.refEditor.observe(editor => {
      if (editor.isAlive()) {
        this.emitter.emit('did-change-embedded-text-editor', editor);
      }
    });
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();
    return _react.default.createElement(_commitDetailContainer.default, _extends({
      itemType: this.constructor,
      repository: repository
    }, this.props, {
      destroy: this.destroy,
      refEditor: this.refEditor,
      refInitialFocus: this.refInitialFocus
    }));
  }

  getTitle() {
    return `Commit: ${this.props.sha}`;
  }

  getIconName() {
    return 'git-commit';
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => editor.isAlive() && cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  getSha() {
    return this.props.sha;
  }

  serialize() {
    return {
      deserializer: 'CommitDetailStub',
      uri: CommitDetailItem.buildURI(this.props.workingDirectory, this.props.sha)
    };
  }

  preventFocus() {
    this.shouldFocus = false;
  }

  focus() {
    this.refInitialFocus.getPromise().then(focusable => {
      if (!this.shouldFocus) {
        return;
      }

      focusable.focus();
    });
  }

}

exports.default = CommitDetailItem;

_defineProperty(CommitDetailItem, "propTypes", {
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  workingDirectory: _propTypes.default.string.isRequired,
  sha: _propTypes.default.string.isRequired
});

_defineProperty(CommitDetailItem, "uriPattern", 'atom-github://commit-detail?workdir={workingDirectory}&sha={sha}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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