"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _commitPreviewContainer = _interopRequireDefault(require("../containers/commit-preview-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitPreviewItem extends _react.default.Component {
  static buildURI(workingDirectory) {
    return `atom-github://commit-preview?workdir=${encodeURIComponent(workingDirectory)}`;
  }

  constructor(props) {
    super(props);

    _defineProperty(this, "destroy", () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    });

    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
    this.refInitialFocus = new _refHolder.default();
    this.refEditor = new _refHolder.default();
    this.refEditor.observe(editor => {
      if (editor.isAlive()) {
        this.emitter.emit('did-change-embedded-text-editor', editor);
      }
    });
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();
    return _react.default.createElement(_commitPreviewContainer.default, _extends({
      itemType: this.constructor,
      repository: repository
    }, this.props, {
      destroy: this.destroy,
      refEditor: this.refEditor,
      refInitialFocus: this.refInitialFocus
    }));
  }

  getTitle() {
    return 'Staged Changes';
  }

  getIconName() {
    return 'tasklist';
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => editor.isAlive() && cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  serialize() {
    return {
      deserializer: 'CommitPreviewStub',
      uri: CommitPreviewItem.buildURI(this.props.workingDirectory)
    };
  }

  focus() {
    this.refInitialFocus.map(focusable => focusable.focus());
  }

}

exports.default = CommitPreviewItem;

_defineProperty(CommitPreviewItem, "propTypes", {
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  workingDirectory: _propTypes.default.string.isRequired,
  discardLines: _propTypes.default.func.isRequired,
  undoLastDiscard: _propTypes.default.func.isRequired,
  surfaceToCommitPreviewButton: _propTypes.default.func.isRequired
});

_defineProperty(CommitPreviewItem, "uriPattern", 'atom-github://commit-preview?workdir={workingDirectory}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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