"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

var _repository = _interopRequireDefault(require("../models/repository"));

var _endpoint = require("../models/endpoint");

var _issueishDetailContainer = _interopRequireDefault(require("../containers/issueish-detail-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishDetailItem extends _react.Component {
  static buildURI({
    host,
    owner,
    repo,
    number,
    workdir
  }) {
    const encodeOptionalParam = param => param ? encodeURIComponent(param) : '';

    return 'atom-github://issueish/' + encodeURIComponent(host) + '/' + encodeURIComponent(owner) + '/' + encodeURIComponent(repo) + '/' + encodeURIComponent(number) + '?workdir=' + encodeOptionalParam(workdir);
  }

  constructor(props) {
    super(props);

    _defineProperty(this, "destroy", () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    });

    _defineProperty(this, "onTabSelected", index => new Promise(resolve => {
      this.setState({
        selectedTab: index,
        initChangedFilePath: '',
        initChangedFilePosition: 0
      }, resolve);
    }));

    _defineProperty(this, "onOpenFilesTab", callback => this.emitter.on('on-open-files-tab', callback));

    (0, _helpers.autobind)(this, 'switchToIssueish', 'handleTitleChanged');
    this.emitter = new _eventKit.Emitter();
    this.title = `${this.props.owner}/${this.props.repo}#${this.props.issueishNumber}`;
    this.hasTerminatedPendingState = false;
    const repository = this.props.workingDirectory === '' ? _repository.default.absent() : this.props.workdirContextPool.add(this.props.workingDirectory).getRepository();
    this.state = {
      host: this.props.host,
      owner: this.props.owner,
      repo: this.props.repo,
      issueishNumber: this.props.issueishNumber,
      repository,
      initChangedFilePath: '',
      initChangedFilePosition: 0,
      selectedTab: this.props.initSelectedTab
    };

    if (repository.isAbsent()) {
      this.switchToIssueish(this.props.owner, this.props.repo, this.props.issueishNumber);
    }

    this.refEditor = new _refHolder.default();
    this.refEditor.observe(editor => {
      if (editor.isAlive()) {
        this.emitter.emit('did-change-embedded-text-editor', editor);
      }
    });
  }

  render() {
    return _react.default.createElement(_issueishDetailContainer.default, {
      endpoint: (0, _endpoint.getEndpoint)(this.state.host),
      owner: this.state.owner,
      repo: this.state.repo,
      issueishNumber: this.state.issueishNumber,
      initChangedFilePath: this.state.initChangedFilePath,
      initChangedFilePosition: this.state.initChangedFilePosition,
      selectedTab: this.state.selectedTab,
      onTabSelected: this.onTabSelected,
      onOpenFilesTab: this.onOpenFilesTab,
      repository: this.state.repository,
      workspace: this.props.workspace,
      loginModel: this.props.loginModel,
      onTitleChange: this.handleTitleChanged,
      switchToIssueish: this.switchToIssueish,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,
      destroy: this.destroy,
      itemType: this.constructor,
      refEditor: this.refEditor,
      reportRelayError: this.props.reportRelayError
    });
  }

  async switchToIssueish(owner, repo, issueishNumber) {
    const pool = this.props.workdirContextPool;
    const prev = {
      owner: this.state.owner,
      repo: this.state.repo,
      issueishNumber: this.state.issueishNumber
    };
    const nextRepository = (await this.state.repository.hasGitHubRemote(this.state.host, owner, repo)) ? this.state.repository : (await pool.getMatchingContext(this.state.host, owner, repo)).getRepository();
    await new Promise(resolve => {
      this.setState((prevState, props) => {
        if (pool === props.workdirContextPool && prevState.owner === prev.owner && prevState.repo === prev.repo && prevState.issueishNumber === prev.issueishNumber) {
          (0, _reporterProxy.addEvent)('open-issueish-in-pane', {
            package: 'github',
            from: 'issueish-link',
            target: 'current-tab'
          });
          return {
            owner,
            repo,
            issueishNumber,
            repository: nextRepository
          };
        }

        return {};
      }, resolve);
    });
  }

  handleTitleChanged(title) {
    if (this.title !== title) {
      this.title = title;
      this.emitter.emit('did-change-title', title);
    }
  }

  onDidChangeTitle(cb) {
    return this.emitter.on('did-change-title', cb);
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  serialize() {
    return {
      uri: IssueishDetailItem.buildURI({
        host: this.props.host,
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.issueishNumber,
        workdir: this.props.workingDirectory
      }),
      selectedTab: this.state.selectedTab,
      deserializer: 'IssueishDetailItem'
    };
  }

  getTitle() {
    return this.title;
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => editor.isAlive() && cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  openFilesTab({
    changedFilePath,
    changedFilePosition
  }) {
    this.setState({
      selectedTab: IssueishDetailItem.tabs.FILES,
      initChangedFilePath: changedFilePath,
      initChangedFilePosition: changedFilePosition
    }, () => {
      this.emitter.emit('on-open-files-tab', {
        changedFilePath,
        changedFilePosition
      });
    });
  }

}

exports.default = IssueishDetailItem;

_defineProperty(IssueishDetailItem, "tabs", {
  OVERVIEW: 0,
  BUILD_STATUS: 1,
  COMMITS: 2,
  FILES: 3
});

_defineProperty(IssueishDetailItem, "propTypes", {
  // Issueish selection criteria
  // Parsed from item URI
  host: _propTypes.default.string.isRequired,
  owner: _propTypes.default.string.isRequired,
  repo: _propTypes.default.string.isRequired,
  issueishNumber: _propTypes.default.number.isRequired,
  workingDirectory: _propTypes.default.string.isRequired,
  // Package models
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  initSelectedTab: _propTypes.default.oneOf(Object.keys(IssueishDetailItem.tabs).map(k => IssueishDetailItem.tabs[k])),
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  // Action methods
  reportRelayError: _propTypes.default.func.isRequired
});

_defineProperty(IssueishDetailItem, "defaultProps", {
  initSelectedTab: IssueishDetailItem.tabs.OVERVIEW
});

_defineProperty(IssueishDetailItem, "uriPattern", 'atom-github://issueish/{host}/{owner}/{repo}/{issueishNumber}?workdir={workingDirectory}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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