"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _reactRelay = require("react-relay");

var _issueishTooltipContainer = _interopRequireDefault(require("../containers/issueish-tooltip-container"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class IssueishTooltipItem {
  constructor(issueishUrl, relayEnvironment) {
    this.issueishUrl = issueishUrl;
    this.relayEnvironment = relayEnvironment;
  }

  getElement() {
    return this.element;
  }

  get element() {
    if (!this._element) {
      this._element = document.createElement('div');

      const rootContainer = _react.default.createElement(_reactRelay.QueryRenderer, {
        environment: this.relayEnvironment,
        query: _graphql || (_graphql = function () {
          const node = require("./__generated__/issueishTooltipItemQuery.graphql");

          if (node.hash && node.hash !== "8e6b32b5cdcdd3debccc7adaa2b4e82c") {
            console.error("The definition of 'issueishTooltipItemQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
          }

          return require("./__generated__/issueishTooltipItemQuery.graphql");
        }),
        variables: {
          issueishUrl: this.issueishUrl
        },
        render: ({
          error,
          props,
          retry
        }) => {
          if (error) {
            return _react.default.createElement("div", null, "Could not load information");
          } else if (props) {
            return _react.default.createElement(_issueishTooltipContainer.default, props);
          } else {
            return _react.default.createElement("div", {
              className: "github-Loader"
            }, _react.default.createElement("span", {
              className: "github-Spinner"
            }));
          }
        }
      });

      this._component = _reactDom.default.render(rootContainer, this._element);
    }

    return this._element;
  }

  destroy() {
    if (this._element) {
      _reactDom.default.unmountComponentAtNode(this._element);

      delete this._element;
    }
  }

}

exports.default = IssueishTooltipItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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