"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _reactRelay = require("react-relay");

var _userMentionTooltipContainer = _interopRequireDefault(require("../containers/user-mention-tooltip-container"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class UserMentionTooltipItem {
  constructor(username, relayEnvironment) {
    this.username = username.substr(1);
    this.relayEnvironment = relayEnvironment;
  }

  getElement() {
    return this.element;
  }

  get element() {
    if (!this._element) {
      this._element = document.createElement('div');

      const rootContainer = _react.default.createElement(_reactRelay.QueryRenderer, {
        environment: this.relayEnvironment,
        query: _graphql || (_graphql = function () {
          const node = require("./__generated__/userMentionTooltipItemQuery.graphql");

          if (node.hash && node.hash !== "c0e8b6f6d3028f3f2679ce9e1486981e") {
            console.error("The definition of 'userMentionTooltipItemQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
          }

          return require("./__generated__/userMentionTooltipItemQuery.graphql");
        }),
        variables: {
          username: this.username
        },
        render: ({
          error,
          props,
          retry
        }) => {
          if (error) {
            return _react.default.createElement("div", null, "Could not load information");
          } else if (props) {
            return _react.default.createElement(_userMentionTooltipContainer.default, props);
          } else {
            return _react.default.createElement("div", {
              className: "github-Loader"
            }, _react.default.createElement("span", {
              className: "github-Spinner"
            }));
          }
        }
      });

      this._component = _reactDom.default.render(rootContainer, this._element);
    }

    return this._element;
  }

  destroy() {
    if (this._element) {
      _reactDom.default.unmountComponentAtNode(this._element);

      delete this._element;
    }
  }

}

exports.default = UserMentionTooltipItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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