"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _markerTools = require("./marker-tools");

class Banner {
  constructor(editor, marker, description, originalText) {
    this.editor = editor;
    this.marker = marker;
    this.description = description;
    this.originalText = originalText;
  }

  getMarker() {
    return this.marker;
  }

  getRange() {
    return this.marker.getBufferRange();
  }

  isModified() {
    const chomp = line => line.replace(/\r?\n$/, '');

    const text = this.editor.getTextInBufferRange(this.marker.getBufferRange());
    return chomp(text) !== chomp(this.originalText);
  }

  revert() {
    const range = this.getMarker().getBufferRange();
    this.editor.setTextInBufferRange(range, this.originalText);
    this.getMarker().setBufferRange(range);
  }

  delete() {
    (0, _markerTools.deleteMarkerIn)(this.getMarker(), this.editor);
  }

}

exports.default = Banner;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImJhbm5lci5qcyJdLCJuYW1lcyI6WyJCYW5uZXIiLCJjb25zdHJ1Y3RvciIsImVkaXRvciIsIm1hcmtlciIsImRlc2NyaXB0aW9uIiwib3JpZ2luYWxUZXh0IiwiZ2V0TWFya2VyIiwiZ2V0UmFuZ2UiLCJnZXRCdWZmZXJSYW5nZSIsImlzTW9kaWZpZWQiLCJjaG9tcCIsImxpbmUiLCJyZXBsYWNlIiwidGV4dCIsImdldFRleHRJbkJ1ZmZlclJhbmdlIiwicmV2ZXJ0IiwicmFuZ2UiLCJzZXRUZXh0SW5CdWZmZXJSYW5nZSIsInNldEJ1ZmZlclJhbmdlIiwiZGVsZXRlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBRWUsTUFBTUEsTUFBTixDQUFhO0FBQzFCQyxFQUFBQSxXQUFXLENBQUNDLE1BQUQsRUFBU0MsTUFBVCxFQUFpQkMsV0FBakIsRUFBOEJDLFlBQTlCLEVBQTRDO0FBQ3JELFNBQUtILE1BQUwsR0FBY0EsTUFBZDtBQUNBLFNBQUtDLE1BQUwsR0FBY0EsTUFBZDtBQUNBLFNBQUtDLFdBQUwsR0FBbUJBLFdBQW5CO0FBQ0EsU0FBS0MsWUFBTCxHQUFvQkEsWUFBcEI7QUFDRDs7QUFFREMsRUFBQUEsU0FBUyxHQUFHO0FBQ1YsV0FBTyxLQUFLSCxNQUFaO0FBQ0Q7O0FBRURJLEVBQUFBLFFBQVEsR0FBRztBQUNULFdBQU8sS0FBS0osTUFBTCxDQUFZSyxjQUFaLEVBQVA7QUFDRDs7QUFFREMsRUFBQUEsVUFBVSxHQUFHO0FBQ1gsVUFBTUMsS0FBSyxHQUFHQyxJQUFJLElBQUlBLElBQUksQ0FBQ0MsT0FBTCxDQUFhLFFBQWIsRUFBdUIsRUFBdkIsQ0FBdEI7O0FBRUEsVUFBTUMsSUFBSSxHQUFHLEtBQUtYLE1BQUwsQ0FBWVksb0JBQVosQ0FBaUMsS0FBS1gsTUFBTCxDQUFZSyxjQUFaLEVBQWpDLENBQWI7QUFDQSxXQUFPRSxLQUFLLENBQUNHLElBQUQsQ0FBTCxLQUFnQkgsS0FBSyxDQUFDLEtBQUtMLFlBQU4sQ0FBNUI7QUFDRDs7QUFFRFUsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsVUFBTUMsS0FBSyxHQUFHLEtBQUtWLFNBQUwsR0FBaUJFLGNBQWpCLEVBQWQ7QUFDQSxTQUFLTixNQUFMLENBQVllLG9CQUFaLENBQWlDRCxLQUFqQyxFQUF3QyxLQUFLWCxZQUE3QztBQUNBLFNBQUtDLFNBQUwsR0FBaUJZLGNBQWpCLENBQWdDRixLQUFoQztBQUNEOztBQUVERyxFQUFBQSxNQUFNLEdBQUc7QUFDUCxxQ0FBZSxLQUFLYixTQUFMLEVBQWYsRUFBaUMsS0FBS0osTUFBdEM7QUFDRDs7QUEvQnlCIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7ZGVsZXRlTWFya2VySW59IGZyb20gJy4vbWFya2VyLXRvb2xzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQmFubmVyIHtcbiAgY29uc3RydWN0b3IoZWRpdG9yLCBtYXJrZXIsIGRlc2NyaXB0aW9uLCBvcmlnaW5hbFRleHQpIHtcbiAgICB0aGlzLmVkaXRvciA9IGVkaXRvcjtcbiAgICB0aGlzLm1hcmtlciA9IG1hcmtlcjtcbiAgICB0aGlzLmRlc2NyaXB0aW9uID0gZGVzY3JpcHRpb247XG4gICAgdGhpcy5vcmlnaW5hbFRleHQgPSBvcmlnaW5hbFRleHQ7XG4gIH1cblxuICBnZXRNYXJrZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMubWFya2VyO1xuICB9XG5cbiAgZ2V0UmFuZ2UoKSB7XG4gICAgcmV0dXJuIHRoaXMubWFya2VyLmdldEJ1ZmZlclJhbmdlKCk7XG4gIH1cblxuICBpc01vZGlmaWVkKCkge1xuICAgIGNvbnN0IGNob21wID0gbGluZSA9PiBsaW5lLnJlcGxhY2UoL1xccj9cXG4kLywgJycpO1xuXG4gICAgY29uc3QgdGV4dCA9IHRoaXMuZWRpdG9yLmdldFRleHRJbkJ1ZmZlclJhbmdlKHRoaXMubWFya2VyLmdldEJ1ZmZlclJhbmdlKCkpO1xuICAgIHJldHVybiBjaG9tcCh0ZXh0KSAhPT0gY2hvbXAodGhpcy5vcmlnaW5hbFRleHQpO1xuICB9XG5cbiAgcmV2ZXJ0KCkge1xuICAgIGNvbnN0IHJhbmdlID0gdGhpcy5nZXRNYXJrZXIoKS5nZXRCdWZmZXJSYW5nZSgpO1xuICAgIHRoaXMuZWRpdG9yLnNldFRleHRJbkJ1ZmZlclJhbmdlKHJhbmdlLCB0aGlzLm9yaWdpbmFsVGV4dCk7XG4gICAgdGhpcy5nZXRNYXJrZXIoKS5zZXRCdWZmZXJSYW5nZShyYW5nZSk7XG4gIH1cblxuICBkZWxldGUoKSB7XG4gICAgZGVsZXRlTWFya2VySW4odGhpcy5nZXRNYXJrZXIoKSwgdGhpcy5lZGl0b3IpO1xuICB9XG59XG4iXX0=