"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE = exports.THEIRS = exports.OURS = void 0;

class Source {
  constructor(name, uiString, cssClass) {
    this.name = name.toLowerCase();
    this.uiString = uiString;
    this.cssClass = cssClass;
  }

  when(actions) {
    const chosen = actions[this.name] || actions.default || (() => {
      throw new Error(`Unexpected conflict side source: ${this.name}`);
    });

    return chosen();
  }

  getName() {
    return this.name;
  }

  getCSSClass() {
    return this.cssClass;
  }

  getBannerCSSClass() {
    return this.cssClass + 'Banner';
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toUIString() {
    return this.uiString;
  }

  toString() {
    return `<Source: ${this.name.toUpperCase()}>`;
  }

}

const OURS = new Source('OURS', 'our changes', 'github-ConflictOurs');
exports.OURS = OURS;
const THEIRS = new Source('THEIRS', 'their changes', 'github-ConflictTheirs');
exports.THEIRS = THEIRS;
const BASE = new Source('BASE', 'common ancestor', 'github-ConflictBase');
exports.BASE = BASE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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