"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEndpoint = getEndpoint;
exports.DOTCOM = void 0;

// API endpoint for a GitHub instance, either dotcom or an Enterprise installation.
class Endpoint {
  constructor(host, apiHost, apiRouteParts) {
    this.host = host;
    this.apiHost = apiHost;
    this.apiRoute = apiRouteParts.map(encodeURIComponent).join('/');
  }

  getRestURI(...parts) {
    const sep = parts.length > 0 ? '/' : '';
    return this.getRestRoot() + sep + parts.map(encodeURIComponent).join('/');
  }

  getGraphQLRoot() {
    return this.getRestURI('graphql');
  }

  getRestRoot() {
    const sep = this.apiRoute !== '' ? '/' : '';
    return `https://${this.apiHost}${sep}${this.apiRoute}`;
  }

  getHost() {
    return this.host;
  }

  getLoginAccount() {
    return `https://${this.apiHost}`;
  }

} // API endpoint for GitHub.com


const DOTCOM = new Endpoint('github.com', 'api.github.com', []);
exports.DOTCOM = DOTCOM;

function getEndpoint(host) {
  if (host === 'github.com') {
    return DOTCOM;
  } else {
    return new Endpoint(host, host, ['api', 'v3']);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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