"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _url = require("url");

var _moment = _interopRequireDefault(require("moment"));

var _buildStatus = require("./build-status");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Issueish {
  constructor(data) {
    const author = data.author || _helpers.GHOST_USER;
    this.number = data.number;
    this.title = data.title;
    this.url = new _url.URL(data.url);
    this.authorLogin = author.login;
    this.authorAvatarURL = new _url.URL(author.avatarUrl);
    this.createdAt = (0, _moment.default)(data.createdAt, _moment.default.ISO_8601);
    this.headRefName = data.headRefName;
    this.headRepositoryID = data.repository.id;
    this.latestCommit = null;
    this.statusContexts = [];
    this.checkRuns = [];

    if (data.commits.nodes.length > 0) {
      this.latestCommit = data.commits.nodes[0].commit;
    }

    if (this.latestCommit && this.latestCommit.status) {
      this.statusContexts = this.latestCommit.status.contexts;
    }
  }

  getNumber() {
    return this.number;
  }

  getTitle() {
    return this.title;
  }

  getGitHubURL() {
    return this.url.toString();
  }

  getAuthorLogin() {
    return this.authorLogin;
  }

  getAuthorAvatarURL(size = 32) {
    const u = new _url.URL(this.authorAvatarURL.toString());
    u.searchParams.set('s', size);
    return u.toString();
  }

  getCreatedAt() {
    return this.createdAt;
  }

  getHeadRefName() {
    return this.headRefName;
  }

  getHeadRepositoryID() {
    return this.headRepositoryID;
  }

  getLatestCommit() {
    return this.latestCommit;
  }

  setCheckRuns(runsBySuite) {
    this.checkRuns = [];

    for (const [, runs] of runsBySuite) {
      for (const checkRun of runs) {
        this.checkRuns.push(checkRun);
      }
    }
  }

  getStatusCounts() {
    const buildStatuses = [];

    for (const context of this.statusContexts) {
      buildStatuses.push((0, _buildStatus.buildStatusFromStatusContext)(context));
    }

    for (const checkRun of this.checkRuns) {
      buildStatuses.push((0, _buildStatus.buildStatusFromCheckResult)(checkRun));
    }

    const counts = {
      pending: 0,
      failure: 0,
      success: 0,
      neutral: 0
    };

    for (const {
      classSuffix
    } of buildStatuses) {
      counts[classSuffix]++;
    }

    return counts;
  }

}

exports.default = Issueish;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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