"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nullOperationStates = exports.default = void 0;

class OperationStates {
  constructor(options = {}) {
    this.didUpdate = options.didUpdate || (() => {});

    this.pushInProgress = false;
    this.pullInProgress = false;
    this.fetchInProgress = false;
    this.commitInProgress = false;
    this.checkoutInProgress = false;
  }

  isPushInProgress() {
    return this.pushInProgress;
  }

  isPullInProgress() {
    return this.pullInProgress;
  }

  isFetchInProgress() {
    return this.fetchInProgress;
  }

  isCommitInProgress() {
    return this.commitInProgress;
  }

  isCheckoutInProgress() {
    return this.checkoutInProgress;
  }

  setPushInProgress(value) {
    const oldValue = this.pushInProgress;
    this.pushInProgress = value;

    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setPullInProgress(value) {
    const oldValue = this.pullInProgress;
    this.pullInProgress = value;

    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setFetchInProgress(value) {
    const oldValue = this.fetchInProgress;
    this.fetchInProgress = value;

    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setCommitInProgress(value) {
    const oldValue = this.commitInProgress;
    this.commitInProgress = value;

    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setCheckoutInProgress(value) {
    const oldValue = this.checkoutInProgress;
    this.checkoutInProgress = value;

    if (oldValue !== value) {
      this.didUpdate();
    }
  }

}

exports.default = OperationStates;

class NullOperationStates extends OperationStates {
  setPushInProgress() {// do nothing
  }

  setPullInProgress() {// do nothing
  }

  setFetchInProgress() {// do nothing
  }

  setCommitInProgress() {// do nothing
  }

  setCheckoutInProgress() {// do nothing
  }

}

const nullOperationStates = new NullOperationStates();
exports.nullOperationStates = nullOperationStates;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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