"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Hunk {
  constructor({
    oldStartRow,
    newStartRow,
    oldRowCount,
    newRowCount,
    sectionHeading,
    marker,
    regions
  }) {
    this.oldStartRow = oldStartRow;
    this.newStartRow = newStartRow;
    this.oldRowCount = oldRowCount;
    this.newRowCount = newRowCount;
    this.sectionHeading = sectionHeading;
    this.marker = marker;
    this.regions = regions;
  }

  getOldStartRow() {
    return this.oldStartRow;
  }

  getNewStartRow() {
    return this.newStartRow;
  }

  getOldRowCount() {
    return this.oldRowCount;
  }

  getNewRowCount() {
    return this.newRowCount;
  }

  getHeader() {
    return `@@ -${this.oldStartRow},${this.oldRowCount} +${this.newStartRow},${this.newRowCount} @@`;
  }

  getSectionHeading() {
    return this.sectionHeading;
  }

  getRegions() {
    return this.regions;
  }

  getChanges() {
    return this.regions.filter(change => change.isChange());
  }

  getMarker() {
    return this.marker;
  }

  getRange() {
    return this.getMarker().getRange();
  }

  getBufferRows() {
    return this.getRange().getRows();
  }

  bufferRowCount() {
    return this.getRange().getRowCount();
  }

  includesBufferRow(row) {
    return this.getRange().intersectsRow(row);
  }

  getOldRowAt(row) {
    let current = this.oldStartRow;

    for (const region of this.getRegions()) {
      if (region.includesBufferRow(row)) {
        const offset = row - region.getStartBufferRow();
        return region.when({
          unchanged: () => current + offset,
          addition: () => null,
          deletion: () => current + offset,
          nonewline: () => null
        });
      } else {
        current += region.when({
          unchanged: () => region.bufferRowCount(),
          addition: () => 0,
          deletion: () => region.bufferRowCount(),
          nonewline: () => 0
        });
      }
    }

    return null;
  }

  getNewRowAt(row) {
    let current = this.newStartRow;

    for (const region of this.getRegions()) {
      if (region.includesBufferRow(row)) {
        const offset = row - region.getStartBufferRow();
        return region.when({
          unchanged: () => current + offset,
          addition: () => current + offset,
          deletion: () => null,
          nonewline: () => null
        });
      } else {
        current += region.when({
          unchanged: () => region.bufferRowCount(),
          addition: () => region.bufferRowCount(),
          deletion: () => 0,
          nonewline: () => 0
        });
      }
    }

    return null;
  }

  getMaxLineNumberWidth() {
    return Math.max((this.oldStartRow + this.oldRowCount).toString().length, (this.newStartRow + this.newRowCount).toString().length);
  }

  changedLineCount() {
    return this.regions.filter(region => region.isChange()).reduce((count, change) => count + change.bufferRowCount(), 0);
  }

  updateMarkers(map) {
    this.marker = map.get(this.marker) || this.marker;

    for (const region of this.regions) {
      region.updateMarkers(map);
    }
  }

  destroyMarkers() {
    this.marker.destroy();

    for (const region of this.regions) {
      region.destroyMarkers();
    }
  }

  toStringIn(buffer) {
    return this.getRegions().reduce((str, region) => str + region.toStringIn(buffer), this.getHeader() + '\n');
  }
  /*
   * Construct a String containing internal diagnostic information.
   */

  /* istanbul ignore next */


  inspect(opts = {}) {
    const options = _objectSpread2({
      indent: 0
    }, opts);

    let indentation = '';

    for (let i = 0; i < options.indent; i++) {
      indentation += ' ';
    }

    let inspectString = `${indentation}(Hunk marker=${this.marker.id}\n`;

    if (this.marker.isDestroyed()) {
      inspectString += ' [destroyed]';
    }

    if (!this.marker.isValid()) {
      inspectString += ' [invalid]';
    }

    for (const region of this.regions) {
      inspectString += region.inspect({
        indent: options.indent + 2
      });
    }

    inspectString += `${indentation})\n`;
    return inspectString;
  }

}

exports.default = Hunk;

_defineProperty(Hunk, "layerName", 'hunk');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh1bmsuanMiXSwibmFtZXMiOlsiSHVuayIsImNvbnN0cnVjdG9yIiwib2xkU3RhcnRSb3ciLCJuZXdTdGFydFJvdyIsIm9sZFJvd0NvdW50IiwibmV3Um93Q291bnQiLCJzZWN0aW9uSGVhZGluZyIsIm1hcmtlciIsInJlZ2lvbnMiLCJnZXRPbGRTdGFydFJvdyIsImdldE5ld1N0YXJ0Um93IiwiZ2V0T2xkUm93Q291bnQiLCJnZXROZXdSb3dDb3VudCIsImdldEhlYWRlciIsImdldFNlY3Rpb25IZWFkaW5nIiwiZ2V0UmVnaW9ucyIsImdldENoYW5nZXMiLCJmaWx0ZXIiLCJjaGFuZ2UiLCJpc0NoYW5nZSIsImdldE1hcmtlciIsImdldFJhbmdlIiwiZ2V0QnVmZmVyUm93cyIsImdldFJvd3MiLCJidWZmZXJSb3dDb3VudCIsImdldFJvd0NvdW50IiwiaW5jbHVkZXNCdWZmZXJSb3ciLCJyb3ciLCJpbnRlcnNlY3RzUm93IiwiZ2V0T2xkUm93QXQiLCJjdXJyZW50IiwicmVnaW9uIiwib2Zmc2V0IiwiZ2V0U3RhcnRCdWZmZXJSb3ciLCJ3aGVuIiwidW5jaGFuZ2VkIiwiYWRkaXRpb24iLCJkZWxldGlvbiIsIm5vbmV3bGluZSIsImdldE5ld1Jvd0F0IiwiZ2V0TWF4TGluZU51bWJlcldpZHRoIiwiTWF0aCIsIm1heCIsInRvU3RyaW5nIiwibGVuZ3RoIiwiY2hhbmdlZExpbmVDb3VudCIsInJlZHVjZSIsImNvdW50IiwidXBkYXRlTWFya2VycyIsIm1hcCIsImdldCIsImRlc3Ryb3lNYXJrZXJzIiwiZGVzdHJveSIsInRvU3RyaW5nSW4iLCJidWZmZXIiLCJzdHIiLCJpbnNwZWN0Iiwib3B0cyIsIm9wdGlvbnMiLCJpbmRlbnQiLCJpbmRlbnRhdGlvbiIsImkiLCJpbnNwZWN0U3RyaW5nIiwiaWQiLCJpc0Rlc3Ryb3llZCIsImlzVmFsaWQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7O0FBQWUsTUFBTUEsSUFBTixDQUFXO0FBR3hCQyxFQUFBQSxXQUFXLENBQUM7QUFDVkMsSUFBQUEsV0FEVTtBQUVWQyxJQUFBQSxXQUZVO0FBR1ZDLElBQUFBLFdBSFU7QUFJVkMsSUFBQUEsV0FKVTtBQUtWQyxJQUFBQSxjQUxVO0FBTVZDLElBQUFBLE1BTlU7QUFPVkMsSUFBQUE7QUFQVSxHQUFELEVBUVI7QUFDRCxTQUFLTixXQUFMLEdBQW1CQSxXQUFuQjtBQUNBLFNBQUtDLFdBQUwsR0FBbUJBLFdBQW5CO0FBQ0EsU0FBS0MsV0FBTCxHQUFtQkEsV0FBbkI7QUFDQSxTQUFLQyxXQUFMLEdBQW1CQSxXQUFuQjtBQUNBLFNBQUtDLGNBQUwsR0FBc0JBLGNBQXRCO0FBRUEsU0FBS0MsTUFBTCxHQUFjQSxNQUFkO0FBQ0EsU0FBS0MsT0FBTCxHQUFlQSxPQUFmO0FBQ0Q7O0FBRURDLEVBQUFBLGNBQWMsR0FBRztBQUNmLFdBQU8sS0FBS1AsV0FBWjtBQUNEOztBQUVEUSxFQUFBQSxjQUFjLEdBQUc7QUFDZixXQUFPLEtBQUtQLFdBQVo7QUFDRDs7QUFFRFEsRUFBQUEsY0FBYyxHQUFHO0FBQ2YsV0FBTyxLQUFLUCxXQUFaO0FBQ0Q7O0FBRURRLEVBQUFBLGNBQWMsR0FBRztBQUNmLFdBQU8sS0FBS1AsV0FBWjtBQUNEOztBQUVEUSxFQUFBQSxTQUFTLEdBQUc7QUFDVixXQUFRLE9BQU0sS0FBS1gsV0FBWSxJQUFHLEtBQUtFLFdBQVksS0FBSSxLQUFLRCxXQUFZLElBQUcsS0FBS0UsV0FBWSxLQUE1RjtBQUNEOztBQUVEUyxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQixXQUFPLEtBQUtSLGNBQVo7QUFDRDs7QUFFRFMsRUFBQUEsVUFBVSxHQUFHO0FBQ1gsV0FBTyxLQUFLUCxPQUFaO0FBQ0Q7O0FBRURRLEVBQUFBLFVBQVUsR0FBRztBQUNYLFdBQU8sS0FBS1IsT0FBTCxDQUFhUyxNQUFiLENBQW9CQyxNQUFNLElBQUlBLE1BQU0sQ0FBQ0MsUUFBUCxFQUE5QixDQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLFNBQVMsR0FBRztBQUNWLFdBQU8sS0FBS2IsTUFBWjtBQUNEOztBQUVEYyxFQUFBQSxRQUFRLEdBQUc7QUFDVCxXQUFPLEtBQUtELFNBQUwsR0FBaUJDLFFBQWpCLEVBQVA7QUFDRDs7QUFFREMsRUFBQUEsYUFBYSxHQUFHO0FBQ2QsV0FBTyxLQUFLRCxRQUFMLEdBQWdCRSxPQUFoQixFQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLGNBQWMsR0FBRztBQUNmLFdBQU8sS0FBS0gsUUFBTCxHQUFnQkksV0FBaEIsRUFBUDtBQUNEOztBQUVEQyxFQUFBQSxpQkFBaUIsQ0FBQ0MsR0FBRCxFQUFNO0FBQ3JCLFdBQU8sS0FBS04sUUFBTCxHQUFnQk8sYUFBaEIsQ0FBOEJELEdBQTlCLENBQVA7QUFDRDs7QUFFREUsRUFBQUEsV0FBVyxDQUFDRixHQUFELEVBQU07QUFDZixRQUFJRyxPQUFPLEdBQUcsS0FBSzVCLFdBQW5COztBQUVBLFNBQUssTUFBTTZCLE1BQVgsSUFBcUIsS0FBS2hCLFVBQUwsRUFBckIsRUFBd0M7QUFDdEMsVUFBSWdCLE1BQU0sQ0FBQ0wsaUJBQVAsQ0FBeUJDLEdBQXpCLENBQUosRUFBbUM7QUFDakMsY0FBTUssTUFBTSxHQUFHTCxHQUFHLEdBQUdJLE1BQU0sQ0FBQ0UsaUJBQVAsRUFBckI7QUFFQSxlQUFPRixNQUFNLENBQUNHLElBQVAsQ0FBWTtBQUNqQkMsVUFBQUEsU0FBUyxFQUFFLE1BQU1MLE9BQU8sR0FBR0UsTUFEVjtBQUVqQkksVUFBQUEsUUFBUSxFQUFFLE1BQU0sSUFGQztBQUdqQkMsVUFBQUEsUUFBUSxFQUFFLE1BQU1QLE9BQU8sR0FBR0UsTUFIVDtBQUlqQk0sVUFBQUEsU0FBUyxFQUFFLE1BQU07QUFKQSxTQUFaLENBQVA7QUFNRCxPQVRELE1BU087QUFDTFIsUUFBQUEsT0FBTyxJQUFJQyxNQUFNLENBQUNHLElBQVAsQ0FBWTtBQUNyQkMsVUFBQUEsU0FBUyxFQUFFLE1BQU1KLE1BQU0sQ0FBQ1AsY0FBUCxFQURJO0FBRXJCWSxVQUFBQSxRQUFRLEVBQUUsTUFBTSxDQUZLO0FBR3JCQyxVQUFBQSxRQUFRLEVBQUUsTUFBTU4sTUFBTSxDQUFDUCxjQUFQLEVBSEs7QUFJckJjLFVBQUFBLFNBQVMsRUFBRSxNQUFNO0FBSkksU0FBWixDQUFYO0FBTUQ7QUFDRjs7QUFFRCxXQUFPLElBQVA7QUFDRDs7QUFFREMsRUFBQUEsV0FBVyxDQUFDWixHQUFELEVBQU07QUFDZixRQUFJRyxPQUFPLEdBQUcsS0FBSzNCLFdBQW5COztBQUVBLFNBQUssTUFBTTRCLE1BQVgsSUFBcUIsS0FBS2hCLFVBQUwsRUFBckIsRUFBd0M7QUFDdEMsVUFBSWdCLE1BQU0sQ0FBQ0wsaUJBQVAsQ0FBeUJDLEdBQXpCLENBQUosRUFBbUM7QUFDakMsY0FBTUssTUFBTSxHQUFHTCxHQUFHLEdBQUdJLE1BQU0sQ0FBQ0UsaUJBQVAsRUFBckI7QUFFQSxlQUFPRixNQUFNLENBQUNHLElBQVAsQ0FBWTtBQUNqQkMsVUFBQUEsU0FBUyxFQUFFLE1BQU1MLE9BQU8sR0FBR0UsTUFEVjtBQUVqQkksVUFBQUEsUUFBUSxFQUFFLE1BQU1OLE9BQU8sR0FBR0UsTUFGVDtBQUdqQkssVUFBQUEsUUFBUSxFQUFFLE1BQU0sSUFIQztBQUlqQkMsVUFBQUEsU0FBUyxFQUFFLE1BQU07QUFKQSxTQUFaLENBQVA7QUFNRCxPQVRELE1BU087QUFDTFIsUUFBQUEsT0FBTyxJQUFJQyxNQUFNLENBQUNHLElBQVAsQ0FBWTtBQUNyQkMsVUFBQUEsU0FBUyxFQUFFLE1BQU1KLE1BQU0sQ0FBQ1AsY0FBUCxFQURJO0FBRXJCWSxVQUFBQSxRQUFRLEVBQUUsTUFBTUwsTUFBTSxDQUFDUCxjQUFQLEVBRks7QUFHckJhLFVBQUFBLFFBQVEsRUFBRSxNQUFNLENBSEs7QUFJckJDLFVBQUFBLFNBQVMsRUFBRSxNQUFNO0FBSkksU0FBWixDQUFYO0FBTUQ7QUFDRjs7QUFFRCxXQUFPLElBQVA7QUFDRDs7QUFFREUsRUFBQUEscUJBQXFCLEdBQUc7QUFDdEIsV0FBT0MsSUFBSSxDQUFDQyxHQUFMLENBQ0wsQ0FBQyxLQUFLeEMsV0FBTCxHQUFtQixLQUFLRSxXQUF6QixFQUFzQ3VDLFFBQXRDLEdBQWlEQyxNQUQ1QyxFQUVMLENBQUMsS0FBS3pDLFdBQUwsR0FBbUIsS0FBS0UsV0FBekIsRUFBc0NzQyxRQUF0QyxHQUFpREMsTUFGNUMsQ0FBUDtBQUlEOztBQUVEQyxFQUFBQSxnQkFBZ0IsR0FBRztBQUNqQixXQUFPLEtBQUtyQyxPQUFMLENBQ0pTLE1BREksQ0FDR2MsTUFBTSxJQUFJQSxNQUFNLENBQUNaLFFBQVAsRUFEYixFQUVKMkIsTUFGSSxDQUVHLENBQUNDLEtBQUQsRUFBUTdCLE1BQVIsS0FBbUI2QixLQUFLLEdBQUc3QixNQUFNLENBQUNNLGNBQVAsRUFGOUIsRUFFdUQsQ0FGdkQsQ0FBUDtBQUdEOztBQUVEd0IsRUFBQUEsYUFBYSxDQUFDQyxHQUFELEVBQU07QUFDakIsU0FBSzFDLE1BQUwsR0FBYzBDLEdBQUcsQ0FBQ0MsR0FBSixDQUFRLEtBQUszQyxNQUFiLEtBQXdCLEtBQUtBLE1BQTNDOztBQUNBLFNBQUssTUFBTXdCLE1BQVgsSUFBcUIsS0FBS3ZCLE9BQTFCLEVBQW1DO0FBQ2pDdUIsTUFBQUEsTUFBTSxDQUFDaUIsYUFBUCxDQUFxQkMsR0FBckI7QUFDRDtBQUNGOztBQUVERSxFQUFBQSxjQUFjLEdBQUc7QUFDZixTQUFLNUMsTUFBTCxDQUFZNkMsT0FBWjs7QUFDQSxTQUFLLE1BQU1yQixNQUFYLElBQXFCLEtBQUt2QixPQUExQixFQUFtQztBQUNqQ3VCLE1BQUFBLE1BQU0sQ0FBQ29CLGNBQVA7QUFDRDtBQUNGOztBQUVERSxFQUFBQSxVQUFVLENBQUNDLE1BQUQsRUFBUztBQUNqQixXQUFPLEtBQUt2QyxVQUFMLEdBQWtCK0IsTUFBbEIsQ0FBeUIsQ0FBQ1MsR0FBRCxFQUFNeEIsTUFBTixLQUFpQndCLEdBQUcsR0FBR3hCLE1BQU0sQ0FBQ3NCLFVBQVAsQ0FBa0JDLE1BQWxCLENBQWhELEVBQTJFLEtBQUt6QyxTQUFMLEtBQW1CLElBQTlGLENBQVA7QUFDRDtBQUVEOzs7O0FBR0E7OztBQUNBMkMsRUFBQUEsT0FBTyxDQUFDQyxJQUFJLEdBQUcsRUFBUixFQUFZO0FBQ2pCLFVBQU1DLE9BQU87QUFDWEMsTUFBQUEsTUFBTSxFQUFFO0FBREcsT0FFUkYsSUFGUSxDQUFiOztBQUtBLFFBQUlHLFdBQVcsR0FBRyxFQUFsQjs7QUFDQSxTQUFLLElBQUlDLENBQUMsR0FBRyxDQUFiLEVBQWdCQSxDQUFDLEdBQUdILE9BQU8sQ0FBQ0MsTUFBNUIsRUFBb0NFLENBQUMsRUFBckMsRUFBeUM7QUFDdkNELE1BQUFBLFdBQVcsSUFBSSxHQUFmO0FBQ0Q7O0FBRUQsUUFBSUUsYUFBYSxHQUFJLEdBQUVGLFdBQVksZ0JBQWUsS0FBS3JELE1BQUwsQ0FBWXdELEVBQUcsSUFBakU7O0FBQ0EsUUFBSSxLQUFLeEQsTUFBTCxDQUFZeUQsV0FBWixFQUFKLEVBQStCO0FBQzdCRixNQUFBQSxhQUFhLElBQUksY0FBakI7QUFDRDs7QUFDRCxRQUFJLENBQUMsS0FBS3ZELE1BQUwsQ0FBWTBELE9BQVosRUFBTCxFQUE0QjtBQUMxQkgsTUFBQUEsYUFBYSxJQUFJLFlBQWpCO0FBQ0Q7O0FBQ0QsU0FBSyxNQUFNL0IsTUFBWCxJQUFxQixLQUFLdkIsT0FBMUIsRUFBbUM7QUFDakNzRCxNQUFBQSxhQUFhLElBQUkvQixNQUFNLENBQUN5QixPQUFQLENBQWU7QUFBQ0csUUFBQUEsTUFBTSxFQUFFRCxPQUFPLENBQUNDLE1BQVIsR0FBaUI7QUFBMUIsT0FBZixDQUFqQjtBQUNEOztBQUNERyxJQUFBQSxhQUFhLElBQUssR0FBRUYsV0FBWSxLQUFoQztBQUNBLFdBQU9FLGFBQVA7QUFDRDs7QUF4THVCOzs7O2dCQUFMOUQsSSxlQUNBLE0iLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgY2xhc3MgSHVuayB7XG4gIHN0YXRpYyBsYXllck5hbWUgPSAnaHVuayc7XG5cbiAgY29uc3RydWN0b3Ioe1xuICAgIG9sZFN0YXJ0Um93LFxuICAgIG5ld1N0YXJ0Um93LFxuICAgIG9sZFJvd0NvdW50LFxuICAgIG5ld1Jvd0NvdW50LFxuICAgIHNlY3Rpb25IZWFkaW5nLFxuICAgIG1hcmtlcixcbiAgICByZWdpb25zLFxuICB9KSB7XG4gICAgdGhpcy5vbGRTdGFydFJvdyA9IG9sZFN0YXJ0Um93O1xuICAgIHRoaXMubmV3U3RhcnRSb3cgPSBuZXdTdGFydFJvdztcbiAgICB0aGlzLm9sZFJvd0NvdW50ID0gb2xkUm93Q291bnQ7XG4gICAgdGhpcy5uZXdSb3dDb3VudCA9IG5ld1Jvd0NvdW50O1xuICAgIHRoaXMuc2VjdGlvbkhlYWRpbmcgPSBzZWN0aW9uSGVhZGluZztcblxuICAgIHRoaXMubWFya2VyID0gbWFya2VyO1xuICAgIHRoaXMucmVnaW9ucyA9IHJlZ2lvbnM7XG4gIH1cblxuICBnZXRPbGRTdGFydFJvdygpIHtcbiAgICByZXR1cm4gdGhpcy5vbGRTdGFydFJvdztcbiAgfVxuXG4gIGdldE5ld1N0YXJ0Um93KCkge1xuICAgIHJldHVybiB0aGlzLm5ld1N0YXJ0Um93O1xuICB9XG5cbiAgZ2V0T2xkUm93Q291bnQoKSB7XG4gICAgcmV0dXJuIHRoaXMub2xkUm93Q291bnQ7XG4gIH1cblxuICBnZXROZXdSb3dDb3VudCgpIHtcbiAgICByZXR1cm4gdGhpcy5uZXdSb3dDb3VudDtcbiAgfVxuXG4gIGdldEhlYWRlcigpIHtcbiAgICByZXR1cm4gYEBAIC0ke3RoaXMub2xkU3RhcnRSb3d9LCR7dGhpcy5vbGRSb3dDb3VudH0gKyR7dGhpcy5uZXdTdGFydFJvd30sJHt0aGlzLm5ld1Jvd0NvdW50fSBAQGA7XG4gIH1cblxuICBnZXRTZWN0aW9uSGVhZGluZygpIHtcbiAgICByZXR1cm4gdGhpcy5zZWN0aW9uSGVhZGluZztcbiAgfVxuXG4gIGdldFJlZ2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMucmVnaW9ucztcbiAgfVxuXG4gIGdldENoYW5nZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMucmVnaW9ucy5maWx0ZXIoY2hhbmdlID0+IGNoYW5nZS5pc0NoYW5nZSgpKTtcbiAgfVxuXG4gIGdldE1hcmtlcigpIHtcbiAgICByZXR1cm4gdGhpcy5tYXJrZXI7XG4gIH1cblxuICBnZXRSYW5nZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRNYXJrZXIoKS5nZXRSYW5nZSgpO1xuICB9XG5cbiAgZ2V0QnVmZmVyUm93cygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRSYW5nZSgpLmdldFJvd3MoKTtcbiAgfVxuXG4gIGJ1ZmZlclJvd0NvdW50KCkge1xuICAgIHJldHVybiB0aGlzLmdldFJhbmdlKCkuZ2V0Um93Q291bnQoKTtcbiAgfVxuXG4gIGluY2x1ZGVzQnVmZmVyUm93KHJvdykge1xuICAgIHJldHVybiB0aGlzLmdldFJhbmdlKCkuaW50ZXJzZWN0c1Jvdyhyb3cpO1xuICB9XG5cbiAgZ2V0T2xkUm93QXQocm93KSB7XG4gICAgbGV0IGN1cnJlbnQgPSB0aGlzLm9sZFN0YXJ0Um93O1xuXG4gICAgZm9yIChjb25zdCByZWdpb24gb2YgdGhpcy5nZXRSZWdpb25zKCkpIHtcbiAgICAgIGlmIChyZWdpb24uaW5jbHVkZXNCdWZmZXJSb3cocm93KSkge1xuICAgICAgICBjb25zdCBvZmZzZXQgPSByb3cgLSByZWdpb24uZ2V0U3RhcnRCdWZmZXJSb3coKTtcblxuICAgICAgICByZXR1cm4gcmVnaW9uLndoZW4oe1xuICAgICAgICAgIHVuY2hhbmdlZDogKCkgPT4gY3VycmVudCArIG9mZnNldCxcbiAgICAgICAgICBhZGRpdGlvbjogKCkgPT4gbnVsbCxcbiAgICAgICAgICBkZWxldGlvbjogKCkgPT4gY3VycmVudCArIG9mZnNldCxcbiAgICAgICAgICBub25ld2xpbmU6ICgpID0+IG51bGwsXG4gICAgICAgIH0pO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgY3VycmVudCArPSByZWdpb24ud2hlbih7XG4gICAgICAgICAgdW5jaGFuZ2VkOiAoKSA9PiByZWdpb24uYnVmZmVyUm93Q291bnQoKSxcbiAgICAgICAgICBhZGRpdGlvbjogKCkgPT4gMCxcbiAgICAgICAgICBkZWxldGlvbjogKCkgPT4gcmVnaW9uLmJ1ZmZlclJvd0NvdW50KCksXG4gICAgICAgICAgbm9uZXdsaW5lOiAoKSA9PiAwLFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuXG4gIGdldE5ld1Jvd0F0KHJvdykge1xuICAgIGxldCBjdXJyZW50ID0gdGhpcy5uZXdTdGFydFJvdztcblxuICAgIGZvciAoY29uc3QgcmVnaW9uIG9mIHRoaXMuZ2V0UmVnaW9ucygpKSB7XG4gICAgICBpZiAocmVnaW9uLmluY2x1ZGVzQnVmZmVyUm93KHJvdykpIHtcbiAgICAgICAgY29uc3Qgb2Zmc2V0ID0gcm93IC0gcmVnaW9uLmdldFN0YXJ0QnVmZmVyUm93KCk7XG5cbiAgICAgICAgcmV0dXJuIHJlZ2lvbi53aGVuKHtcbiAgICAgICAgICB1bmNoYW5nZWQ6ICgpID0+IGN1cnJlbnQgKyBvZmZzZXQsXG4gICAgICAgICAgYWRkaXRpb246ICgpID0+IGN1cnJlbnQgKyBvZmZzZXQsXG4gICAgICAgICAgZGVsZXRpb246ICgpID0+IG51bGwsXG4gICAgICAgICAgbm9uZXdsaW5lOiAoKSA9PiBudWxsLFxuICAgICAgICB9KTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIGN1cnJlbnQgKz0gcmVnaW9uLndoZW4oe1xuICAgICAgICAgIHVuY2hhbmdlZDogKCkgPT4gcmVnaW9uLmJ1ZmZlclJvd0NvdW50KCksXG4gICAgICAgICAgYWRkaXRpb246ICgpID0+IHJlZ2lvbi5idWZmZXJSb3dDb3VudCgpLFxuICAgICAgICAgIGRlbGV0aW9uOiAoKSA9PiAwLFxuICAgICAgICAgIG5vbmV3bGluZTogKCkgPT4gMCxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIG51bGw7XG4gIH1cblxuICBnZXRNYXhMaW5lTnVtYmVyV2lkdGgoKSB7XG4gICAgcmV0dXJuIE1hdGgubWF4KFxuICAgICAgKHRoaXMub2xkU3RhcnRSb3cgKyB0aGlzLm9sZFJvd0NvdW50KS50b1N0cmluZygpLmxlbmd0aCxcbiAgICAgICh0aGlzLm5ld1N0YXJ0Um93ICsgdGhpcy5uZXdSb3dDb3VudCkudG9TdHJpbmcoKS5sZW5ndGgsXG4gICAgKTtcbiAgfVxuXG4gIGNoYW5nZWRMaW5lQ291bnQoKSB7XG4gICAgcmV0dXJuIHRoaXMucmVnaW9uc1xuICAgICAgLmZpbHRlcihyZWdpb24gPT4gcmVnaW9uLmlzQ2hhbmdlKCkpXG4gICAgICAucmVkdWNlKChjb3VudCwgY2hhbmdlKSA9PiBjb3VudCArIGNoYW5nZS5idWZmZXJSb3dDb3VudCgpLCAwKTtcbiAgfVxuXG4gIHVwZGF0ZU1hcmtlcnMobWFwKSB7XG4gICAgdGhpcy5tYXJrZXIgPSBtYXAuZ2V0KHRoaXMubWFya2VyKSB8fCB0aGlzLm1hcmtlcjtcbiAgICBmb3IgKGNvbnN0IHJlZ2lvbiBvZiB0aGlzLnJlZ2lvbnMpIHtcbiAgICAgIHJlZ2lvbi51cGRhdGVNYXJrZXJzKG1hcCk7XG4gICAgfVxuICB9XG5cbiAgZGVzdHJveU1hcmtlcnMoKSB7XG4gICAgdGhpcy5tYXJrZXIuZGVzdHJveSgpO1xuICAgIGZvciAoY29uc3QgcmVnaW9uIG9mIHRoaXMucmVnaW9ucykge1xuICAgICAgcmVnaW9uLmRlc3Ryb3lNYXJrZXJzKCk7XG4gICAgfVxuICB9XG5cbiAgdG9TdHJpbmdJbihidWZmZXIpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRSZWdpb25zKCkucmVkdWNlKChzdHIsIHJlZ2lvbikgPT4gc3RyICsgcmVnaW9uLnRvU3RyaW5nSW4oYnVmZmVyKSwgdGhpcy5nZXRIZWFkZXIoKSArICdcXG4nKTtcbiAgfVxuXG4gIC8qXG4gICAqIENvbnN0cnVjdCBhIFN0cmluZyBjb250YWluaW5nIGludGVybmFsIGRpYWdub3N0aWMgaW5mb3JtYXRpb24uXG4gICAqL1xuICAvKiBpc3RhbmJ1bCBpZ25vcmUgbmV4dCAqL1xuICBpbnNwZWN0KG9wdHMgPSB7fSkge1xuICAgIGNvbnN0IG9wdGlvbnMgPSB7XG4gICAgICBpbmRlbnQ6IDAsXG4gICAgICAuLi5vcHRzLFxuICAgIH07XG5cbiAgICBsZXQgaW5kZW50YXRpb24gPSAnJztcbiAgICBmb3IgKGxldCBpID0gMDsgaSA8IG9wdGlvbnMuaW5kZW50OyBpKyspIHtcbiAgICAgIGluZGVudGF0aW9uICs9ICcgJztcbiAgICB9XG5cbiAgICBsZXQgaW5zcGVjdFN0cmluZyA9IGAke2luZGVudGF0aW9ufShIdW5rIG1hcmtlcj0ke3RoaXMubWFya2VyLmlkfVxcbmA7XG4gICAgaWYgKHRoaXMubWFya2VyLmlzRGVzdHJveWVkKCkpIHtcbiAgICAgIGluc3BlY3RTdHJpbmcgKz0gJyBbZGVzdHJveWVkXSc7XG4gICAgfVxuICAgIGlmICghdGhpcy5tYXJrZXIuaXNWYWxpZCgpKSB7XG4gICAgICBpbnNwZWN0U3RyaW5nICs9ICcgW2ludmFsaWRdJztcbiAgICB9XG4gICAgZm9yIChjb25zdCByZWdpb24gb2YgdGhpcy5yZWdpb25zKSB7XG4gICAgICBpbnNwZWN0U3RyaW5nICs9IHJlZ2lvbi5pbnNwZWN0KHtpbmRlbnQ6IG9wdGlvbnMuaW5kZW50ICsgMn0pO1xuICAgIH1cbiAgICBpbnNwZWN0U3RyaW5nICs9IGAke2luZGVudGF0aW9ufSlcXG5gO1xuICAgIHJldHVybiBpbnNwZWN0U3RyaW5nO1xuICB9XG59XG4iXX0=