"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/**
 * Uniformly trigger a refetch of all GraphQL query containers within a scoped hierarchy.
 */
class Refresher {
  constructor() {
    this.dispose();
  }

  setRetryCallback(key, retryCallback) {
    this.retryByKey.set(key, retryCallback);
  }

  trigger() {
    for (const [, retryCallback] of this.retryByKey) {
      retryCallback();
    }
  }

  deregister(key) {
    this.retryByKey.delete(key);
  }

  dispose() {
    this.retryByKey = new Map();
  }

}

exports.default = Refresher;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJlZnJlc2hlci5qcyJdLCJuYW1lcyI6WyJSZWZyZXNoZXIiLCJjb25zdHJ1Y3RvciIsImRpc3Bvc2UiLCJzZXRSZXRyeUNhbGxiYWNrIiwia2V5IiwicmV0cnlDYWxsYmFjayIsInJldHJ5QnlLZXkiLCJzZXQiLCJ0cmlnZ2VyIiwiZGVyZWdpc3RlciIsImRlbGV0ZSIsIk1hcCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7QUFHZSxNQUFNQSxTQUFOLENBQWdCO0FBQzdCQyxFQUFBQSxXQUFXLEdBQUc7QUFDWixTQUFLQyxPQUFMO0FBQ0Q7O0FBRURDLEVBQUFBLGdCQUFnQixDQUFDQyxHQUFELEVBQU1DLGFBQU4sRUFBcUI7QUFDbkMsU0FBS0MsVUFBTCxDQUFnQkMsR0FBaEIsQ0FBb0JILEdBQXBCLEVBQXlCQyxhQUF6QjtBQUNEOztBQUVERyxFQUFBQSxPQUFPLEdBQUc7QUFDUixTQUFLLE1BQU0sR0FBR0gsYUFBSCxDQUFYLElBQWdDLEtBQUtDLFVBQXJDLEVBQWlEO0FBQy9DRCxNQUFBQSxhQUFhO0FBQ2Q7QUFDRjs7QUFFREksRUFBQUEsVUFBVSxDQUFDTCxHQUFELEVBQU07QUFDZCxTQUFLRSxVQUFMLENBQWdCSSxNQUFoQixDQUF1Qk4sR0FBdkI7QUFDRDs7QUFFREYsRUFBQUEsT0FBTyxHQUFHO0FBQ1IsU0FBS0ksVUFBTCxHQUFrQixJQUFJSyxHQUFKLEVBQWxCO0FBQ0Q7O0FBckI0QiIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFVuaWZvcm1seSB0cmlnZ2VyIGEgcmVmZXRjaCBvZiBhbGwgR3JhcGhRTCBxdWVyeSBjb250YWluZXJzIHdpdGhpbiBhIHNjb3BlZCBoaWVyYXJjaHkuXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFJlZnJlc2hlciB7XG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIHRoaXMuZGlzcG9zZSgpO1xuICB9XG5cbiAgc2V0UmV0cnlDYWxsYmFjayhrZXksIHJldHJ5Q2FsbGJhY2spIHtcbiAgICB0aGlzLnJldHJ5QnlLZXkuc2V0KGtleSwgcmV0cnlDYWxsYmFjayk7XG4gIH1cblxuICB0cmlnZ2VyKCkge1xuICAgIGZvciAoY29uc3QgWywgcmV0cnlDYWxsYmFja10gb2YgdGhpcy5yZXRyeUJ5S2V5KSB7XG4gICAgICByZXRyeUNhbGxiYWNrKCk7XG4gICAgfVxuICB9XG5cbiAgZGVyZWdpc3RlcihrZXkpIHtcbiAgICB0aGlzLnJldHJ5QnlLZXkuZGVsZXRlKGtleSk7XG4gIH1cblxuICBkaXNwb3NlKCkge1xuICAgIHRoaXMucmV0cnlCeUtleSA9IG5ldyBNYXAoKTtcbiAgfVxufVxuIl19