"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Git is asynchronously cloning a repository into this working directory.
 */
class Cloning extends _state.default {
  constructor(repository, remoteUrl, sourceRemoteName) {
    super(repository);
    this.remoteUrl = remoteUrl;
    this.sourceRemoteName = sourceRemoteName;
  }

  async start() {
    await _fsExtra.default.mkdirs(this.workdir());
    await this.doClone(this.remoteUrl, {
      recursive: true,
      sourceRemoteName: this.sourceRemoteName
    });
    await this.transitionTo('Loading');
  }

  showGitTabLoading() {
    return true;
  }

  directClone(remoteUrl, options) {
    return this.git().clone(remoteUrl, options);
  }

}

exports.default = Cloning;

_state.default.register(Cloning);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNsb25pbmcuanMiXSwibmFtZXMiOlsiQ2xvbmluZyIsIlN0YXRlIiwiY29uc3RydWN0b3IiLCJyZXBvc2l0b3J5IiwicmVtb3RlVXJsIiwic291cmNlUmVtb3RlTmFtZSIsInN0YXJ0IiwiZnMiLCJta2RpcnMiLCJ3b3JrZGlyIiwiZG9DbG9uZSIsInJlY3Vyc2l2ZSIsInRyYW5zaXRpb25UbyIsInNob3dHaXRUYWJMb2FkaW5nIiwiZGlyZWN0Q2xvbmUiLCJvcHRpb25zIiwiZ2l0IiwiY2xvbmUiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUVBOzs7O0FBRUE7OztBQUdlLE1BQU1BLE9BQU4sU0FBc0JDLGNBQXRCLENBQTRCO0FBQ3pDQyxFQUFBQSxXQUFXLENBQUNDLFVBQUQsRUFBYUMsU0FBYixFQUF3QkMsZ0JBQXhCLEVBQTBDO0FBQ25ELFVBQU1GLFVBQU47QUFDQSxTQUFLQyxTQUFMLEdBQWlCQSxTQUFqQjtBQUNBLFNBQUtDLGdCQUFMLEdBQXdCQSxnQkFBeEI7QUFDRDs7QUFFRCxRQUFNQyxLQUFOLEdBQWM7QUFDWixVQUFNQyxpQkFBR0MsTUFBSCxDQUFVLEtBQUtDLE9BQUwsRUFBVixDQUFOO0FBQ0EsVUFBTSxLQUFLQyxPQUFMLENBQWEsS0FBS04sU0FBbEIsRUFBNkI7QUFBQ08sTUFBQUEsU0FBUyxFQUFFLElBQVo7QUFBa0JOLE1BQUFBLGdCQUFnQixFQUFFLEtBQUtBO0FBQXpDLEtBQTdCLENBQU47QUFFQSxVQUFNLEtBQUtPLFlBQUwsQ0FBa0IsU0FBbEIsQ0FBTjtBQUNEOztBQUVEQyxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQixXQUFPLElBQVA7QUFDRDs7QUFFREMsRUFBQUEsV0FBVyxDQUFDVixTQUFELEVBQVlXLE9BQVosRUFBcUI7QUFDOUIsV0FBTyxLQUFLQyxHQUFMLEdBQVdDLEtBQVgsQ0FBaUJiLFNBQWpCLEVBQTRCVyxPQUE1QixDQUFQO0FBQ0Q7O0FBcEJ3Qzs7OztBQXVCM0NkLGVBQU1pQixRQUFOLENBQWVsQixPQUFmIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBmcyBmcm9tICdmcy1leHRyYSc7XG5cbmltcG9ydCBTdGF0ZSBmcm9tICcuL3N0YXRlJztcblxuLyoqXG4gKiBHaXQgaXMgYXN5bmNocm9ub3VzbHkgY2xvbmluZyBhIHJlcG9zaXRvcnkgaW50byB0aGlzIHdvcmtpbmcgZGlyZWN0b3J5LlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBDbG9uaW5nIGV4dGVuZHMgU3RhdGUge1xuICBjb25zdHJ1Y3RvcihyZXBvc2l0b3J5LCByZW1vdGVVcmwsIHNvdXJjZVJlbW90ZU5hbWUpIHtcbiAgICBzdXBlcihyZXBvc2l0b3J5KTtcbiAgICB0aGlzLnJlbW90ZVVybCA9IHJlbW90ZVVybDtcbiAgICB0aGlzLnNvdXJjZVJlbW90ZU5hbWUgPSBzb3VyY2VSZW1vdGVOYW1lO1xuICB9XG5cbiAgYXN5bmMgc3RhcnQoKSB7XG4gICAgYXdhaXQgZnMubWtkaXJzKHRoaXMud29ya2RpcigpKTtcbiAgICBhd2FpdCB0aGlzLmRvQ2xvbmUodGhpcy5yZW1vdGVVcmwsIHtyZWN1cnNpdmU6IHRydWUsIHNvdXJjZVJlbW90ZU5hbWU6IHRoaXMuc291cmNlUmVtb3RlTmFtZX0pO1xuXG4gICAgYXdhaXQgdGhpcy50cmFuc2l0aW9uVG8oJ0xvYWRpbmcnKTtcbiAgfVxuXG4gIHNob3dHaXRUYWJMb2FkaW5nKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgZGlyZWN0Q2xvbmUocmVtb3RlVXJsLCBvcHRpb25zKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2l0KCkuY2xvbmUocmVtb3RlVXJsLCBvcHRpb25zKTtcbiAgfVxufVxuXG5TdGF0ZS5yZWdpc3RlcihDbG9uaW5nKTtcbiJdfQ==