"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Initial state to be used when it's uncertain whether or not a git repository is present in a working directory. If
 * it is a git repository, transition to Present, otherwise transition to Empty.
 */
class Loading extends _state.default {
  async start() {
    const dotGitDir = await this.resolveDotGitDir();

    if (dotGitDir) {
      this.repository.setGitDirectoryPath(dotGitDir);
      const history = await this.loadHistoryPayload();
      return this.transitionTo('Present', history);
    } else {
      return this.transitionTo('Empty');
    }
  }

  isLoading() {
    return true;
  }

  async init() {
    await this.getLoadPromise();
    await this.repository.init();
  }

  async clone(remoteUrl) {
    await this.getLoadPromise();
    await this.repository.clone(remoteUrl);
  }

  showGitTabLoading() {
    return true;
  }

  directResolveDotGitDir() {
    return this.git().resolveDotGitDir();
  }

  directGetConfig(key, options) {
    return this.git().getConfig(key, options);
  }

  directGetBlobContents(sha) {
    return this.git().getBlobContents(sha);
  }

}

exports.default = Loading;

_state.default.register(Loading);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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