"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nullSearch = exports.default = void 0;

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const NULL = Symbol('null');
const CREATE_ON_EMPTY = Symbol('create on empty');

class Search {
  constructor(name, query, attrs = {}) {
    this.name = name;
    this.query = query;
    this.attrs = attrs;
  }

  getName() {
    return this.name;
  }

  createQuery() {
    return this.query;
  } // A null search has insufficient information to construct a canned query, so it should always return no results.


  isNull() {
    return this.attrs[NULL] || false;
  }

  showCreateOnEmpty() {
    return this.attrs[CREATE_ON_EMPTY] || false;
  }

  getWebURL(remote) {
    if (!remote.isGithubRepo()) {
      throw new Error(`Attempt to generate web URL for non-GitHub remote ${remote.getName()}`);
    }

    return `https://${remote.getDomain()}/search?q=${encodeURIComponent(this.createQuery())}`;
  }

  static inRemote(remote, name, query, attrs = {}) {
    if (!remote.isGithubRepo()) {
      return new this(name, '', _objectSpread2({}, attrs, {
        [NULL]: true
      }));
    }

    return new this(name, `repo:${remote.getOwner()}/${remote.getRepo()} ${query.trim()}`, attrs);
  }

}

exports.default = Search;
const nullSearch = new Search('', '', {
  [NULL]: true
});
exports.nullSearch = nullSearch;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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