"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

class StyleCalculator {
  constructor(styles, config) {
    (0, _helpers.autobind)(this, 'updateStyles');
    this.styles = styles;
    this.config = config;
  }

  startWatching(sourcePath, configsToWatch, getStylesheetFn) {
    const subscriptions = new _eventKit.CompositeDisposable();

    const updateStyles = () => {
      this.updateStyles(sourcePath, getStylesheetFn);
    };

    configsToWatch.forEach(configToWatch => {
      subscriptions.add(this.config.onDidChange(configToWatch, updateStyles));
    });
    updateStyles();
    return subscriptions;
  }

  updateStyles(sourcePath, getStylesheetFn) {
    const stylesheet = getStylesheetFn(this.config);
    this.styles.addStyleSheet(stylesheet, {
      sourcePath,
      priority: 0
    });
  }

}

exports.default = StyleCalculator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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