"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _reactRelay = require("react-relay");

var _relayRuntime = require("relay-runtime");

var _moment = _interopRequireDefault(require("moment"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/addPrReviewCommentMutation.graphql");

  if (node.hash && node.hash !== "0485900371928de8c6b843560dfe441c") {
    console.error("The definition of 'addPrReviewCommentMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/addPrReviewCommentMutation.graphql");
};

let placeholderID = 0;

var _default = (environment, {
  body,
  inReplyTo,
  reviewID,
  threadID,
  viewerID,
  path,
  position
}) => {
  const variables = {
    input: {
      body,
      inReplyTo,
      pullRequestReviewId: reviewID
    }
  };
  const configs = [{
    type: 'RANGE_ADD',
    parentID: threadID,
    connectionInfo: [{
      key: 'ReviewCommentsAccumulator_comments',
      rangeBehavior: 'append'
    }],
    edgeName: 'commentEdge'
  }];

  function optimisticUpdater(store) {
    const reviewThread = store.get(threadID);

    if (!reviewThread) {
      return;
    }

    const id = `add-pr-review-comment:comment:${placeholderID++}`;
    const comment = store.create(id, 'PullRequestReviewComment');
    comment.setValue(id, 'id');
    comment.setValue(body, 'body');
    comment.setValue((0, _helpers.renderMarkdown)(body), 'bodyHTML');
    comment.setValue(false, 'isMinimized');
    comment.setValue(false, 'viewerCanMinimize');
    comment.setValue(false, 'viewerCanReact');
    comment.setValue(false, 'viewerCanUpdate');
    comment.setValue((0, _moment.default)().toISOString(), 'createdAt');
    comment.setValue(null, 'lastEditedAt');
    comment.setValue('NONE', 'authorAssociation');
    comment.setValue('https://github.com', 'url');
    comment.setValue(path, 'path');
    comment.setValue(position, 'position');
    comment.setLinkedRecords([], 'reactionGroups');
    let author;

    if (viewerID) {
      author = store.get(viewerID);
    } else {
      author = store.create(`add-pr-review-comment:author:${placeholderID++}`, 'User');
      author.setValue('...', 'login');
      author.setValue('atom://github/img/avatar.svg', 'avatarUrl');
    }

    comment.setLinkedRecord(author, 'author');

    const comments = _relayRuntime.ConnectionHandler.getConnection(reviewThread, 'ReviewCommentsAccumulator_comments');

    const edge = _relayRuntime.ConnectionHandler.createEdge(store, comments, comment, 'PullRequestReviewCommentEdge');

    _relayRuntime.ConnectionHandler.insertEdgeAfter(comments, edge);
  }

  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      configs,
      optimisticUpdater,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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