"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _reactRelay = require("react-relay");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/deletePrReviewMutation.graphql");

  if (node.hash && node.hash !== "768b81334e225cb5d15c0508d2bd4b1f") {
    console.error("The definition of 'deletePrReviewMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/deletePrReviewMutation.graphql");
};

var _default = (environment, {
  reviewID,
  pullRequestID
}) => {
  const variables = {
    input: {
      pullRequestReviewId: reviewID
    }
  };
  const configs = [{
    type: 'NODE_DELETE',
    deletedIDFieldName: 'id'
  }, {
    type: 'RANGE_DELETE',
    parentID: pullRequestID,
    connectionKeys: [{
      key: 'ReviewSummariesAccumulator_reviews'
    }],
    pathToConnection: ['pullRequest', 'reviews'],
    deletedIDFieldName: 'id'
  }];
  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      configs,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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