"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _reactRelay = require("react-relay");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/unresolveReviewThreadMutation.graphql");

  if (node.hash && node.hash !== "8b1105e1a3db0455c522c7e5dc69b436") {
    console.error("The definition of 'unresolveReviewThreadMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/unresolveReviewThreadMutation.graphql");
};

var _default = (environment, {
  threadID,
  viewerID,
  viewerLogin
}) => {
  const variables = {
    input: {
      threadId: threadID
    }
  };
  const optimisticResponse = {
    unresolveReviewThread: {
      thread: {
        id: threadID,
        isResolved: false,
        viewerCanResolve: true,
        viewerCanUnresolve: false,
        resolvedBy: {
          id: viewerID,
          login: viewerLogin || 'you'
        }
      }
    }
  };
  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticResponse,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInVucmVzb2x2ZS1yZXZpZXctdGhyZWFkLmpzIl0sIm5hbWVzIjpbIm11dGF0aW9uIiwiZW52aXJvbm1lbnQiLCJ0aHJlYWRJRCIsInZpZXdlcklEIiwidmlld2VyTG9naW4iLCJ2YXJpYWJsZXMiLCJpbnB1dCIsInRocmVhZElkIiwib3B0aW1pc3RpY1Jlc3BvbnNlIiwidW5yZXNvbHZlUmV2aWV3VGhyZWFkIiwidGhyZWFkIiwiaWQiLCJpc1Jlc29sdmVkIiwidmlld2VyQ2FuUmVzb2x2ZSIsInZpZXdlckNhblVucmVzb2x2ZSIsInJlc29sdmVkQnkiLCJsb2dpbiIsIlByb21pc2UiLCJyZXNvbHZlIiwicmVqZWN0Iiwib25Db21wbGV0ZWQiLCJvbkVycm9yIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBRUE7O0FBRkE7QUFJQSxNQUFNQSxRQUFRO0FBQUE7O0FBQUE7QUFBQTtBQUFBOztBQUFBO0FBQUEsQ0FBZDs7ZUFpQmUsQ0FBQ0MsV0FBRCxFQUFjO0FBQUNDLEVBQUFBLFFBQUQ7QUFBV0MsRUFBQUEsUUFBWDtBQUFxQkMsRUFBQUE7QUFBckIsQ0FBZCxLQUFvRDtBQUNqRSxRQUFNQyxTQUFTLEdBQUc7QUFDaEJDLElBQUFBLEtBQUssRUFBRTtBQUNMQyxNQUFBQSxRQUFRLEVBQUVMO0FBREw7QUFEUyxHQUFsQjtBQU1BLFFBQU1NLGtCQUFrQixHQUFHO0FBQ3pCQyxJQUFBQSxxQkFBcUIsRUFBRTtBQUNyQkMsTUFBQUEsTUFBTSxFQUFFO0FBQ05DLFFBQUFBLEVBQUUsRUFBRVQsUUFERTtBQUVOVSxRQUFBQSxVQUFVLEVBQUUsS0FGTjtBQUdOQyxRQUFBQSxnQkFBZ0IsRUFBRSxJQUhaO0FBSU5DLFFBQUFBLGtCQUFrQixFQUFFLEtBSmQ7QUFLTkMsUUFBQUEsVUFBVSxFQUFFO0FBQ1ZKLFVBQUFBLEVBQUUsRUFBRVIsUUFETTtBQUVWYSxVQUFBQSxLQUFLLEVBQUVaLFdBQVcsSUFBSTtBQUZaO0FBTE47QUFEYTtBQURFLEdBQTNCO0FBZUEsU0FBTyxJQUFJYSxPQUFKLENBQVksQ0FBQ0MsT0FBRCxFQUFVQyxNQUFWLEtBQXFCO0FBQ3RDLG9DQUNFbEIsV0FERixFQUVFO0FBQ0VELE1BQUFBLFFBREY7QUFFRUssTUFBQUEsU0FGRjtBQUdFRyxNQUFBQSxrQkFIRjtBQUlFWSxNQUFBQSxXQUFXLEVBQUVGLE9BSmY7QUFLRUcsTUFBQUEsT0FBTyxFQUFFRjtBQUxYLEtBRkY7QUFVRCxHQVhNLENBQVA7QUFZRCxDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbIi8qIGlzdGFuYnVsIGlnbm9yZSBmaWxlICovXG5cbmltcG9ydCB7Y29tbWl0TXV0YXRpb24sIGdyYXBocWx9IGZyb20gJ3JlYWN0LXJlbGF5JztcblxuY29uc3QgbXV0YXRpb24gPSBncmFwaHFsYFxuICBtdXRhdGlvbiB1bnJlc29sdmVSZXZpZXdUaHJlYWRNdXRhdGlvbigkaW5wdXQ6IFVucmVzb2x2ZVJldmlld1RocmVhZElucHV0ISkge1xuICAgIHVucmVzb2x2ZVJldmlld1RocmVhZChpbnB1dDogJGlucHV0KSB7XG4gICAgICB0aHJlYWQge1xuICAgICAgICBpZFxuICAgICAgICBpc1Jlc29sdmVkXG4gICAgICAgIHZpZXdlckNhblJlc29sdmVcbiAgICAgICAgdmlld2VyQ2FuVW5yZXNvbHZlXG4gICAgICAgIHJlc29sdmVkQnkge1xuICAgICAgICAgIGlkXG4gICAgICAgICAgbG9naW5cbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxuYDtcblxuZXhwb3J0IGRlZmF1bHQgKGVudmlyb25tZW50LCB7dGhyZWFkSUQsIHZpZXdlcklELCB2aWV3ZXJMb2dpbn0pID0+IHtcbiAgY29uc3QgdmFyaWFibGVzID0ge1xuICAgIGlucHV0OiB7XG4gICAgICB0aHJlYWRJZDogdGhyZWFkSUQsXG4gICAgfSxcbiAgfTtcblxuICBjb25zdCBvcHRpbWlzdGljUmVzcG9uc2UgPSB7XG4gICAgdW5yZXNvbHZlUmV2aWV3VGhyZWFkOiB7XG4gICAgICB0aHJlYWQ6IHtcbiAgICAgICAgaWQ6IHRocmVhZElELFxuICAgICAgICBpc1Jlc29sdmVkOiBmYWxzZSxcbiAgICAgICAgdmlld2VyQ2FuUmVzb2x2ZTogdHJ1ZSxcbiAgICAgICAgdmlld2VyQ2FuVW5yZXNvbHZlOiBmYWxzZSxcbiAgICAgICAgcmVzb2x2ZWRCeToge1xuICAgICAgICAgIGlkOiB2aWV3ZXJJRCxcbiAgICAgICAgICBsb2dpbjogdmlld2VyTG9naW4gfHwgJ3lvdScsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0sXG4gIH07XG5cbiAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICBjb21taXRNdXRhdGlvbihcbiAgICAgIGVudmlyb25tZW50LFxuICAgICAge1xuICAgICAgICBtdXRhdGlvbixcbiAgICAgICAgdmFyaWFibGVzLFxuICAgICAgICBvcHRpbWlzdGljUmVzcG9uc2UsXG4gICAgICAgIG9uQ29tcGxldGVkOiByZXNvbHZlLFxuICAgICAgICBvbkVycm9yOiByZWplY3QsXG4gICAgICB9LFxuICAgICk7XG4gIH0pO1xufTtcbiJdfQ==