"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _reactRelay = require("react-relay");

var _moment = _interopRequireDefault(require("moment"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/updatePrReviewCommentMutation.graphql");

  if (node.hash && node.hash !== "d7b4e823f4604a2b193a1faceb3fcfca") {
    console.error("The definition of 'updatePrReviewCommentMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/updatePrReviewCommentMutation.graphql");
};

var _default = (environment, {
  commentId,
  commentBody
}) => {
  const variables = {
    input: {
      pullRequestReviewCommentId: commentId,
      body: commentBody
    }
  };
  const optimisticResponse = {
    updatePullRequestReviewComment: {
      pullRequestReviewComment: {
        id: commentId,
        lastEditedAt: (0, _moment.default)().toISOString(),
        body: commentBody,
        bodyHTML: (0, _helpers.renderMarkdown)(commentBody)
      }
    }
  };
  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticResponse,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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