"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemTypePropType = exports.UserStorePropType = exports.MergeConflictItemPropType = exports.MultiFilePatchPropType = exports.FilePatchItemPropType = exports.IssueishPropType = exports.RefresherPropType = exports.OperationStateObserverPropType = exports.EnableableOperationPropType = exports.RangePropType = exports.PointPropType = exports.RefHolderPropType = exports.RelayConnectionPropType = exports.AuthorPropType = exports.CommitPropType = exports.BranchSetPropType = exports.RemoteSetPropType = exports.SearchPropType = exports.BranchPropType = exports.EndpointPropType = exports.RemotePropType = exports.GithubLoginModelPropType = exports.WorkdirContextPoolPropType = exports.DOMNodePropType = exports.TokenPropType = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const TokenPropType = _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.symbol, _propTypes.default.instanceOf(Error)]);

exports.TokenPropType = TokenPropType;

const DOMNodePropType = (props, propName, componentName) => {
  if (props[propName] instanceof HTMLElement) {
    return null;
  } else {
    return new Error(`Invalid prop '${propName}' supplied to '${componentName}'. Value is not DOM element.`);
  }
};

exports.DOMNodePropType = DOMNodePropType;

const WorkdirContextPoolPropType = _propTypes.default.shape({
  getContext: _propTypes.default.func.isRequired
});

exports.WorkdirContextPoolPropType = WorkdirContextPoolPropType;

const GithubLoginModelPropType = _propTypes.default.shape({
  getToken: _propTypes.default.func.isRequired,
  setToken: _propTypes.default.func.isRequired,
  removeToken: _propTypes.default.func.isRequired,
  getScopes: _propTypes.default.func.isRequired,
  onDidUpdate: _propTypes.default.func.isRequired
});

exports.GithubLoginModelPropType = GithubLoginModelPropType;

const RemotePropType = _propTypes.default.shape({
  getName: _propTypes.default.func.isRequired,
  getUrl: _propTypes.default.func.isRequired,
  isGithubRepo: _propTypes.default.func.isRequired,
  getOwner: _propTypes.default.func.isRequired,
  getRepo: _propTypes.default.func.isRequired,
  getEndpoint: _propTypes.default.func.isRequired
});

exports.RemotePropType = RemotePropType;

const EndpointPropType = _propTypes.default.shape({
  getGraphQLRoot: _propTypes.default.func.isRequired,
  getRestRoot: _propTypes.default.func.isRequired,
  getRestURI: _propTypes.default.func.isRequired
});

exports.EndpointPropType = EndpointPropType;

const BranchPropType = _propTypes.default.shape({
  getName: _propTypes.default.func.isRequired,
  isDetached: _propTypes.default.func.isRequired,
  isPresent: _propTypes.default.func.isRequired
});

exports.BranchPropType = BranchPropType;

const SearchPropType = _propTypes.default.shape({
  getName: _propTypes.default.func.isRequired,
  createQuery: _propTypes.default.func.isRequired
});

exports.SearchPropType = SearchPropType;

const RemoteSetPropType = _propTypes.default.shape({
  withName: _propTypes.default.func.isRequired,
  isEmpty: _propTypes.default.func.isRequired,
  size: _propTypes.default.func.isRequired,
  [Symbol.iterator]: _propTypes.default.func.isRequired
});

exports.RemoteSetPropType = RemoteSetPropType;

const BranchSetPropType = _propTypes.default.shape({
  getNames: _propTypes.default.func.isRequired,
  getPullTargets: _propTypes.default.func.isRequired,
  getPushSources: _propTypes.default.func.isRequired
});

exports.BranchSetPropType = BranchSetPropType;

const CommitPropType = _propTypes.default.shape({
  getSha: _propTypes.default.func.isRequired,
  getMessageSubject: _propTypes.default.func.isRequired,
  isUnbornRef: _propTypes.default.func.isRequired,
  isPresent: _propTypes.default.func.isRequired
});

exports.CommitPropType = CommitPropType;

const AuthorPropType = _propTypes.default.shape({
  getEmail: _propTypes.default.func.isRequired,
  getFullName: _propTypes.default.func.isRequired,
  getAvatarUrl: _propTypes.default.func.isRequired
});

exports.AuthorPropType = AuthorPropType;

const RelayConnectionPropType = nodePropType => _propTypes.default.shape({
  edges: _propTypes.default.arrayOf(_propTypes.default.shape({
    cursor: _propTypes.default.string,
    node: nodePropType
  })),
  pageInfo: _propTypes.default.shape({
    endCursor: _propTypes.default.string,
    hasNextPage: _propTypes.default.bool,
    hasPreviousPage: _propTypes.default.bool,
    startCursor: _propTypes.default.string
  }),
  totalCount: _propTypes.default.number
});

exports.RelayConnectionPropType = RelayConnectionPropType;

const RefHolderPropType = _propTypes.default.shape({
  isEmpty: _propTypes.default.func.isRequired,
  get: _propTypes.default.func.isRequired,
  setter: _propTypes.default.func.isRequired,
  observe: _propTypes.default.func.isRequired
});

exports.RefHolderPropType = RefHolderPropType;

const PointPropType = _propTypes.default.shape({
  row: _propTypes.default.number.isRequired,
  column: _propTypes.default.number.isRequired,
  isEqual: _propTypes.default.func.isRequired
});

exports.PointPropType = PointPropType;

const RangePropType = _propTypes.default.shape({
  start: PointPropType.isRequired,
  end: PointPropType.isRequired,
  isEqual: _propTypes.default.func.isRequired
});

exports.RangePropType = RangePropType;

const EnableableOperationPropType = _propTypes.default.shape({
  isEnabled: _propTypes.default.func.isRequired,
  run: _propTypes.default.func.isRequired,
  getMessage: _propTypes.default.func.isRequired,
  why: _propTypes.default.func.isRequired
});

exports.EnableableOperationPropType = EnableableOperationPropType;

const OperationStateObserverPropType = _propTypes.default.shape({
  onDidComplete: _propTypes.default.func.isRequired,
  dispose: _propTypes.default.func.isRequired
});

exports.OperationStateObserverPropType = OperationStateObserverPropType;

const RefresherPropType = _propTypes.default.shape({
  setRetryCallback: _propTypes.default.func.isRequired,
  trigger: _propTypes.default.func.isRequired,
  deregister: _propTypes.default.func.isRequired
});

exports.RefresherPropType = RefresherPropType;

const IssueishPropType = _propTypes.default.shape({
  getNumber: _propTypes.default.func.isRequired,
  getTitle: _propTypes.default.func.isRequired,
  getGitHubURL: _propTypes.default.func.isRequired,
  getAuthorLogin: _propTypes.default.func.isRequired,
  getAuthorAvatarURL: _propTypes.default.func.isRequired,
  getCreatedAt: _propTypes.default.func.isRequired,
  getHeadRefName: _propTypes.default.func.isRequired,
  getHeadRepositoryID: _propTypes.default.func.isRequired,
  getStatusCounts: _propTypes.default.func.isRequired
});

exports.IssueishPropType = IssueishPropType;

const FilePatchItemPropType = _propTypes.default.shape({
  filePath: _propTypes.default.string.isRequired,
  status: _propTypes.default.string.isRequired
});

exports.FilePatchItemPropType = FilePatchItemPropType;

const MultiFilePatchPropType = _propTypes.default.shape({
  getFilePatches: _propTypes.default.func.isRequired
});

exports.MultiFilePatchPropType = MultiFilePatchPropType;
const statusNames = ['added', 'deleted', 'modified', 'typechange', 'equivalent'];

const MergeConflictItemPropType = _propTypes.default.shape({
  filePath: _propTypes.default.string.isRequired,
  status: _propTypes.default.shape({
    file: _propTypes.default.oneOf(statusNames).isRequired,
    ours: _propTypes.default.oneOf(statusNames).isRequired,
    theirs: _propTypes.default.oneOf(statusNames).isRequired
  }).isRequired
});

exports.MergeConflictItemPropType = MergeConflictItemPropType;

const UserStorePropType = _propTypes.default.shape({
  getUsers: _propTypes.default.func.isRequired,
  onDidUpdate: _propTypes.default.func.isRequired
}); // Require item classes lazily to prevent circular imports


exports.UserStorePropType = UserStorePropType;
let lazyItemConstructors = null;

function createItemTypePropType(required) {
  return function (props, propName, componentName) {
    if (lazyItemConstructors === null) {
      lazyItemConstructors = new Set();

      for (const itemPath of ['./items/changed-file-item', './items/commit-preview-item', './items/commit-detail-item', './items/issueish-detail-item']) {
        lazyItemConstructors.add(require(itemPath).default);
      }
    }

    if (props[propName] === undefined || props[propName] === null) {
      /* istanbul ignore else */
      if (required) {
        return new Error(`Missing required prop ${propName} on component ${componentName}.`);
      } else {
        return undefined;
      }
    }
    /* istanbul ignore if */


    if (!lazyItemConstructors.has(props[propName])) {
      const choices = Array.from(lazyItemConstructors, each => each.name).join(', ');
      return new Error(`Invalid prop "${propName}" supplied to ${componentName}. Must be one of ${choices}.`);
    }

    return undefined;
  };
}

const ItemTypePropType = createItemTypePropType(false);
exports.ItemTypePropType = ItemTypePropType;
ItemTypePropType.isRequired = createItemTypePropType(true);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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