"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

class TabGroup {
  constructor() {
    this.nodesByElement = new Map();
    this.lastElement = null;
    this.autofocusTarget = null;
  }

  appendElement(element, autofocus) {
    const lastNode = this.nodesByElement.get(this.lastElement) || {
      next: element,
      previous: element
    };
    const next = lastNode.next;
    const previous = this.lastElement || element;
    this.nodesByElement.set(element, {
      next,
      previous
    });
    this.nodesByElement.get(lastNode.next).previous = element;
    lastNode.next = element;
    this.lastElement = element;

    if (autofocus && this.autofocusTarget === null) {
      this.autofocusTarget = element;
    }
  }

  removeElement(element) {
    const node = this.nodesByElement.get(element);

    if (node) {
      const beforeNode = this.nodesByElement.get(node.previous);
      const afterNode = this.nodesByElement.get(node.next);
      beforeNode.next = node.next;
      afterNode.previous = node.previous;
    }

    this.nodesByElement.delete(element);
  }

  after(element) {
    const node = this.nodesByElement.get(element) || {
      next: undefined
    };
    return node.next;
  }

  focusAfter(element) {
    const original = this.getCurrentFocus();
    let next = this.after(element);

    while (next && next !== element) {
      next.focus();

      if (this.getCurrentFocus() !== original) {
        return;
      }

      next = this.after(next);
    }
  }

  before(element) {
    const node = this.nodesByElement.get(element) || {
      previous: undefined
    };
    return node.previous;
  }

  focusBefore(element) {
    const original = this.getCurrentFocus();
    let previous = this.before(element);

    while (previous && previous !== element) {
      previous.focus();

      if (this.getCurrentFocus() !== original) {
        return;
      }

      previous = this.before(previous);
    }
  }

  autofocus() {
    this.autofocusTarget && this.autofocusTarget.focus();
  }
  /* istanbul ignore next */


  getCurrentFocus() {
    return document.activeElement;
  }

}

exports.default = TabGroup;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRhYi1ncm91cC5qcyJdLCJuYW1lcyI6WyJUYWJHcm91cCIsImNvbnN0cnVjdG9yIiwibm9kZXNCeUVsZW1lbnQiLCJNYXAiLCJsYXN0RWxlbWVudCIsImF1dG9mb2N1c1RhcmdldCIsImFwcGVuZEVsZW1lbnQiLCJlbGVtZW50IiwiYXV0b2ZvY3VzIiwibGFzdE5vZGUiLCJnZXQiLCJuZXh0IiwicHJldmlvdXMiLCJzZXQiLCJyZW1vdmVFbGVtZW50Iiwibm9kZSIsImJlZm9yZU5vZGUiLCJhZnRlck5vZGUiLCJkZWxldGUiLCJhZnRlciIsInVuZGVmaW5lZCIsImZvY3VzQWZ0ZXIiLCJvcmlnaW5hbCIsImdldEN1cnJlbnRGb2N1cyIsImZvY3VzIiwiYmVmb3JlIiwiZm9jdXNCZWZvcmUiLCJkb2N1bWVudCIsImFjdGl2ZUVsZW1lbnQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBZSxNQUFNQSxRQUFOLENBQWU7QUFDNUJDLEVBQUFBLFdBQVcsR0FBRztBQUNaLFNBQUtDLGNBQUwsR0FBc0IsSUFBSUMsR0FBSixFQUF0QjtBQUNBLFNBQUtDLFdBQUwsR0FBbUIsSUFBbkI7QUFDQSxTQUFLQyxlQUFMLEdBQXVCLElBQXZCO0FBQ0Q7O0FBRURDLEVBQUFBLGFBQWEsQ0FBQ0MsT0FBRCxFQUFVQyxTQUFWLEVBQXFCO0FBQ2hDLFVBQU1DLFFBQVEsR0FBRyxLQUFLUCxjQUFMLENBQW9CUSxHQUFwQixDQUF3QixLQUFLTixXQUE3QixLQUE2QztBQUFDTyxNQUFBQSxJQUFJLEVBQUVKLE9BQVA7QUFBZ0JLLE1BQUFBLFFBQVEsRUFBRUw7QUFBMUIsS0FBOUQ7QUFDQSxVQUFNSSxJQUFJLEdBQUdGLFFBQVEsQ0FBQ0UsSUFBdEI7QUFDQSxVQUFNQyxRQUFRLEdBQUcsS0FBS1IsV0FBTCxJQUFvQkcsT0FBckM7QUFFQSxTQUFLTCxjQUFMLENBQW9CVyxHQUFwQixDQUF3Qk4sT0FBeEIsRUFBaUM7QUFBQ0ksTUFBQUEsSUFBRDtBQUFPQyxNQUFBQTtBQUFQLEtBQWpDO0FBQ0EsU0FBS1YsY0FBTCxDQUFvQlEsR0FBcEIsQ0FBd0JELFFBQVEsQ0FBQ0UsSUFBakMsRUFBdUNDLFFBQXZDLEdBQWtETCxPQUFsRDtBQUNBRSxJQUFBQSxRQUFRLENBQUNFLElBQVQsR0FBZ0JKLE9BQWhCO0FBRUEsU0FBS0gsV0FBTCxHQUFtQkcsT0FBbkI7O0FBRUEsUUFBSUMsU0FBUyxJQUFJLEtBQUtILGVBQUwsS0FBeUIsSUFBMUMsRUFBZ0Q7QUFDOUMsV0FBS0EsZUFBTCxHQUF1QkUsT0FBdkI7QUFDRDtBQUNGOztBQUVETyxFQUFBQSxhQUFhLENBQUNQLE9BQUQsRUFBVTtBQUNyQixVQUFNUSxJQUFJLEdBQUcsS0FBS2IsY0FBTCxDQUFvQlEsR0FBcEIsQ0FBd0JILE9BQXhCLENBQWI7O0FBQ0EsUUFBSVEsSUFBSixFQUFVO0FBQ1IsWUFBTUMsVUFBVSxHQUFHLEtBQUtkLGNBQUwsQ0FBb0JRLEdBQXBCLENBQXdCSyxJQUFJLENBQUNILFFBQTdCLENBQW5CO0FBQ0EsWUFBTUssU0FBUyxHQUFHLEtBQUtmLGNBQUwsQ0FBb0JRLEdBQXBCLENBQXdCSyxJQUFJLENBQUNKLElBQTdCLENBQWxCO0FBRUFLLE1BQUFBLFVBQVUsQ0FBQ0wsSUFBWCxHQUFrQkksSUFBSSxDQUFDSixJQUF2QjtBQUNBTSxNQUFBQSxTQUFTLENBQUNMLFFBQVYsR0FBcUJHLElBQUksQ0FBQ0gsUUFBMUI7QUFDRDs7QUFDRCxTQUFLVixjQUFMLENBQW9CZ0IsTUFBcEIsQ0FBMkJYLE9BQTNCO0FBQ0Q7O0FBRURZLEVBQUFBLEtBQUssQ0FBQ1osT0FBRCxFQUFVO0FBQ2IsVUFBTVEsSUFBSSxHQUFHLEtBQUtiLGNBQUwsQ0FBb0JRLEdBQXBCLENBQXdCSCxPQUF4QixLQUFvQztBQUFDSSxNQUFBQSxJQUFJLEVBQUVTO0FBQVAsS0FBakQ7QUFDQSxXQUFPTCxJQUFJLENBQUNKLElBQVo7QUFDRDs7QUFFRFUsRUFBQUEsVUFBVSxDQUFDZCxPQUFELEVBQVU7QUFDbEIsVUFBTWUsUUFBUSxHQUFHLEtBQUtDLGVBQUwsRUFBakI7QUFDQSxRQUFJWixJQUFJLEdBQUcsS0FBS1EsS0FBTCxDQUFXWixPQUFYLENBQVg7O0FBQ0EsV0FBT0ksSUFBSSxJQUFJQSxJQUFJLEtBQUtKLE9BQXhCLEVBQWlDO0FBQy9CSSxNQUFBQSxJQUFJLENBQUNhLEtBQUw7O0FBQ0EsVUFBSSxLQUFLRCxlQUFMLE9BQTJCRCxRQUEvQixFQUF5QztBQUN2QztBQUNEOztBQUVEWCxNQUFBQSxJQUFJLEdBQUcsS0FBS1EsS0FBTCxDQUFXUixJQUFYLENBQVA7QUFDRDtBQUNGOztBQUVEYyxFQUFBQSxNQUFNLENBQUNsQixPQUFELEVBQVU7QUFDZCxVQUFNUSxJQUFJLEdBQUcsS0FBS2IsY0FBTCxDQUFvQlEsR0FBcEIsQ0FBd0JILE9BQXhCLEtBQW9DO0FBQUNLLE1BQUFBLFFBQVEsRUFBRVE7QUFBWCxLQUFqRDtBQUNBLFdBQU9MLElBQUksQ0FBQ0gsUUFBWjtBQUNEOztBQUVEYyxFQUFBQSxXQUFXLENBQUNuQixPQUFELEVBQVU7QUFDbkIsVUFBTWUsUUFBUSxHQUFHLEtBQUtDLGVBQUwsRUFBakI7QUFDQSxRQUFJWCxRQUFRLEdBQUcsS0FBS2EsTUFBTCxDQUFZbEIsT0FBWixDQUFmOztBQUNBLFdBQU9LLFFBQVEsSUFBSUEsUUFBUSxLQUFLTCxPQUFoQyxFQUF5QztBQUN2Q0ssTUFBQUEsUUFBUSxDQUFDWSxLQUFUOztBQUNBLFVBQUksS0FBS0QsZUFBTCxPQUEyQkQsUUFBL0IsRUFBeUM7QUFDdkM7QUFDRDs7QUFFRFYsTUFBQUEsUUFBUSxHQUFHLEtBQUthLE1BQUwsQ0FBWWIsUUFBWixDQUFYO0FBQ0Q7QUFDRjs7QUFFREosRUFBQUEsU0FBUyxHQUFHO0FBQ1YsU0FBS0gsZUFBTCxJQUF3QixLQUFLQSxlQUFMLENBQXFCbUIsS0FBckIsRUFBeEI7QUFDRDtBQUVEOzs7QUFDQUQsRUFBQUEsZUFBZSxHQUFHO0FBQ2hCLFdBQU9JLFFBQVEsQ0FBQ0MsYUFBaEI7QUFDRDs7QUE5RTJCIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGNsYXNzIFRhYkdyb3VwIHtcbiAgY29uc3RydWN0b3IoKSB7XG4gICAgdGhpcy5ub2Rlc0J5RWxlbWVudCA9IG5ldyBNYXAoKTtcbiAgICB0aGlzLmxhc3RFbGVtZW50ID0gbnVsbDtcbiAgICB0aGlzLmF1dG9mb2N1c1RhcmdldCA9IG51bGw7XG4gIH1cblxuICBhcHBlbmRFbGVtZW50KGVsZW1lbnQsIGF1dG9mb2N1cykge1xuICAgIGNvbnN0IGxhc3ROb2RlID0gdGhpcy5ub2Rlc0J5RWxlbWVudC5nZXQodGhpcy5sYXN0RWxlbWVudCkgfHwge25leHQ6IGVsZW1lbnQsIHByZXZpb3VzOiBlbGVtZW50fTtcbiAgICBjb25zdCBuZXh0ID0gbGFzdE5vZGUubmV4dDtcbiAgICBjb25zdCBwcmV2aW91cyA9IHRoaXMubGFzdEVsZW1lbnQgfHwgZWxlbWVudDtcblxuICAgIHRoaXMubm9kZXNCeUVsZW1lbnQuc2V0KGVsZW1lbnQsIHtuZXh0LCBwcmV2aW91c30pO1xuICAgIHRoaXMubm9kZXNCeUVsZW1lbnQuZ2V0KGxhc3ROb2RlLm5leHQpLnByZXZpb3VzID0gZWxlbWVudDtcbiAgICBsYXN0Tm9kZS5uZXh0ID0gZWxlbWVudDtcblxuICAgIHRoaXMubGFzdEVsZW1lbnQgPSBlbGVtZW50O1xuXG4gICAgaWYgKGF1dG9mb2N1cyAmJiB0aGlzLmF1dG9mb2N1c1RhcmdldCA9PT0gbnVsbCkge1xuICAgICAgdGhpcy5hdXRvZm9jdXNUYXJnZXQgPSBlbGVtZW50O1xuICAgIH1cbiAgfVxuXG4gIHJlbW92ZUVsZW1lbnQoZWxlbWVudCkge1xuICAgIGNvbnN0IG5vZGUgPSB0aGlzLm5vZGVzQnlFbGVtZW50LmdldChlbGVtZW50KTtcbiAgICBpZiAobm9kZSkge1xuICAgICAgY29uc3QgYmVmb3JlTm9kZSA9IHRoaXMubm9kZXNCeUVsZW1lbnQuZ2V0KG5vZGUucHJldmlvdXMpO1xuICAgICAgY29uc3QgYWZ0ZXJOb2RlID0gdGhpcy5ub2Rlc0J5RWxlbWVudC5nZXQobm9kZS5uZXh0KTtcblxuICAgICAgYmVmb3JlTm9kZS5uZXh0ID0gbm9kZS5uZXh0O1xuICAgICAgYWZ0ZXJOb2RlLnByZXZpb3VzID0gbm9kZS5wcmV2aW91cztcbiAgICB9XG4gICAgdGhpcy5ub2Rlc0J5RWxlbWVudC5kZWxldGUoZWxlbWVudCk7XG4gIH1cblxuICBhZnRlcihlbGVtZW50KSB7XG4gICAgY29uc3Qgbm9kZSA9IHRoaXMubm9kZXNCeUVsZW1lbnQuZ2V0KGVsZW1lbnQpIHx8IHtuZXh0OiB1bmRlZmluZWR9O1xuICAgIHJldHVybiBub2RlLm5leHQ7XG4gIH1cblxuICBmb2N1c0FmdGVyKGVsZW1lbnQpIHtcbiAgICBjb25zdCBvcmlnaW5hbCA9IHRoaXMuZ2V0Q3VycmVudEZvY3VzKCk7XG4gICAgbGV0IG5leHQgPSB0aGlzLmFmdGVyKGVsZW1lbnQpO1xuICAgIHdoaWxlIChuZXh0ICYmIG5leHQgIT09IGVsZW1lbnQpIHtcbiAgICAgIG5leHQuZm9jdXMoKTtcbiAgICAgIGlmICh0aGlzLmdldEN1cnJlbnRGb2N1cygpICE9PSBvcmlnaW5hbCkge1xuICAgICAgICByZXR1cm47XG4gICAgICB9XG5cbiAgICAgIG5leHQgPSB0aGlzLmFmdGVyKG5leHQpO1xuICAgIH1cbiAgfVxuXG4gIGJlZm9yZShlbGVtZW50KSB7XG4gICAgY29uc3Qgbm9kZSA9IHRoaXMubm9kZXNCeUVsZW1lbnQuZ2V0KGVsZW1lbnQpIHx8IHtwcmV2aW91czogdW5kZWZpbmVkfTtcbiAgICByZXR1cm4gbm9kZS5wcmV2aW91cztcbiAgfVxuXG4gIGZvY3VzQmVmb3JlKGVsZW1lbnQpIHtcbiAgICBjb25zdCBvcmlnaW5hbCA9IHRoaXMuZ2V0Q3VycmVudEZvY3VzKCk7XG4gICAgbGV0IHByZXZpb3VzID0gdGhpcy5iZWZvcmUoZWxlbWVudCk7XG4gICAgd2hpbGUgKHByZXZpb3VzICYmIHByZXZpb3VzICE9PSBlbGVtZW50KSB7XG4gICAgICBwcmV2aW91cy5mb2N1cygpO1xuICAgICAgaWYgKHRoaXMuZ2V0Q3VycmVudEZvY3VzKCkgIT09IG9yaWdpbmFsKSB7XG4gICAgICAgIHJldHVybjtcbiAgICAgIH1cblxuICAgICAgcHJldmlvdXMgPSB0aGlzLmJlZm9yZShwcmV2aW91cyk7XG4gICAgfVxuICB9XG5cbiAgYXV0b2ZvY3VzKCkge1xuICAgIHRoaXMuYXV0b2ZvY3VzVGFyZ2V0ICYmIHRoaXMuYXV0b2ZvY3VzVGFyZ2V0LmZvY3VzKCk7XG4gIH1cblxuICAvKiBpc3RhbmJ1bCBpZ25vcmUgbmV4dCAqL1xuICBnZXRDdXJyZW50Rm9jdXMoKSB7XG4gICAgcmV0dXJuIGRvY3VtZW50LmFjdGl2ZUVsZW1lbnQ7XG4gIH1cbn1cbiJdfQ==