"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Accordion extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'toggle');
    this.state = {
      expanded: true
    };
  }

  render() {
    return _react.default.createElement("details", {
      className: "github-Accordion",
      open: this.state.expanded
    }, _react.default.createElement("summary", {
      className: "github-Accordion-header",
      onClick: this.toggle
    }, this.renderHeader()), _react.default.createElement("main", {
      className: "github-Accordion-content"
    }, this.renderContent()));
  }

  renderHeader() {
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("span", {
      className: "github-Accordion--leftTitle"
    }, this.props.leftTitle), this.props.rightTitle && _react.default.createElement("span", {
      className: "github-Accordion--rightTitle"
    }, this.props.rightTitle), this.props.reviewsButton());
  }

  renderContent() {
    if (this.props.isLoading) {
      const Loading = this.props.loadingComponent;
      return _react.default.createElement(Loading, null);
    }

    if (this.props.results.length === 0) {
      const Empty = this.props.emptyComponent;
      return _react.default.createElement(Empty, null);
    }

    if (!this.state.expanded) {
      return null;
    }

    const More = this.props.moreComponent;
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("ul", {
      className: "github-Accordion-list"
    }, this.props.results.map((item, index) => {
      const key = item.key !== undefined ? item.key : index;
      return _react.default.createElement("li", {
        className: "github-Accordion-listItem",
        key: key,
        onClick: () => this.props.onClickItem(item)
      }, this.props.children(item));
    })), this.props.results.length < this.props.total && _react.default.createElement(More, null));
  }

  toggle(e) {
    e.preventDefault();
    return new Promise(resolve => {
      this.setState(prevState => ({
        expanded: !prevState.expanded
      }), resolve);
    });
  }

}

exports.default = Accordion;

_defineProperty(Accordion, "propTypes", {
  leftTitle: _propTypes.default.string.isRequired,
  rightTitle: _propTypes.default.string,
  results: _propTypes.default.arrayOf(_propTypes.default.any).isRequired,
  total: _propTypes.default.number.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  loadingComponent: _propTypes.default.func,
  emptyComponent: _propTypes.default.func,
  moreComponent: _propTypes.default.func,
  reviewsButton: _propTypes.default.func,
  onClickItem: _propTypes.default.func,
  children: _propTypes.default.func.isRequired
});

_defineProperty(Accordion, "defaultProps", {
  loadingComponent: () => null,
  emptyComponent: () => null,
  moreComponent: () => null,
  onClickItem: () => {},
  reviewsButton: () => null
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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