"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _propTypes2 = require("../prop-types");

var _gitShellOutStrategy = require("../git-shell-out-strategy");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BranchMenuView extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      createNew: false,
      checkedOutBranch: null
    });

    _defineProperty(this, "didSelectItem", async event => {
      const branchName = event.target.value;
      await this.checkout(branchName);
    });

    _defineProperty(this, "createBranch", async () => {
      if (this.state.createNew) {
        const branchName = this.editorElement.getModel().getText().trim();
        await this.checkout(branchName, {
          createNew: true
        });
      } else {
        await new Promise(resolve => {
          this.setState({
            createNew: true
          }, () => {
            this.editorElement.focus();
            resolve();
          });
        });
      }
    });

    _defineProperty(this, "checkout", async (branchName, options) => {
      this.editorElement.classList.remove('is-focused');
      await new Promise(resolve => {
        this.setState({
          checkedOutBranch: branchName
        }, resolve);
      });

      try {
        await this.props.checkout(branchName, options);
        await new Promise(resolve => {
          this.setState({
            checkedOutBranch: null,
            createNew: false
          }, resolve);
        });
        this.editorElement.getModel().setText('');
      } catch (error) {
        this.editorElement.classList.add('is-focused');
        await new Promise(resolve => {
          this.setState({
            checkedOutBranch: null
          }, resolve);
        });

        if (!(error instanceof _gitShellOutStrategy.GitError)) {
          throw error;
        }
      }
    });

    _defineProperty(this, "cancelCreateNewBranch", () => {
      this.setState({
        createNew: false
      });
    });
  }

  render() {
    const branchNames = this.props.branches.getNames().filter(Boolean);
    let currentBranchName = this.props.currentBranch.isDetached() ? 'detached' : this.props.currentBranch.getName();

    if (this.state.checkedOutBranch) {
      currentBranchName = this.state.checkedOutBranch;

      if (branchNames.indexOf(this.state.checkedOutBranch) === -1) {
        branchNames.push(this.state.checkedOutBranch);
      }
    }

    const disableControls = !!this.state.checkedOutBranch;
    const branchEditorClasses = (0, _classnames.default)('github-BranchMenuView-item', 'github-BranchMenuView-editor', {
      hidden: !this.state.createNew
    });
    const branchSelectListClasses = (0, _classnames.default)('github-BranchMenuView-item', 'github-BranchMenuView-select', 'input-select', {
      hidden: !!this.state.createNew
    });
    const iconClasses = (0, _classnames.default)('github-BranchMenuView-item', 'icon', {
      'icon-git-branch': !disableControls,
      'icon-sync': disableControls
    });

    const newBranchEditor = _react.default.createElement("div", {
      className: branchEditorClasses
    }, _react.default.createElement("atom-text-editor", {
      ref: e => {
        this.editorElement = e;
      },
      mini: true,
      readonly: disableControls ? true : undefined
    }));

    const selectBranchView =
    /* eslint-disable jsx-a11y/no-onchange */
    _react.default.createElement("select", {
      className: branchSelectListClasses,
      onChange: this.didSelectItem,
      disabled: disableControls,
      value: currentBranchName
    }, this.props.currentBranch.isDetached() && _react.default.createElement("option", {
      key: "detached",
      value: "detached",
      disabled: true
    }, this.props.currentBranch.getName()), branchNames.map(branchName => {
      return _react.default.createElement("option", {
        key: `branch-${branchName}`,
        value: branchName
      }, branchName);
    }));

    return _react.default.createElement("div", {
      className: "github-BranchMenuView"
    }, _react.default.createElement(_commands.default, {
      registry: this.props.commands,
      target: ".github-BranchMenuView-editor atom-text-editor[mini]"
    }, _react.default.createElement(_commands.Command, {
      command: "tool-panel:unfocus",
      callback: this.cancelCreateNewBranch
    }), _react.default.createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancelCreateNewBranch
    }), _react.default.createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.createBranch
    })), _react.default.createElement("div", {
      className: "github-BranchMenuView-selector"
    }, _react.default.createElement("span", {
      className: iconClasses
    }), newBranchEditor, selectBranchView, _react.default.createElement("button", {
      className: "github-BranchMenuView-item github-BranchMenuView-button btn",
      onClick: this.createBranch,
      disabled: disableControls
    }, " New Branch ")));
  }

}

exports.default = BranchMenuView;

_defineProperty(BranchMenuView, "propTypes", {
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  notificationManager: _propTypes.default.object.isRequired,
  // Model
  repository: _propTypes.default.object,
  branches: _propTypes2.BranchSetPropType.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  checkout: _propTypes.default.func
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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