"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BranchView extends _react.default.Component {
  render() {
    const classNames = (0, _classnames.default)('github-branch', 'inline-block', {
      'github-branch-detached': this.props.currentBranch.isDetached()
    });
    return _react.default.createElement("div", {
      className: classNames,
      ref: this.props.refRoot
    }, _react.default.createElement("span", {
      className: "icon icon-git-branch"
    }), _react.default.createElement("span", {
      className: "branch-label"
    }, this.props.currentBranch.getName()));
  }

}

exports.default = BranchView;

_defineProperty(BranchView, "propTypes", {
  currentBranch: _propTypes2.BranchPropType.isRequired,
  refRoot: _propTypes.default.func
});

_defineProperty(BranchView, "defaultProps", {
  refRoot: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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