"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _dialogView = _interopRequireDefault(require("./dialog-view"));

var _repositoryHomeSelectionView = _interopRequireDefault(require("./repository-home-selection-view"));

var _directorySelect = _interopRequireDefault(require("./directory-select"));

var _remoteConfigurationView = _interopRequireDefault(require("./remote-configuration-view"));

var _tabGroup = _interopRequireDefault(require("../tab-group"));

var _tabbable = require("./tabbable");

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const DIALOG_TEXT = {
  create: {
    heading: 'Create GitHub repository',
    hostPath: 'Destination path:',
    progressMessage: 'Creating repository...',
    acceptText: 'Create'
  },
  publish: {
    heading: 'Publish GitHub repository',
    hostPath: 'Local path:',
    progressMessage: 'Publishing repository...',
    acceptText: 'Publish'
  }
};

class CreateDialogView extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "didChangeVisibility", event => this.props.didChangeVisibility(event.target.value));

    this.tabGroup = new _tabGroup.default();
  }

  render() {
    const text = DIALOG_TEXT[this.props.request.identifier];
    return _react.default.createElement(_dialogView.default, {
      progressMessage: text.progressMessage,
      acceptEnabled: this.props.acceptEnabled,
      acceptText: text.acceptText,
      accept: this.props.accept,
      cancel: this.props.request.cancel,
      tabGroup: this.tabGroup,
      inProgress: this.props.inProgress,
      error: this.props.error,
      workspace: this.props.workspace,
      commands: this.props.commands
    }, _react.default.createElement("h1", {
      className: "github-Create-header"
    }, _react.default.createElement(_octicon.default, {
      icon: "globe"
    }), text.heading), _react.default.createElement("div", {
      className: "github-Create-repo block"
    }, _react.default.createElement(_repositoryHomeSelectionView.default, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      autofocusName: true,
      user: this.props.user,
      nameBuffer: this.props.repoName,
      selectedOwnerID: this.props.selectedOwnerID,
      didChangeOwnerID: this.props.didChangeOwnerID,
      isLoading: this.props.isLoading
    })), _react.default.createElement("div", {
      className: "github-Create-visibility block"
    }, _react.default.createElement("span", {
      className: "github-Create-visibilityHeading"
    }, "Visibility:"), _react.default.createElement("label", {
      className: "github-Create-visibilityOption input-label"
    }, _react.default.createElement(_tabbable.TabbableInput, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      className: "input-radio",
      type: "radio",
      name: "visibility",
      value: "PUBLIC",
      checked: this.props.selectedVisibility === 'PUBLIC',
      onChange: this.didChangeVisibility
    }), _react.default.createElement(_octicon.default, {
      icon: "globe"
    }), "Public"), _react.default.createElement("label", {
      className: "github-Create-visibilityOption input-label"
    }, _react.default.createElement(_tabbable.TabbableInput, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      className: "input-radio",
      type: "radio",
      name: "visibility",
      value: "PRIVATE",
      checked: this.props.selectedVisibility === 'PRIVATE',
      onChange: this.didChangeVisibility
    }), _react.default.createElement(_octicon.default, {
      icon: "mirror-private"
    }), "Private")), _react.default.createElement("div", {
      className: "github-Create-localPath"
    }, _react.default.createElement(_directorySelect.default, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      currentWindow: this.props.currentWindow,
      buffer: this.props.localPath,
      disabled: this.props.request.identifier === 'publish'
    })), _react.default.createElement(_remoteConfigurationView.default, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      currentProtocol: this.props.selectedProtocol,
      didChangeProtocol: this.props.didChangeProtocol,
      sourceRemoteBuffer: this.props.sourceRemoteName
    }));
  }

  componentDidMount() {
    this.tabGroup.autofocus();
  }

}

exports.default = CreateDialogView;

_defineProperty(CreateDialogView, "propTypes", {
  // Relay
  user: _propTypes.default.object,
  // Model
  request: _propTypes.default.shape({
    identifier: _propTypes.default.oneOf(['create', 'publish']).isRequired,
    getParams: _propTypes.default.func.isRequired,
    cancel: _propTypes.default.func.isRequired
  }).isRequired,
  error: _propTypes.default.instanceOf(Error),
  isLoading: _propTypes.default.bool.isRequired,
  inProgress: _propTypes.default.bool.isRequired,
  selectedOwnerID: _propTypes.default.string.isRequired,
  repoName: _propTypes.default.object.isRequired,
  selectedVisibility: _propTypes.default.oneOf(['PUBLIC', 'PRIVATE']).isRequired,
  localPath: _propTypes.default.object.isRequired,
  sourceRemoteName: _propTypes.default.object.isRequired,
  selectedProtocol: _propTypes.default.oneOf(['https', 'ssh']).isRequired,
  acceptEnabled: _propTypes.default.bool.isRequired,
  // Change callbacks
  didChangeOwnerID: _propTypes.default.func.isRequired,
  didChangeVisibility: _propTypes.default.func.isRequired,
  didChangeProtocol: _propTypes.default.func.isRequired,
  accept: _propTypes.default.func.isRequired,
  // Atom environment
  currentWindow: _propTypes.default.object.isRequired,
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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