"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRepository = createRepository;
exports.publishRepository = publishRepository;
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _createDialogContainer = _interopRequireDefault(require("../containers/create-dialog-container"));

var _createRepository = _interopRequireDefault(require("../mutations/create-repository"));

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CreateDialog extends _react.default.Component {
  render() {
    return _react.default.createElement(_createDialogContainer.default, this.props);
  }

}

exports.default = CreateDialog;

_defineProperty(CreateDialog, "propTypes", {
  // Model
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  request: _propTypes.default.object.isRequired,
  error: _propTypes.default.instanceOf(Error),
  inProgress: _propTypes.default.bool.isRequired,
  // Atom environment
  currentWindow: _propTypes.default.object.isRequired,
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired
});

async function createRepository({
  ownerID,
  name,
  visibility,
  localPath,
  protocol,
  sourceRemoteName
}, {
  clone,
  relayEnvironment
}) {
  await _fsExtra.default.ensureDir(localPath, 0o755);
  const result = await (0, _createRepository.default)(relayEnvironment, {
    name,
    ownerID,
    visibility
  });
  const sourceURL = result.createRepository.repository[protocol === 'ssh' ? 'sshUrl' : 'url'];
  await clone(sourceURL, localPath, sourceRemoteName);
  (0, _reporterProxy.addEvent)('create-github-repository', {
    package: 'github'
  });
}

async function publishRepository({
  ownerID,
  name,
  visibility,
  protocol,
  sourceRemoteName
}, {
  repository,
  relayEnvironment
}) {
  let defaultBranchName, wasEmpty;

  if (repository.isEmpty()) {
    wasEmpty = true;
    await repository.init();
    defaultBranchName = 'master';
  } else {
    wasEmpty = false;
    const branchSet = await repository.getBranches();
    const branchNames = new Set(branchSet.getNames());

    if (branchNames.has('master')) {
      defaultBranchName = 'master';
    } else {
      const head = branchSet.getHeadBranch();

      if (head.isPresent()) {
        defaultBranchName = head.getName();
      }
    }
  }

  if (!defaultBranchName) {
    throw new Error('Unable to determine the desired default branch from the repository');
  }

  const result = await (0, _createRepository.default)(relayEnvironment, {
    name,
    ownerID,
    visibility
  });
  const sourceURL = result.createRepository.repository[protocol === 'ssh' ? 'sshUrl' : 'url'];
  const remote = await repository.addRemote(sourceRemoteName, sourceURL);

  if (wasEmpty) {
    (0, _reporterProxy.addEvent)('publish-github-repository', {
      package: 'github'
    });
  } else {
    await repository.push(defaultBranchName, {
      remote,
      setUpstream: true
    });
    (0, _reporterProxy.addEvent)('init-publish-github-repository', {
      package: 'github'
    });
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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