"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _dialogView = _interopRequireDefault(require("./dialog-view"));

var _tabGroup = _interopRequireDefault(require("../tab-group"));

var _tabbable = require("./tabbable");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CredentialDialog extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "accept", () => {
      if (!this.canSignIn()) {
        return Promise.resolve();
      }

      const request = this.props.request;
      const params = request.getParams();
      const payload = {
        password: this.state.password
      };

      if (params.includeUsername) {
        payload.username = this.state.username;
      }

      if (params.includeRemember) {
        payload.remember = this.state.remember;
      }

      return request.accept(payload);
    });

    _defineProperty(this, "didChangeUsername", e => this.setState({
      username: e.target.value
    }));

    _defineProperty(this, "didChangePassword", e => this.setState({
      password: e.target.value
    }));

    _defineProperty(this, "didChangeRemember", e => this.setState({
      remember: e.target.checked
    }));

    _defineProperty(this, "toggleShowPassword", () => this.setState({
      showPassword: !this.state.showPassword
    }));

    this.tabGroup = new _tabGroup.default();
    this.state = {
      username: '',
      password: '',
      remember: false,
      showPassword: false
    };
  }

  render() {
    const request = this.props.request;
    const params = request.getParams();
    return _react.default.createElement(_dialogView.default, {
      prompt: params.prompt,
      acceptEnabled: this.canSignIn(),
      acceptText: "Sign in",
      accept: this.accept,
      cancel: request.cancel,
      tabGroup: this.tabGroup,
      inProgress: this.props.inProgress,
      error: this.props.error,
      workspace: this.props.workspace,
      commands: this.props.commands
    }, params.includeUsername && _react.default.createElement("label", {
      className: "github-DialogLabel github-DialogLabel--horizontal"
    }, "Username:", _react.default.createElement(_tabbable.TabbableInput, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      autofocus: true,
      type: "text",
      className: "input-text native-key-bindings github-Credential-username",
      value: this.state.username,
      onChange: this.didChangeUsername
    })), _react.default.createElement("label", {
      className: "github-DialogLabel github-DialogLabel--horizontal"
    }, "Password:", _react.default.createElement(_tabbable.TabbableInput, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      autofocus: true,
      type: this.state.showPassword ? 'text' : 'password',
      className: "input-text native-key-bindings github-Credential-password",
      value: this.state.password,
      onChange: this.didChangePassword
    }), _react.default.createElement(_tabbable.TabbableButton, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      className: "github-Dialog--insetButton github-Credential-visibility",
      onClick: this.toggleShowPassword
    }, this.state.showPassword ? 'Hide' : 'Show')), params.includeRemember && _react.default.createElement("label", {
      className: "github-DialogLabel github-DialogLabel--horizontal github-Credential-rememberLabel"
    }, _react.default.createElement(_tabbable.TabbableInput, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      className: "input-checkbox github-Credential-remember",
      type: "checkbox",
      checked: this.state.remember,
      onChange: this.didChangeRemember
    }), "Remember"));
  }

  componentDidMount() {
    this.tabGroup.autofocus();
  }

  canSignIn() {
    return !this.props.request.getParams().includeUsername || this.state.username.length > 0;
  }

}

exports.default = CredentialDialog;

_defineProperty(CredentialDialog, "propTypes", {
  // Model
  request: _propTypes.default.shape({
    getParams: _propTypes.default.func.isRequired,
    accept: _propTypes.default.func.isRequired,
    cancel: _propTypes.default.func.isRequired
  }).isRequired,
  inProgress: _propTypes.default.bool,
  error: _propTypes.default.instanceOf(Error),
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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