"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _panel = _interopRequireDefault(require("../atom/panel"));

var _tabbable = require("./tabbable");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class DialogView extends _react.default.Component {
  render() {
    return _react.default.createElement(_panel.default, {
      workspace: this.props.workspace,
      location: "modal"
    }, _react.default.createElement("div", {
      className: "github-Dialog"
    }, _react.default.createElement(_commands.default, {
      registry: this.props.commands,
      target: ".github-Dialog"
    }, _react.default.createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.props.accept
    }), _react.default.createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.props.cancel
    })), this.props.prompt && _react.default.createElement("header", {
      className: "github-DialogPrompt"
    }, this.props.prompt), _react.default.createElement("main", {
      className: "github-DialogForm"
    }, this.props.children), _react.default.createElement("footer", {
      className: "github-DialogFooter"
    }, _react.default.createElement("div", {
      className: "github-DialogInfo"
    }, this.props.progressMessage && this.props.inProgress && _react.default.createElement(_react.Fragment, null, _react.default.createElement("span", {
      className: "inline-block loading loading-spinner-small"
    }), _react.default.createElement("span", {
      className: "github-DialogProgress-message"
    }, this.props.progressMessage)), this.props.error && _react.default.createElement("ul", {
      className: "error-messages"
    }, _react.default.createElement("li", null, this.props.error.userMessage || this.props.error.message))), _react.default.createElement("div", {
      className: "github-DialogButtons"
    }, _react.default.createElement(_tabbable.TabbableButton, {
      tabGroup: this.props.tabGroup,
      commands: this.props.commands,
      className: "btn github-Dialog-cancelButton",
      onClick: this.props.cancel
    }, "Cancel"), _react.default.createElement(_tabbable.TabbableButton, {
      tabGroup: this.props.tabGroup,
      commands: this.props.commands,
      className: (0, _classnames.default)('btn btn-primary github-Dialog-acceptButton', this.props.acceptClassName),
      onClick: this.props.accept,
      disabled: this.props.inProgress || !this.props.acceptEnabled
    }, this.props.acceptText)))));
  }

}

exports.default = DialogView;

_defineProperty(DialogView, "propTypes", {
  // Customization
  prompt: _propTypes.default.string,
  progressMessage: _propTypes.default.string,
  acceptEnabled: _propTypes.default.bool,
  acceptClassName: _propTypes.default.string,
  acceptText: _propTypes.default.string,
  // Callbacks
  accept: _propTypes.default.func.isRequired,
  cancel: _propTypes.default.func.isRequired,
  // State
  tabGroup: _propTypes.default.object.isRequired,
  inProgress: _propTypes.default.bool.isRequired,
  error: _propTypes.default.instanceOf(Error),
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired,
  // Form content
  children: _propTypes.default.node.isRequired
});

_defineProperty(DialogView, "defaultProps", {
  acceptEnabled: true,
  acceptText: 'Accept'
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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